/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.config.support;

import com.sun.enterprise.security.store.DomainScopedPasswordAliasStore;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigValue;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.glassfish.config.support.Strings;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigView;

public class TranslatedConfigView
implements ConfigView {
    public static final ThreadLocal<Boolean> doSubstitution = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.TRUE;
        }
    };
    static final Pattern p = Pattern.compile("([^\\$]*)\\$\\{([^\\}]*)\\}([^\\$]*)");
    static final Pattern envP = Pattern.compile("([^\\$]*)\\$\\{ENV=([^\\}]*)\\}([^\\$]*)");
    static final Pattern mpConfigP = Pattern.compile("([^\\$]*)\\$\\{MPCONFIG=([^\\}]*)\\}([^\\$]*)");
    private static final String ALIAS_TOKEN = "ALIAS";
    private static final String DEFAULT_SEPARATOR = ":";
    private static final int MAX_SUBSTITUTION_DEPTH = 100;
    private static final boolean SUBSTITUTION_DISABLED = Boolean.valueOf(System.getProperty("fish.payara.substitution.disable", "false"));
    static ServiceLocator habitat;
    private static DomainScopedPasswordAliasStore domainPasswordAliasStore;
    final ConfigView masterView;

    TranslatedConfigView(ConfigView master) {
        this.masterView = master;
    }

    public static String expandValue(String value) {
        if (value == null || SUBSTITUTION_DISABLED) {
            return value;
        }
        return TranslatedConfigView.expandConfigValue(value);
    }

    public static String expandConfigValue(String value) {
        return (String)TranslatedConfigView.getTranslatedValue(value);
    }

    private static Object getTranslatedValue(Object value) {
        if (value != null && value instanceof String) {
            String stringValue = value.toString();
            if (stringValue.indexOf(36) == -1) {
                return value;
            }
            if (!doSubstitution.get().booleanValue()) {
                return value;
            }
            if (TranslatedConfigView.domainPasswordAliasStore() != null && TranslatedConfigView.getAlias(stringValue) != null) {
                try {
                    return TranslatedConfigView.getRealPasswordFromAlias(stringValue);
                }
                catch (Exception e) {
                    Logger.getAnonymousLogger().severe(Strings.get("TranslatedConfigView.aliaserror", stringValue, e.getLocalizedMessage()));
                    return stringValue;
                }
            }
            stringValue = TranslatedConfigView.performSubstitution(stringValue, SubstitutionType.MPCONFIG);
            stringValue = TranslatedConfigView.performSubstitution(stringValue, SubstitutionType.ENVIRONMENT);
            stringValue = TranslatedConfigView.performSubstitution(stringValue, SubstitutionType.SYSTEM);
            return stringValue;
        }
        return value;
    }

    private static String performSubstitution(String stringValue, SubstitutionType type) {
        Matcher matcher;
        String origValue = stringValue;
        int i = 0;
        switch (type) {
            case MPCONFIG: {
                matcher = mpConfigP.matcher(stringValue);
                break;
            }
            case ENVIRONMENT: {
                matcher = envP.matcher(stringValue);
                break;
            }
            case SYSTEM: {
                matcher = p.matcher(stringValue);
                break;
            }
            default: {
                return stringValue;
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find() && i < 100) {
            String defaultValue;
            String[] envValue = TranslatedConfigView.splitForTranslatedDefaultValue(matcher.group(2).trim());
            String matchValue = envValue[0];
            Optional<String> newValue = TranslatedConfigView.getReplacedValue(type, matchValue, defaultValue = envValue.length > 1 ? envValue[1] : null);
            if (newValue.isPresent()) {
                matcher.appendReplacement(stringBuffer, Matcher.quoteReplacement(matcher.group(1) + newValue.get() + matcher.group(3)));
            }
            ++i;
        }
        matcher.appendTail(stringBuffer);
        if (i >= 100) {
            Logger.getAnonymousLogger().severe(Strings.get("TranslatedConfigView.badprop", i, origValue));
        }
        return stringBuffer.toString();
    }

    private static Optional<String> getReplacedValue(SubstitutionType type, String matchValue, String defaultValue) {
        switch (type) {
            case MPCONFIG: {
                Config config = TranslatedConfigView.configResolver().getConfig();
                ConfigValue configValue = config.getConfigValue(matchValue);
                String newValue = configValue.getValue();
                if (newValue != null && !newValue.isEmpty()) {
                    Logger.getAnonymousLogger().fine("Found property '" + matchValue + "' in source '" + configValue.getSourceName() + "' with ordinal '" + configValue.getSourceOrdinal() + "'");
                    return Optional.of(newValue);
                }
                if (defaultValue != null) {
                    return Optional.of(defaultValue);
                }
                Logger.getAnonymousLogger().warning("MicroProfile Config: property '" + matchValue + "': no value found, no default given.");
                break;
            }
            case SYSTEM: {
                String newValue = System.getProperty(matchValue);
                if (newValue == null) break;
                return Optional.of(newValue);
            }
            case ENVIRONMENT: {
                String newValue = System.getenv(matchValue);
                if (newValue != null) {
                    return Optional.of(newValue);
                }
                if (defaultValue == null) break;
                return Optional.of(defaultValue);
            }
        }
        return Optional.empty();
    }

    private static String[] splitForTranslatedDefaultValue(String matchValue) {
        return matchValue == null ? null : matchValue.split(DEFAULT_SEPARATOR, 2);
    }

    public static void setHabitat(ServiceLocator h) {
        habitat = h;
    }

    private static DomainScopedPasswordAliasStore domainPasswordAliasStore() {
        if (habitat != null) {
            domainPasswordAliasStore = AccessController.doPrivileged(new PrivilegedAction<DomainScopedPasswordAliasStore>(){

                @Override
                public DomainScopedPasswordAliasStore run() {
                    return (DomainScopedPasswordAliasStore)habitat.getService(DomainScopedPasswordAliasStore.class, new Annotation[0]);
                }
            });
        }
        return domainPasswordAliasStore;
    }

    private static ConfigProviderResolver configResolver() {
        if (habitat != null) {
            return AccessController.doPrivileged(() -> (ConfigProviderResolver)habitat.getService(ConfigProviderResolver.class, new Annotation[0]));
        }
        throw new IllegalStateException("Trying to access MP Config before Service Locator started");
    }

    public static String getAlias(String propName) {
        int lastIdx;
        String aliasName = null;
        String starter = "${ALIAS=";
        String ender = "}";
        if ((propName = propName.trim()).startsWith(starter) && propName.endsWith(ender) && (lastIdx = (propName = propName.substring(starter.length())).length() - 1) > 1 && (propName = propName.substring(0, lastIdx)) != null) {
            aliasName = propName.trim();
        }
        return aliasName;
    }

    public static String getRealPasswordFromAlias(String at) throws KeyStoreException, CertificateException, IOException, NoSuchAlgorithmException, UnrecoverableKeyException {
        String an = TranslatedConfigView.getAlias(at);
        boolean exists = domainPasswordAliasStore.containsKey(an);
        if (!exists) {
            String msg = String.format("Alias  %s does not exist", an);
            throw new IllegalArgumentException(msg);
        }
        return new String(domainPasswordAliasStore.get(an));
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        return TranslatedConfigView.getTranslatedValue(this.masterView.invoke(proxy, method, args));
    }

    public ConfigView getMasterView() {
        return this.masterView;
    }

    public void setMasterView(ConfigView view) {
    }

    public <T extends ConfigBeanProxy> Class<T> getProxyType() {
        return this.masterView.getProxyType();
    }

    public <T extends ConfigBeanProxy> T getProxy(Class<T> proxyType) {
        return (T)((ConfigBeanProxy)proxyType.cast(Proxy.newProxyInstance(proxyType.getClassLoader(), new Class[]{proxyType}, (InvocationHandler)((Object)this))));
    }

    static {
        domainPasswordAliasStore = null;
    }

    public static enum SubstitutionType {
        MPCONFIG,
        ENVIRONMENT,
        SYSTEM;

    }
}

