/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.validation.internal;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import org.glassfish.jersey.message.MessageUtils;
import org.glassfish.jersey.server.validation.ValidationErrorData;

final class ValidationErrorMessageBodyWriter
implements MessageBodyWriter<Object> {
    ValidationErrorMessageBodyWriter() {
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return ValidationErrorMessageBodyWriter.isSupportedMediaType(mediaType) && ValidationErrorMessageBodyWriter.isSupportedType(type, genericType);
    }

    private static boolean isSupportedType(Class<?> type, Type genericType) {
        if (ValidationErrorData.class.isAssignableFrom(type)) {
            return true;
        }
        if (Collection.class.isAssignableFrom(type) && genericType instanceof ParameterizedType) {
            return ValidationErrorData.class.isAssignableFrom((Class)((ParameterizedType)genericType).getActualTypeArguments()[0]);
        }
        return false;
    }

    private static boolean isSupportedMediaType(MediaType mediaType) {
        return MediaType.TEXT_HTML_TYPE.equals((Object)mediaType) || MediaType.TEXT_PLAIN_TYPE.equals((Object)mediaType);
    }

    public long getSize(Object validationErrors, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(Object entity, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        Set<ValidationErrorData> errors = entity instanceof ValidationErrorData ? Collections.singleton((ValidationErrorData)entity) : (Set<ValidationErrorData>)entity;
        boolean isPlain = MediaType.TEXT_PLAIN_TYPE.getSubtype().equals(mediaType.getSubtype());
        StringBuilder builder = new StringBuilder();
        if (!isPlain) {
            builder.append("<div class=\"validation-errors\">");
        }
        for (ValidationErrorData error : errors) {
            if (!isPlain) {
                builder.append("<div class=\"validation-error\">");
            }
            builder.append(isPlain ? error.getMessage() : "<span class=\"message\">" + error.getMessage() + "</span>");
            builder.append(' ');
            builder.append('(');
            builder.append(isPlain ? "path = " : "<span class=\"path\"><strong>path</strong> = ");
            builder.append(isPlain ? error.getPath() : error.getPath() + "</span>");
            builder.append(',');
            builder.append(' ');
            builder.append(isPlain ? "invalidValue = " : "<span class=\"invalid-value\"><strong>invalidValue</strong> = ");
            builder.append(isPlain ? error.getInvalidValue() : ValidationErrorMessageBodyWriter.escapeHtml(error.getInvalidValue()).concat("</span>"));
            builder.append(')');
            if (!isPlain) {
                builder.append("</div>");
                continue;
            }
            builder.append('\n');
        }
        if (!isPlain) {
            builder.append("</div>");
        }
        entityStream.write(builder.toString().getBytes(MessageUtils.getCharset((MediaType)mediaType)));
        entityStream.flush();
    }

    private static final String escapeHtml(String origin) {
        return origin == null ? "" : origin.replaceAll("&", "&amp;").replaceAll("\"", "&quot;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }
}

