/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.ejb.http.admin;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.util.ColumnFormatter;
import fish.payara.ejb.http.admin.EjbInvokerConfiguration;
import java.util.HashMap;
import java.util.Properties;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;

@Service(name="get-ejb-invoker-configuration")
@PerLookup
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG, CommandTarget.DAS, CommandTarget.DEPLOYMENT_GROUP, CommandTarget.STANDALONE_INSTANCE})
@RestEndpoints(value={@RestEndpoint(configBean=EjbInvokerConfiguration.class, opType=RestEndpoint.OpType.GET, path="get-ejb-invoker-configuration", description="Gets the ejb-invoker configuration")})
public class GetEjbInvokerConfigurationCommand
implements AdminCommand {
    private final String[] OUTPUT_HEADERS = new String[]{"Enabled", "EndPoint", "VirtualServers", "Security Enabled", "Realm Name", "Auth Type", "Auth Module", "Auth Module Class", "Roles"};
    @Inject
    private Target targetUtil;
    @Param(optional=true, defaultValue="server-config")
    public String target;

    public void execute(AdminCommandContext adminCommandContext) {
        Config targetConfig = this.targetUtil.getConfig(this.target);
        if (targetConfig == null) {
            adminCommandContext.getActionReport().setMessage("No such config name: " + this.targetUtil);
            adminCommandContext.getActionReport().setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        EjbInvokerConfiguration configuration = (EjbInvokerConfiguration)targetConfig.getExtensionByType(EjbInvokerConfiguration.class);
        ColumnFormatter columnFormatter = new ColumnFormatter(this.OUTPUT_HEADERS);
        Object[] outputValues = new Object[]{configuration.getEnabled(), configuration.getEndpoint(), configuration.getVirtualServers(), configuration.getSecurityEnabled(), configuration.getRealmName(), configuration.getAuthType(), configuration.getAuthModule(), configuration.getAuthModuleClass(), configuration.getRoles()};
        columnFormatter.addRow(outputValues);
        adminCommandContext.getActionReport().appendMessage(columnFormatter.toString());
        HashMap<String, String> extraPropertiesMap = new HashMap<String, String>();
        extraPropertiesMap.put("enabled", configuration.getEnabled());
        extraPropertiesMap.put("endpoint", configuration.getEndpoint());
        extraPropertiesMap.put("virtualServers", configuration.getVirtualServers());
        extraPropertiesMap.put("securityEnabled", configuration.getSecurityEnabled());
        extraPropertiesMap.put("realmName", configuration.getRealmName());
        extraPropertiesMap.put("authType", configuration.getAuthType());
        extraPropertiesMap.put("authModule", configuration.getAuthModule());
        extraPropertiesMap.put("authModuleClass", configuration.getAuthModuleClass());
        extraPropertiesMap.put("roles", configuration.getRoles());
        Properties extraProperties = new Properties();
        extraProperties.put("ejbInvokerConfiguration", extraPropertiesMap);
        adminCommandContext.getActionReport().setExtraProperties(extraProperties);
    }
}

