/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.monitoring.collect;

import java.lang.reflect.Method;
import java.time.Instant;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;

public interface MonitoringDataCollector {
    public MonitoringDataCollector tag(CharSequence var1, CharSequence var2);

    public MonitoringDataCollector collect(CharSequence var1, long var2);

    public MonitoringDataCollector annotate(CharSequence var1, long var2, boolean var4, String ... var5);

    default public MonitoringDataCollector annotate(CharSequence metric, long value, String ... attrs) {
        return this.annotate(metric, value, false, attrs);
    }

    default public MonitoringDataCollector prefix(final CharSequence prefix) {
        final MonitoringDataCollector self = this;
        return new MonitoringDataCollector(){
            StringBuilder prefixed;
            {
                this.prefixed = new StringBuilder(prefix);
            }

            @Override
            public MonitoringDataCollector tag(CharSequence name, CharSequence value) {
                self.tag(name, value);
                return this;
            }

            @Override
            public MonitoringDataCollector collect(CharSequence metric, long value) {
                this.prefixed.setLength(prefix.length());
                self.collect((CharSequence)this.prefixed.append(metric), value);
                return this;
            }

            @Override
            public MonitoringDataCollector annotate(CharSequence metric, long value, boolean keyed, String ... attrs) {
                this.prefixed.setLength(prefix.length());
                self.annotate((CharSequence)this.prefixed.append(metric), value, keyed, attrs);
                return this;
            }
        };
    }

    default public MonitoringDataCollector collectNonZero(CharSequence key, long value) {
        return value != 0L ? this.collect(key, value) : this;
    }

    default public MonitoringDataCollector collect(CharSequence key, double value) {
        return this.collect(key, Math.round(value * 10000.0));
    }

    default public MonitoringDataCollector collect(CharSequence key, boolean value) {
        return this.collect(key, value ? 1L : 0L);
    }

    default public MonitoringDataCollector collect(CharSequence key, char value) {
        return this.collect(key, (long)value);
    }

    default public MonitoringDataCollector collect(CharSequence key, Number value) {
        if (value != null) {
            if (value instanceof Double || value instanceof Float) {
                return this.collect(key, value.doubleValue());
            }
            return this.collect(key, value.longValue());
        }
        return this;
    }

    default public MonitoringDataCollector collect(CharSequence key, Boolean value) {
        return value != null ? this.collect(key, (boolean)value) : this;
    }

    default public MonitoringDataCollector collect(CharSequence key, Instant value) {
        return value != null ? this.collect(key, value.toEpochMilli()) : this;
    }

    default public <V> MonitoringDataCollector collectObject(V obj, BiConsumer<MonitoringDataCollector, V> collect) {
        if (obj != null) {
            collect.accept(this, obj);
        }
        return this;
    }

    default public <V> MonitoringDataCollector collectObjects(Collection<V> entries, BiConsumer<MonitoringDataCollector, V> collect) {
        if (entries != null) {
            for (V entry : entries) {
                collect.accept(this, entry);
            }
        }
        return this;
    }

    default public <K, V> MonitoringDataCollector collectAll(Map<K, V> entries, BiConsumer<MonitoringDataCollector, V> collect) {
        return this.collectAll(entries, key -> key instanceof CharSequence ? (CharSequence)key : key.toString(), collect);
    }

    default public <K, V> MonitoringDataCollector collectAll(Map<K, V> entries, Function<K, CharSequence> entryTag, BiConsumer<MonitoringDataCollector, V> collect) {
        if (entries != null) {
            for (Map.Entry<K, V> entry : entries.entrySet()) {
                K key = entry.getKey();
                collect.accept(this.group(entryTag.apply(key)), entry.getValue());
            }
        }
        return this;
    }

    default public <V> MonitoringDataCollector collectObject(V obj, Class<V> as) {
        for (Method getter : as.getDeclaredMethods()) {
            int offset;
            String name = getter.getName();
            int n = name.startsWith("get") ? 3 : (offset = name.startsWith("is") ? 2 : 0);
            if (offset <= 0) continue;
            String property = name.substring(offset);
            Class<?> returnType = getter.getReturnType();
            try {
                if (Boolean.class.isAssignableFrom(returnType) || returnType == Boolean.TYPE) {
                    this.collect((CharSequence)property, (Boolean)getter.invoke(obj, new Object[0]));
                    continue;
                }
                if (!Number.class.isAssignableFrom(returnType) && !returnType.isPrimitive()) continue;
                this.collect((CharSequence)property, (Number)getter.invoke(obj, new Object[0]));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this;
    }

    default public MonitoringDataCollector in(CharSequence namespace) {
        return this.tag("ns", namespace);
    }

    default public MonitoringDataCollector group(CharSequence type) {
        return this.tag("@", type);
    }
}

