/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.context.impl;

import com.ibm.jbatch.container.context.impl.MetricImpl;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.batch.runtime.BatchStatus;
import javax.batch.runtime.Metric;
import javax.batch.runtime.context.StepContext;

public class StepContextImpl
implements StepContext {
    private static final String sourceClass = StepContextImpl.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    private static final boolean cloneContextProperties = Boolean.getBoolean("clone.context.properties");
    private String stepId = null;
    private BatchStatus batchStatus = null;
    private String exitStatus = null;
    private Object transientUserData = null;
    private Serializable persistentUserData = null;
    private Exception exception = null;
    Timestamp starttime = null;
    Timestamp endtime = null;
    private long stepExecID = 0L;
    private Properties properties = new Properties();
    private String batchletProcessRetVal = null;
    public static final String TOP_LEVEL_STEP_EXECUTION_ID_PROP = "com.ibm.jbatch.container.context.impl.StepContextImpl#getExecutionId";
    private ConcurrentHashMap<String, Metric> metrics = new ConcurrentHashMap();

    public StepContextImpl(String stepId) {
        this.stepId = stepId;
    }

    @Override
    public BatchStatus getBatchStatus() {
        return this.batchStatus;
    }

    @Override
    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    @Override
    public String getExitStatus() {
        return this.exitStatus;
    }

    @Override
    public String getStepName() {
        return this.stepId;
    }

    @Override
    public Metric[] getMetrics() {
        return this.metrics.values().toArray(new Metric[0]);
    }

    public MetricImpl getMetric(Metric.MetricType metricType) {
        return (MetricImpl)this.metrics.get(metricType.name());
    }

    public void addMetric(Metric.MetricType metricType, long value) {
        this.metrics.putIfAbsent(metricType.name(), new MetricImpl(metricType, value));
    }

    @Override
    public Serializable getPersistentUserData() {
        return this.persistentUserData;
    }

    @Override
    public Properties getProperties() {
        if (cloneContextProperties) {
            logger.fine("Cloning job context properties");
            return (Properties)this.properties.clone();
        }
        logger.fine("Returing ref (non-clone) to job context properties");
        return this.properties;
    }

    public Properties getJSLProperties() {
        return this.properties;
    }

    @Override
    public Object getTransientUserData() {
        return this.transientUserData;
    }

    @Override
    public void setExitStatus(String status) {
        this.exitStatus = status;
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "Exit status set to: " + status + " for step id:" + this.getStepName());
        }
    }

    public void setBatchStatus(BatchStatus status) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Batch status set to: " + (Object)((Object)status) + " from " + (Object)((Object)this.batchStatus) + " for step id:" + this.getStepName());
        }
        this.batchStatus = status;
    }

    @Override
    public void setPersistentUserData(Serializable data) {
        this.persistentUserData = data;
    }

    @Override
    public void setTransientUserData(Object data) {
        this.transientUserData = data;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(" stepId: " + this.stepId);
        buf.append(", batchStatus: " + (Object)((Object)this.batchStatus));
        buf.append(", exitStatus: " + this.exitStatus);
        buf.append(", batchletProcessRetVal: " + this.batchletProcessRetVal);
        buf.append(", transientUserData: " + this.transientUserData);
        buf.append(", persistentUserData: " + this.persistentUserData);
        return buf.toString();
    }

    @Override
    public long getStepExecutionId() {
        if (this.properties.containsKey(TOP_LEVEL_STEP_EXECUTION_ID_PROP)) {
            return Long.parseLong(this.properties.getProperty(TOP_LEVEL_STEP_EXECUTION_ID_PROP));
        }
        return this.stepExecID;
    }

    public long getInternalStepExecutionId() {
        return this.stepExecID;
    }

    public void setStepExecutionId(long stepExecutionId) {
        this.stepExecID = stepExecutionId;
    }

    public void setStartTime(Timestamp startTS) {
        this.starttime = startTS;
    }

    public void setEndTime(Timestamp endTS) {
        this.endtime = endTS;
    }

    public Timestamp getStartTimeTS() {
        return this.starttime;
    }

    public Timestamp getEndTimeTS() {
        return this.endtime;
    }

    public String getBatchletProcessRetVal() {
        return this.batchletProcessRetVal;
    }

    public void setBatchletProcessRetVal(String batchletProcessRetVal) {
        this.batchletProcessRetVal = batchletProcessRetVal;
    }
}

