/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.security.openid.controller;

import fish.payara.security.openid.OpenIdUtil;
import fish.payara.security.openid.api.OpenIdState;
import fish.payara.security.openid.controller.NonceController;
import fish.payara.security.openid.controller.StateController;
import fish.payara.security.openid.domain.OpenIdConfiguration;
import fish.payara.security.openid.domain.OpenIdNonce;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.security.enterprise.AuthenticationStatus;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.UriBuilder;

@ApplicationScoped
public class AuthenticationController {
    @Inject
    private StateController stateController;
    @Inject
    private NonceController nonceController;
    @Inject
    private OpenIdConfiguration configuration;
    private static final Logger LOGGER = Logger.getLogger(AuthenticationController.class.getName());

    public AuthenticationStatus authenticateUser(HttpServletRequest request, HttpServletResponse response) {
        UriBuilder authRequest = UriBuilder.fromUri((String)this.configuration.getProviderMetadata().getAuthorizationEndpoint()).queryParam("scope", new Object[]{this.configuration.getScopes()}).queryParam("response_type", new Object[]{this.configuration.getResponseType()}).queryParam("client_id", new Object[]{this.configuration.getClientId()}).queryParam("redirect_uri", new Object[]{this.configuration.buildRedirectURI(request)});
        OpenIdState state = new OpenIdState();
        authRequest.queryParam("state", new Object[]{state.getValue()});
        this.stateController.store(state, this.configuration, request, response);
        if (this.configuration.isUseNonce()) {
            OpenIdNonce nonce = new OpenIdNonce();
            String nonceHash = this.nonceController.getNonceHash(nonce);
            authRequest.queryParam("nonce", new Object[]{nonceHash});
            this.nonceController.store(nonce, this.configuration, request, response);
        }
        if (!OpenIdUtil.isEmpty(this.configuration.getResponseMode())) {
            authRequest.queryParam("response_mode", new Object[]{this.configuration.getResponseMode()});
        }
        if (!OpenIdUtil.isEmpty(this.configuration.getDisplay())) {
            authRequest.queryParam("display", new Object[]{this.configuration.getDisplay()});
        }
        if (!OpenIdUtil.isEmpty(this.configuration.getPrompt())) {
            authRequest.queryParam("prompt", new Object[]{this.configuration.getPrompt()});
        }
        this.configuration.getExtraParameters().forEach((key, values) -> values.stream().forEach(value -> authRequest.queryParam(key, new Object[]{value})));
        String authUrl = authRequest.toString();
        LOGGER.log(Level.FINEST, "Redirecting for authentication to {0}", authUrl);
        try {
            response.sendRedirect(authUrl);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return AuthenticationStatus.SEND_CONTINUE;
    }
}

