/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.security.openid.controller;

import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;

@ApplicationScoped
public class ProviderMetadataContoller {
    private static final String WELL_KNOWN_CONFIGURATION_ADDRESS = "/.well-known/openid-configuration";
    private final Map<String, JsonObject> providerDocuments = new HashMap<String, JsonObject>();

    public JsonObject getDocument(String providerURI) {
        if (!this.providerDocuments.containsKey(providerURI)) {
            JsonObject responseObject = providerURI.isEmpty() ? JsonObject.EMPTY_JSON_OBJECT : this.downloadWellKnownUris(providerURI);
            this.providerDocuments.put(providerURI, responseObject);
        }
        return this.providerDocuments.get(providerURI);
    }

    private JsonObject downloadWellKnownUris(String providerURI) {
        if (providerURI.endsWith("/")) {
            providerURI = providerURI.substring(0, providerURI.length() - 1);
        }
        if (!providerURI.endsWith(WELL_KNOWN_CONFIGURATION_ADDRESS)) {
            providerURI = providerURI + WELL_KNOWN_CONFIGURATION_ADDRESS;
        }
        Client client = ClientBuilder.newClient();
        WebTarget target = client.target(providerURI);
        Response response = target.request().accept(new String[]{"application/json"}).get();
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            String responseBody = (String)response.readEntity(String.class);
            try (JsonReader reader = Json.createReader((Reader)new StringReader(responseBody));){
                JsonObject responseObject;
                JsonObject jsonObject = responseObject = reader.readObject();
                return jsonObject;
            }
        }
        throw new IllegalStateException(String.format("Unable to retrieve OpenID Provider's [%s] configuration document, HTTP response code : [%s] ", providerURI, response.getStatus()));
    }
}

