/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.security.openid.domain;

import fish.payara.security.openid.api.AccessToken;
import fish.payara.security.openid.api.JwtClaims;
import fish.payara.security.openid.api.Scope;
import fish.payara.security.openid.controller.JWTValidator;
import fish.payara.security.openid.domain.NimbusJwtClaims;
import fish.payara.security.openid.domain.OpenIdConfiguration;
import fish.payara.security.shaded.nimbusds.jwt.EncryptedJWT;
import fish.payara.security.shaded.nimbusds.jwt.JWT;
import fish.payara.security.shaded.nimbusds.jwt.JWTClaimsSet;
import fish.payara.security.shaded.nimbusds.jwt.JWTParser;
import fish.payara.security.shaded.nimbusds.jwt.SignedJWT;
import fish.payara.security.shaded.nimbusds.jwt.proc.JWTClaimsSetVerifier;
import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Objects;

public class AccessTokenImpl
implements AccessToken {
    private final String token;
    private final long tokenMinValidity;
    private final AccessToken.Type type;
    private final JwtClaims jwtClaims;
    private JWT tokenJWT;
    private Map<String, Object> claims;
    private final Long expiresIn;
    private final Scope scope;
    private final long createdAt;

    public AccessTokenImpl(String tokenType, String token, Long expiresIn, String scopeValue, long tokenMinValidity) {
        this.token = token;
        this.tokenMinValidity = tokenMinValidity;
        JWTClaimsSet jwtClaimsSet = null;
        try {
            this.tokenJWT = JWTParser.parse(token);
            jwtClaimsSet = this.tokenJWT.getJWTClaimsSet();
            this.claims = jwtClaimsSet == null ? null : jwtClaimsSet.getClaims();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        this.jwtClaims = NimbusJwtClaims.ifPresent(jwtClaimsSet);
        this.type = AccessToken.Type.valueOf((String)tokenType.toUpperCase());
        this.expiresIn = expiresIn;
        this.createdAt = System.currentTimeMillis();
        this.scope = Scope.parse((String)scopeValue);
    }

    private AccessTokenImpl(JWT token, JWTClaimsSet claims, long tokenMinValidity) {
        this.token = token.getParsedString();
        this.tokenJWT = token;
        this.claims = claims.getClaims();
        this.jwtClaims = NimbusJwtClaims.ifPresent(claims);
        this.type = AccessToken.Type.BEARER;
        this.expiresIn = null;
        this.createdAt = System.currentTimeMillis();
        this.scope = this.jwtClaims.getStringClaim("scope").map(Scope::parse).orElse(null);
        this.tokenMinValidity = tokenMinValidity;
    }

    public static AccessTokenImpl forBearerToken(OpenIdConfiguration configuration, String rawToken, JWTClaimsSetVerifier verifier, JWTValidator validator) throws ParseException {
        JWT token = JWTParser.parse(rawToken);
        JWTClaimsSet claims = validator.validateBearerToken(token, verifier);
        return new AccessTokenImpl(token, claims, configuration.getTokenMinValidity());
    }

    public JWT getTokenJWT() {
        return this.tokenJWT;
    }

    public boolean isExpired() {
        boolean expired = true;
        if (Objects.nonNull(this.expiresIn)) {
            expired = System.currentTimeMillis() + this.tokenMinValidity > this.createdAt + this.expiresIn * 1000L;
        } else {
            Date exp = (Date)this.getClaim("exp");
            if (Objects.nonNull(exp)) {
                expired = System.currentTimeMillis() + this.tokenMinValidity > exp.getTime();
            } else {
                throw new IllegalStateException("Missing expiration time (exp) claim in access token");
            }
        }
        return expired;
    }

    public AccessToken.Type getType() {
        return this.type;
    }

    public String getToken() {
        return this.token;
    }

    public Map<String, Object> getClaims() {
        if (this.claims == null) {
            return Collections.emptyMap();
        }
        return this.claims;
    }

    public void setClaims(Map<String, Object> claims) {
        this.claims = claims;
    }

    public Object getClaim(String key) {
        return this.getClaims().get(key);
    }

    public Long getExpirationTime() {
        return this.expiresIn;
    }

    public Scope getScope() {
        return this.scope;
    }

    public boolean isJWT() {
        return this.tokenJWT != null;
    }

    public JwtClaims getJwtClaims() {
        return this.jwtClaims;
    }

    public boolean isEncrypted() {
        return this.isJWT() && this.tokenJWT instanceof EncryptedJWT;
    }

    public boolean isSigned() {
        return this.isJWT() && this.tokenJWT instanceof SignedJWT;
    }

    public String toString() {
        return this.token;
    }
}

