/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.security.shaded.nimbusds.jose.util;

import fish.payara.security.shaded.jcip.annotations.ThreadSafe;
import fish.payara.security.shaded.nimbusds.jose.util.AbstractRestrictedResourceRetriever;
import fish.payara.security.shaded.nimbusds.jose.util.BoundedInputStream;
import fish.payara.security.shaded.nimbusds.jose.util.IOUtils;
import fish.payara.security.shaded.nimbusds.jose.util.Resource;
import fish.payara.security.shaded.nimbusds.jose.util.RestrictedResourceRetriever;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;

@ThreadSafe
public class DefaultResourceRetriever
extends AbstractRestrictedResourceRetriever
implements RestrictedResourceRetriever {
    private boolean disconnectAfterUse;
    private final SSLSocketFactory sslSocketFactory;
    private Proxy proxy;

    public DefaultResourceRetriever() {
        this(0, 0);
    }

    public DefaultResourceRetriever(int connectTimeout, int readTimeout) {
        this(connectTimeout, readTimeout, 0);
    }

    public DefaultResourceRetriever(int connectTimeout, int readTimeout, int sizeLimit) {
        this(connectTimeout, readTimeout, sizeLimit, true);
    }

    public DefaultResourceRetriever(int connectTimeout, int readTimeout, int sizeLimit, boolean disconnectAfterUse) {
        this(connectTimeout, readTimeout, sizeLimit, disconnectAfterUse, null);
    }

    public DefaultResourceRetriever(int connectTimeout, int readTimeout, int sizeLimit, boolean disconnectAfterUse, SSLSocketFactory sslSocketFactory) {
        super(connectTimeout, readTimeout, sizeLimit);
        this.disconnectAfterUse = disconnectAfterUse;
        this.sslSocketFactory = sslSocketFactory;
    }

    public boolean disconnectsAfterUse() {
        return this.disconnectAfterUse;
    }

    public void setDisconnectsAfterUse(boolean disconnectAfterUse) {
        this.disconnectAfterUse = disconnectAfterUse;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    @Override
    public Resource retrieveResource(URL url) throws IOException {
        HttpURLConnection con = null;
        try {
            String content;
            con = this.openConnection(url);
            con.setConnectTimeout(this.getConnectTimeout());
            con.setReadTimeout(this.getReadTimeout());
            if (this.sslSocketFactory != null && con instanceof HttpsURLConnection) {
                ((HttpsURLConnection)con).setSSLSocketFactory(this.sslSocketFactory);
            }
            if (this.getHeaders() != null && !this.getHeaders().isEmpty()) {
                for (Map.Entry<String, List<String>> entry : this.getHeaders().entrySet()) {
                    for (String value : entry.getValue()) {
                        con.addRequestProperty(entry.getKey(), value);
                    }
                }
            }
            InputStream inputStream = this.getInputStream(con, this.getSizeLimit());
            Object object = null;
            try {
                content = IOUtils.readInputStreamToString(inputStream, StandardCharsets.UTF_8);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (inputStream != null) {
                    if (object != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        inputStream.close();
                    }
                }
            }
            int statusCode = con.getResponseCode();
            String statusMessage = con.getResponseMessage();
            if (statusCode > 299 || statusCode < 200) {
                throw new IOException("HTTP " + statusCode + ": " + statusMessage);
            }
            Resource resource = new Resource(content, con.getContentType());
            return resource;
        }
        catch (ClassCastException e) {
            throw new IOException("Couldn't open HTTP(S) connection: " + e.getMessage(), e);
        }
        finally {
            if (this.disconnectAfterUse && con != null) {
                con.disconnect();
            }
        }
    }

    protected HttpURLConnection openConnection(URL url) throws IOException {
        if (this.proxy != null) {
            return (HttpURLConnection)url.openConnection(this.proxy);
        }
        return (HttpURLConnection)url.openConnection();
    }

    private InputStream getInputStream(HttpURLConnection con, int sizeLimit) throws IOException {
        InputStream inputStream = con.getInputStream();
        return sizeLimit > 0 ? new BoundedInputStream(inputStream, this.getSizeLimit()) : inputStream;
    }
}

