/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.security.shaded.nimbusds.jwt;

import fish.payara.security.shaded.nimbusds.jose.Algorithm;
import fish.payara.security.shaded.nimbusds.jose.Header;
import fish.payara.security.shaded.nimbusds.jose.JWEAlgorithm;
import fish.payara.security.shaded.nimbusds.jose.JWSAlgorithm;
import fish.payara.security.shaded.nimbusds.jose.util.Base64URL;
import fish.payara.security.shaded.nimbusds.jose.util.JSONObjectUtils;
import fish.payara.security.shaded.nimbusds.jwt.EncryptedJWT;
import fish.payara.security.shaded.nimbusds.jwt.JWT;
import fish.payara.security.shaded.nimbusds.jwt.PlainJWT;
import fish.payara.security.shaded.nimbusds.jwt.SignedJWT;
import java.text.ParseException;
import java.util.Map;

public final class JWTParser {
    public static JWT parse(String s) throws ParseException {
        Map<String, Object> jsonObject;
        int firstDotPos = s.indexOf(".");
        if (firstDotPos == -1) {
            throw new ParseException("Invalid JWT serialization: Missing dot delimiter(s)", 0);
        }
        Base64URL header = new Base64URL(s.substring(0, firstDotPos));
        try {
            jsonObject = JSONObjectUtils.parse(header.decodeToString());
        }
        catch (ParseException e) {
            throw new ParseException("Invalid unsecured/JWS/JWE header: " + e.getMessage(), 0);
        }
        Algorithm alg = Header.parseAlgorithm(jsonObject);
        if (alg.equals(Algorithm.NONE)) {
            return PlainJWT.parse(s);
        }
        if (alg instanceof JWSAlgorithm) {
            return SignedJWT.parse(s);
        }
        if (alg instanceof JWEAlgorithm) {
            return EncryptedJWT.parse(s);
        }
        throw new AssertionError((Object)("Unexpected algorithm type: " + alg));
    }

    private JWTParser() {
    }
}

