/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.kernel.javaee;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.v3.server.ContainerStarter;
import java.beans.PropertyChangeEvent;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.glassfish.api.container.Sniffer;
import org.glassfish.grizzly.config.dom.NetworkConfig;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.grizzly.config.dom.NetworkListeners;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.runlevel.RunLevel;
import org.glassfish.internal.data.ContainerRegistry;
import org.glassfish.internal.data.EngineInfo;
import org.glassfish.logging.annotation.LogMessageInfo;
import org.glassfish.logging.annotation.LogMessagesResourceBundle;
import org.glassfish.logging.annotation.LoggerInfo;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.Changed;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.NotProcessed;
import org.jvnet.hk2.config.ObservableBean;
import org.jvnet.hk2.config.UnprocessedChangeEvents;
import org.jvnet.hk2.config.types.Property;

@Service
@RunLevel(value=10)
public class WebContainerStarter
implements PostConstruct,
ConfigListener {
    private static final String LOGMSG_PREFIX = "AS-CORE-JAVAEE";
    @LogMessagesResourceBundle
    private static final String SHARED_LOGMESSAGE_RESOURCE = "org.glassfish.kernel.javaee.LogMessages";
    @LoggerInfo(subsystem="AS-CORE", description="Java EE Core Kernel", publish=true)
    private static final String ASCORE_LOGGER = "javax.enterprise.system.core.ee";
    private static final Logger logger = Logger.getLogger("javax.enterprise.system.core.ee", "org.glassfish.kernel.javaee.LogMessages");
    private static final ResourceBundle rb = logger.getResourceBundle();
    @LogMessageInfo(message="Web Container not installed", cause="The web container does not install properly.", action="Please check the web container libraries are installed properly.", level="INFO")
    public static final String mWebContainerNotInstalled = "AS-CORE-JAVAEE-0001";
    @LogMessageInfo(message="Done with starting {0} container.", level="INFO")
    public static final String mStartContainerDone = "AS-CORE-JAVAEE-0002";
    @LogMessageInfo(message="Unable to start container (no exception provided)", cause="The web container does not start properly.", action="Please check the web container libraries are installed properly.", level="SEVERE")
    public static final String mUnableStartContainerNoException = "AS-CORE-JAVAEE-0003";
    @LogMessageInfo(message="Unable to start container {0}", cause="The web container does not start properly. Most probably, there is a class loading issue.", action="Please resolve issues mentioned in the stack trace.", level="SEVERE")
    public static final String mUnableStartContainer = "AS-CORE-JAVAEE-0004";
    private static final String AUTH_PASSTHROUGH_ENABLED_PROP = "authPassthroughEnabled";
    private static final String PROXY_HANDLER_PROP = "proxyHandler";
    private static final String TRACE_ENABLED_PROP = "traceEnabled";
    @Inject
    private Provider<Domain> domainProvider;
    @Inject
    private ContainerRegistry containerRegistry;
    @Inject
    private ContainerStarter containerStarter;
    @Inject
    private ModulesRegistry modulesRegistry;
    @Inject
    @Named(value="default-instance-name")
    private Provider<Config> serverConfigProvider;
    @Inject
    @Named(value="web")
    private Provider<Sniffer> webSnifferProvider;

    public void postConstruct() {
        boolean isStartNeeded;
        this.domainProvider.get();
        Config serverConfig = (Config)this.serverConfigProvider.get();
        boolean bl = isStartNeeded = serverConfig != null && (this.isStartNeeded(serverConfig.getHttpService()) || this.isStartNeeded(serverConfig.getNetworkConfig()));
        if (isStartNeeded) {
            this.startWebContainer();
        } else if (serverConfig != null) {
            ObservableBean bean = (ObservableBean)ConfigSupport.getImpl((ConfigBeanProxy)serverConfig.getHttpService());
            bean.addListener((ConfigListener)this);
            bean = (ObservableBean)ConfigSupport.getImpl((ConfigBeanProxy)serverConfig.getNetworkConfig().getNetworkListeners());
            bean.addListener((ConfigListener)this);
        }
    }

    public UnprocessedChangeEvents changed(PropertyChangeEvent[] events) {
        return ConfigSupport.sortAndDispatch((PropertyChangeEvent[])events, (Changed)new Changed(){

            public <T extends ConfigBeanProxy> NotProcessed changed(Changed.TYPE type, Class<T> tClass, T t) {
                if (tClass == HttpService.class) {
                    if (type == Changed.TYPE.CHANGE && WebContainerStarter.this.isStartNeeded((HttpService)t)) {
                        WebContainerStarter.this.startWebContainer();
                    }
                } else if (tClass == VirtualServer.class) {
                    if ((type == Changed.TYPE.ADD || type == Changed.TYPE.CHANGE) && WebContainerStarter.this.isStartNeeded((VirtualServer)t)) {
                        WebContainerStarter.this.startWebContainer();
                    }
                } else if (tClass == NetworkListener.class && (type == Changed.TYPE.ADD || type == Changed.TYPE.CHANGE) && WebContainerStarter.this.isStartNeeded((NetworkListener)t)) {
                    WebContainerStarter.this.startWebContainer();
                }
                return null;
            }
        }, (Logger)logger);
    }

    private void startWebContainer() {
        Sniffer webSniffer = (Sniffer)this.webSnifferProvider.get();
        if (webSniffer == null) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info(mWebContainerNotInstalled);
            }
            return;
        }
        if (this.containerRegistry.getContainer(webSniffer.getContainersNames()[0]) != null) {
            this.containerRegistry.getContainer(webSniffer.getContainersNames()[0]).getContainer();
        } else {
            try {
                Collection containersInfo = this.containerStarter.startContainer(webSniffer);
                if (containersInfo != null && !containersInfo.isEmpty()) {
                    for (EngineInfo info : containersInfo) {
                        info.getContainer();
                        if (!logger.isLoggable(Level.INFO)) continue;
                        logger.log(Level.INFO, mStartContainerDone, webSniffer.getModuleType());
                    }
                } else {
                    logger.severe(mUnableStartContainerNoException);
                }
            }
            catch (Exception e) {
                String msg = rb != null ? MessageFormat.format(rb.getString(mUnableStartContainer), webSniffer.getContainersNames()[0]) : "Unable to start Web Container: " + webSniffer.getContainersNames()[0];
                logger.log(Level.SEVERE, msg, e);
            }
        }
    }

    private boolean isStartNeeded(HttpService httpService) {
        List hosts;
        if (httpService == null) {
            return false;
        }
        if (ConfigBeansUtilities.toBoolean((String)httpService.getAccessLoggingEnabled()) || ConfigBeansUtilities.toBoolean((String)httpService.getSsoEnabled())) {
            return true;
        }
        List props = httpService.getProperty();
        if (props != null) {
            for (Property prop : props) {
                String propName = prop.getName();
                String propValue = prop.getValue();
                if (AUTH_PASSTHROUGH_ENABLED_PROP.equals(propName)) {
                    if (!ConfigBeansUtilities.toBoolean((String)propValue)) continue;
                    return true;
                }
                if (PROXY_HANDLER_PROP.equals(propName)) {
                    return true;
                }
                if (!TRACE_ENABLED_PROP.equals(propName) || ConfigBeansUtilities.toBoolean((String)propValue)) continue;
                return true;
            }
        }
        if ((hosts = httpService.getVirtualServer()) != null) {
            for (VirtualServer host : hosts) {
                if (!this.isStartNeeded(host)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isStartNeeded(VirtualServer host) {
        if (host == null) {
            return false;
        }
        if (ConfigBeansUtilities.toBoolean((String)host.getAccessLoggingEnabled()) || ConfigBeansUtilities.toBoolean((String)host.getSsoEnabled())) {
            return true;
        }
        String state = host.getState();
        if (state != null && ("disabled".equals(state) || !ConfigBeansUtilities.toBoolean((String)state))) {
            return true;
        }
        List props = host.getProperty();
        return props != null && !props.isEmpty();
    }

    private boolean isStartNeeded(NetworkConfig networkConfig) {
        if (networkConfig == null) {
            return false;
        }
        NetworkListeners networkListeners = networkConfig.getNetworkListeners();
        if (networkListeners == null) {
            return false;
        }
        for (NetworkListener networkListener : networkListeners.getNetworkListener()) {
            if (!this.isStartNeeded(networkListener)) continue;
            return true;
        }
        return false;
    }

    private boolean isStartNeeded(NetworkListener networkListener) {
        if (networkListener == null) {
            return false;
        }
        return ConfigBeansUtilities.toBoolean((String)networkListener.getJkEnabled());
    }
}

