/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.security;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.RunAsIdentityDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.web.LoginConfiguration;
import com.sun.enterprise.security.AppCNonceCacheMap;
import com.sun.enterprise.security.CNonceCacheFactory;
import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.security.auth.WebAndEjbToJaasBridge;
import com.sun.enterprise.security.auth.digest.api.DigestAlgorithmParameter;
import com.sun.enterprise.security.auth.digest.api.Key;
import com.sun.enterprise.security.auth.digest.impl.CNonceValidator;
import com.sun.enterprise.security.auth.digest.impl.DigestParameterGenerator;
import com.sun.enterprise.security.auth.digest.impl.HttpAlgorithmParameterImpl;
import com.sun.enterprise.security.auth.login.DigestCredentials;
import com.sun.enterprise.security.integration.RealmInitializer;
import com.sun.enterprise.security.jacc.JaccWebAuthorizationManager;
import com.sun.enterprise.security.jacc.context.PolicyContextHandlerImpl;
import com.sun.enterprise.security.web.integration.WebPrincipal;
import com.sun.enterprise.security.web.integration.WebSecurityManagerFactory;
import com.sun.enterprise.util.net.NetUtils;
import com.sun.logging.LogDomains;
import com.sun.web.security.realmadapter.AuthenticatorProxy;
import com.sun.web.security.realmadapter.JaspicRealm;
import fish.payara.nucleus.requesttracing.RequestTracingService;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.security.auth.Subject;
import javax.security.auth.message.AuthException;
import javax.security.jacc.PolicyContext;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Authenticator;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.deploy.SecurityConstraint;
import org.apache.catalina.realm.RealmBase;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.grizzly.config.dom.NetworkConfig;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.grizzly.config.dom.NetworkListeners;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.internal.api.ServerContext;
import org.jvnet.hk2.annotations.Service;

@Service
@PerLookup
public class RealmAdapter
extends RealmBase
implements RealmInitializer,
PostConstruct {
    public static final String SECURITY_CONTEXT = "SecurityContext";
    public static final String BASIC = "BASIC";
    public static final String FORM = "FORM";
    private static final Logger LOG = LogDomains.getLogger(RealmAdapter.class, (String)"javax.enterprise.system.container.web");
    private static final ResourceBundle resourceBundle = LOG.getResourceBundle();
    private WebBundleDescriptor webDescriptor;
    private HashMap<String, String> runAsPrincipals;
    private String realmName;
    protected static final String name = "J2EE-RI-RealmAdapter";
    private String jaccContextId;
    protected volatile JaccWebAuthorizationManager jaccWebAuthorizationManager;
    protected boolean isCurrentURIincluded;
    protected final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private boolean contextEvaluated;
    private String loginPage;
    private String errorPage;
    private static final SecurityConstraint[] emptyConstraints = new SecurityConstraint[0];
    private String moduleID;
    @Inject
    private ServerContext serverContext;
    @Inject
    private Provider<AppCNonceCacheMap> appCNonceCacheMapProvider;
    @Inject
    private Provider<CNonceCacheFactory> cNonceCacheFactoryProvider;
    @Inject
    @Named(value="default-instance-name")
    private NetworkConfig networkConfig;
    @Inject
    protected WebSecurityManagerFactory webSecurityManagerFactory;
    @Inject
    private RequestTracingService requestTracing;
    private NetworkListeners nwListeners;
    private JaspicRealm jaspicRealm;
    private CNonceValidator cNonceValidator;
    private static ThreadLocal<byte[]> reentrancyStatus = ThreadLocal.withInitial(() -> new byte[]{0});

    public RealmAdapter() {
    }

    public RealmAdapter(String realmName, String moduleID) {
        this.realmName = realmName;
        this.moduleID = moduleID;
    }

    public void initializeRealm(Object bundleDescriptor, boolean isSystemApp, String defaultRealmName) {
        this.webDescriptor = (WebBundleDescriptor)bundleDescriptor;
        LOG.config(() -> String.format("initializeRealm(bundleDescriptor.appContextId=%s, isSystemApp=%s, defaultRealmName=%s)", this.webDescriptor.getAppContextId(), isSystemApp, defaultRealmName));
        this.realmName = this.computeRealmName(defaultRealmName);
        this.jaccContextId = JaccWebAuthorizationManager.getContextID((WebBundleDescriptor)this.webDescriptor);
        this.runAsPrincipals = new HashMap();
        for (WebComponentDescriptor componentDescriptor : this.webDescriptor.getWebComponentDescriptors()) {
            RunAsIdentityDescriptor runAsDescriptor = componentDescriptor.getRunAsIdentity();
            if (runAsDescriptor == null) continue;
            String principal = runAsDescriptor.getPrincipal();
            String servlet = componentDescriptor.getCanonicalName();
            if (principal == null || servlet == null) {
                LOG.warning("web.realmadapter.norunas");
                continue;
            }
            this.runAsPrincipals.put(servlet, principal);
            LOG.fine(() -> "Servlet " + servlet + " will run-as: " + principal);
        }
        this.moduleID = this.webDescriptor.getModuleID();
        this.jaspicRealm = new JaspicRealm(this.realmName, isSystemApp, this.webDescriptor, this.requestTracing);
        this.cNonceValidator = new CNonceValidator(this.webDescriptor, this.appCNonceCacheMapProvider, this.cNonceCacheFactoryProvider);
    }

    public boolean isSecurityExtensionEnabled(ServletContext context) {
        return this.jaspicRealm.isJaspicEnabled(context);
    }

    public SecurityConstraint[] findSecurityConstraints(HttpRequest request, Context context) {
        return this.findSecurityConstraints(null, null, context);
    }

    public SecurityConstraint[] findSecurityConstraints(String requestPathMB, String httpMethod, Context context) {
        JaccWebAuthorizationManager authorizationManager;
        if (!this.jaspicRealm.isInitialised()) {
            this.jaspicRealm.initJaspicServices(context.getServletContext());
        }
        if ((authorizationManager = this.getJaccWebAuthorizationManager(false)) != null && authorizationManager.hasNoConstrainedResources() && !this.jaspicRealm.isJaspicEnabled(context.getServletContext())) {
            return null;
        }
        return emptyConstraints;
    }

    public boolean hasUserDataPermission(HttpRequest request, HttpResponse response, SecurityConstraint[] constraints) throws IOException {
        return this.hasUserDataPermission(request, response, constraints, null, null);
    }

    public boolean hasUserDataPermission(HttpRequest request, HttpResponse response, SecurityConstraint[] constraints, String uri, String method) throws IOException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        if (httpServletRequest.getServletPath() == null) {
            request.setServletPath(this.getResourceName(httpServletRequest.getRequestURI(), httpServletRequest.getContextPath()));
        }
        this.logHasUserDataPermission(httpServletRequest);
        if (request.getRequest().isSecure()) {
            this.logRequestSecure(request);
            return true;
        }
        JaccWebAuthorizationManager authorizationManager = this.getJaccWebAuthorizationManager(true);
        if (authorizationManager == null) {
            return false;
        }
        int isGranted = 0;
        try {
            isGranted = authorizationManager.hasUserDataPermission(httpServletRequest, uri, method);
        }
        catch (IllegalArgumentException e) {
            this.sendBadRequest(response, e);
            return false;
        }
        if (isGranted == -1) {
            this.logSSLRedirect();
            return this.redirect(request, response);
        }
        if (isGranted == 0) {
            this.sendForbidden(response);
            return false;
        }
        return true;
    }

    public int preAuthenticateCheck(HttpRequest request, HttpResponse response, SecurityConstraint[] constraints, boolean disableProxyCaching, boolean securePagesWithPragma, boolean ssoEnabled) throws IOException {
        boolean isGranted = false;
        try {
            if (!this.hasRequestPrincipal(request)) {
                SecurityContext.setUnauthenticatedContext();
            }
            if (this.jaspicRealm.isJaspicEnabled()) {
                return 1;
            }
            isGranted = this.invokeWebSecurityManager(request, response, constraints);
        }
        catch (IOException iex) {
            throw iex;
        }
        catch (Throwable ex) {
            this.sendServiceUnavailable(response, ex);
            return -1;
        }
        if (isGranted) {
            if (this.hasRequestPrincipal(request)) {
                this.disableProxyCaching(request, response, disableProxyCaching, securePagesWithPragma);
                if (ssoEnabled) {
                    HttpServletRequest httpServletRequest = (HttpServletRequest)request.getRequest();
                    if (!this.getJaccWebAuthorizationManager(true).isPermitAll(httpServletRequest)) {
                        httpServletRequest.getSession(true);
                    }
                }
            }
            return 0;
        }
        if (this.hasRequestPrincipal(request)) {
            this.sendForbidden(response);
            return -1;
        }
        this.disableProxyCaching(request, response, disableProxyCaching, securePagesWithPragma);
        return 1;
    }

    public boolean invokeAuthenticateDelegate(HttpRequest request, HttpResponse response, Context context, Authenticator authenticator, boolean calledFromAuthenticate) throws IOException {
        if (this.jaspicRealm.isJaspicEnabled()) {
            return this.jaspicRealm.validateRequest(request, response, context, authenticator, calledFromAuthenticate, e -> !this.getJaccWebAuthorizationManager(true).isPermitAll(e));
        }
        return ((AuthenticatorBase)authenticator).authenticate(request, response, context.getLoginConfig());
    }

    protected String getName() {
        return name;
    }

    public String getRealmName() {
        return this.realmName;
    }

    public void setVirtualServer(Object container) {
        this.jaspicRealm.setVirtualServer((Container)container);
    }

    public void updateWebSecurityManager() {
        if (this.jaccWebAuthorizationManager == null) {
            this.jaccWebAuthorizationManager = this.getJaccWebAuthorizationManager(true);
        }
        if (this.jaccWebAuthorizationManager != null) {
            try {
                this.jaccWebAuthorizationManager.release();
                this.jaccWebAuthorizationManager.destroy();
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, "Failed to release and destroy the jaccWebAuthorizationManager", ex);
            }
            this.jaccWebAuthorizationManager = this.webSecurityManagerFactory.createManager(this.webDescriptor, true, this.serverContext);
            LOG.fine(() -> "JaccWebAuthorizationManager for " + this.jaccContextId + " has been updated");
        }
    }

    public Principal authenticate(String username, char[] password) {
        LOG.finest(() -> String.format("authenticate(username=%s, password)", username));
        if (this.authenticate(username, password, null, null)) {
            return new WebPrincipal(username, password, SecurityContext.getCurrent());
        }
        return null;
    }

    public Principal authenticate(HttpServletRequest httpServletRequest) {
        String username;
        DigestAlgorithmParameter[] params;
        try {
            params = this.getDigestParameters(httpServletRequest);
            username = this.getDigestKey(params).getUsername();
        }
        catch (Exception le) {
            LOG.log(Level.WARNING, "web.login.failed", (Object)le);
            return null;
        }
        if (this.authenticate(username, null, null, params)) {
            return new WebPrincipal(username, (char[])null, SecurityContext.getCurrent());
        }
        return null;
    }

    public Principal authenticate(X509Certificate[] certificates) {
        if (this.authenticate(null, null, certificates, null)) {
            return new WebPrincipal(certificates, SecurityContext.getCurrent(), true);
        }
        return null;
    }

    public boolean hasResourcePermission(HttpRequest request, HttpResponse response, SecurityConstraint[] constraints, Context context) throws IOException {
        boolean isGranted = false;
        try {
            isGranted = this.invokeWebSecurityManager(request, response, constraints);
        }
        catch (IOException iex) {
            throw iex;
        }
        catch (Throwable ex) {
            LOG.log(Level.SEVERE, "web_server.excep_authenticate_realmadapter", ex);
            ((HttpServletResponse)response.getResponse()).sendError(503);
            response.setDetailMessage(resourceBundle.getString("realmBase.forbidden"));
            return isGranted;
        }
        if (isGranted) {
            return isGranted;
        }
        ((HttpServletResponse)response.getResponse()).sendError(403);
        response.setDetailMessage(resourceBundle.getString("realmBase.forbidden"));
        this.invokePostAuthenticateDelegate(request, response, context);
        return isGranted;
    }

    public boolean invokePostAuthenticateDelegate(HttpRequest request, HttpResponse response, Context context) throws IOException {
        if (this.jaspicRealm.isJaspicEnabled()) {
            return this.jaspicRealm.secureResponse(request, response, context);
        }
        return false;
    }

    public boolean hasRole(HttpRequest request, HttpResponse response, Principal principal, String role) {
        JaccWebAuthorizationManager authorizationManager = this.getJaccWebAuthorizationManager(true);
        if (authorizationManager == null) {
            return false;
        }
        String servletName = this.getCanonicalName(request);
        boolean isGranted = authorizationManager.hasRoleRefPermission(servletName, role, principal);
        LOG.fine(() -> "Checking if servlet " + servletName + " with principal " + principal + " has role " + role + " isGranted: " + isGranted);
        return isGranted;
    }

    public void logout(HttpRequest httpRequest) {
        ServletContext servletContext = httpRequest.getRequest().getServletContext();
        byte[] alreadyCalled = reentrancyStatus.get();
        if (this.jaspicRealm.isJaspicEnabled(servletContext) && alreadyCalled[0] == 0) {
            alreadyCalled[0] = 1;
            try {
                this.jaspicRealm.cleanSubject(httpRequest);
            }
            catch (AuthException ex) {
                throw new RuntimeException(ex);
            }
            finally {
                this.doLogout(httpRequest, true);
                alreadyCalled[0] = 0;
            }
        } else {
            this.doLogout(httpRequest, alreadyCalled[0] == 1);
        }
    }

    public void logout() {
        this.setSecurityContext(null);
        AccessController.doPrivileged(() -> {
            this.resetPolicyContext();
            return null;
        });
    }

    public void destroy() {
        super.destroy();
        this.jaspicRealm.destroy();
    }

    public boolean authenticate(WebPrincipal principal) {
        if (principal.isUsingCertificate()) {
            return this.authenticate(null, null, principal.getCertificates(), null);
        }
        return this.authenticate(principal.getName(), principal.getPassword(), null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JaccWebAuthorizationManager getJaccWebAuthorizationManager(boolean logNull) {
        if (this.jaccWebAuthorizationManager == null) {
            RealmAdapter realmAdapter = this;
            synchronized (realmAdapter) {
                this.jaccWebAuthorizationManager = this.webSecurityManagerFactory.getManager(this.jaccContextId, null, false);
            }
            if (this.jaccWebAuthorizationManager == null && logNull) {
                LOG.log(Level.WARNING, "realmAdapter.noWebSecMgr", this.jaccContextId);
            }
        }
        return this.jaccWebAuthorizationManager;
    }

    public Principal createFailOveredPrincipal(String username) {
        LOG.log(Level.FINEST, "createFailOveredPrincipal ({0})", username);
        this.loginForRunAs(username);
        SecurityContext securityContext = SecurityContext.getCurrent();
        LOG.log(Level.FINE, "Security context is {0}", securityContext);
        WebPrincipal principal = new WebPrincipal(username, (char[])null, securityContext);
        LOG.log(Level.INFO, "Principal created for FailOvered user {0}", principal);
        return principal;
    }

    public boolean hasRole(String servletName, Principal principal, String role) {
        JaccWebAuthorizationManager authorizationManager = this.getJaccWebAuthorizationManager(true);
        if (authorizationManager == null) {
            return false;
        }
        return authorizationManager.hasRoleRefPermission(servletName, role, principal);
    }

    public void preSetRunAsIdentity(ComponentInvocation inv) {
        if (this.runAsPrincipals != null && this.runAsPrincipals.isEmpty()) {
            return;
        }
        String servletName = this.getServletName(inv);
        if (servletName == null) {
            return;
        }
        String runAs = this.runAsPrincipals.get(servletName);
        if (runAs != null) {
            SecurityContext old = this.getSecurityContext();
            inv.setOldSecurityContext((Object)old);
            this.loginForRunAs(runAs);
            LOG.fine(() -> "run-as principal for " + servletName + " set to: " + runAs);
        }
    }

    public void postSetRunAsIdentity(ComponentInvocation invocation) {
        if (this.runAsPrincipals != null && this.runAsPrincipals.isEmpty()) {
            return;
        }
        String servletName = this.getServletName(invocation);
        if (servletName == null) {
            return;
        }
        String runAs = this.runAsPrincipals.get(servletName);
        if (runAs != null) {
            this.setSecurityContext((SecurityContext)invocation.getOldSecurityContext());
        }
    }

    private boolean authenticate(String username, char[] password, X509Certificate[] certs, DigestAlgorithmParameter[] digestParams) {
        try {
            if (certs != null) {
                WebAndEjbToJaasBridge.doX500Login((Subject)this.createSubjectWithCerts(certs), (String)this.moduleID);
            } else if (digestParams != null) {
                WebAndEjbToJaasBridge.login((DigestCredentials)new DigestCredentials(this.realmName, username, digestParams));
            } else {
                WebAndEjbToJaasBridge.login((String)username, (char[])password, (String)this.realmName);
            }
            LOG.log(Level.FINE, () -> "Web login succeeded for: " + username);
            return true;
        }
        catch (Exception le) {
            LOG.log(Level.WARNING, "web.login.failed", (Object)le);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Web login failed for user " + username, le);
            }
            return false;
        }
    }

    private String computeRealmName(String defaultRealmName) {
        Application application = this.webDescriptor.getApplication();
        LoginConfiguration loginConfig = this.webDescriptor.getLoginConfiguration();
        String computedRealmName = application.getRealm();
        if (computedRealmName == null && loginConfig != null) {
            computedRealmName = loginConfig.getRealmName();
        }
        if (defaultRealmName != null && (computedRealmName == null || computedRealmName.isEmpty())) {
            computedRealmName = defaultRealmName;
        }
        return computedRealmName;
    }

    private void doLogout(HttpRequest request, boolean extensionEnabled) {
        Context context = request.getContext();
        Authenticator authenticator = context == null ? null : context.getAuthenticator();
        Objects.requireNonNull(authenticator, "Context or Authenticator is null");
        try {
            if (extensionEnabled) {
                new AuthenticatorProxy(authenticator, null, null).logout(request);
            } else {
                authenticator.logout(request);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        this.logout();
    }

    private String getServletName(ComponentInvocation invocation) {
        HttpServlet thisServlet;
        ServletConfig servletConfig;
        String servletName = invocation.getInstanceName();
        if (servletName != null) {
            return servletName;
        }
        Object invocationInstance = invocation.getInstance();
        if (invocationInstance instanceof HttpServlet && (servletConfig = (thisServlet = (HttpServlet)invocationInstance).getServletConfig()) != null) {
            return thisServlet.getServletName();
        }
        return null;
    }

    private void loginForRunAs(String principal) {
        WebAndEjbToJaasBridge.loginPrincipal((String)principal, (String)this.realmName);
    }

    private SecurityContext getSecurityContext() {
        return SecurityContext.getCurrent();
    }

    private void setSecurityContext(SecurityContext securityContext) {
        SecurityContext.setCurrent((SecurityContext)securityContext);
    }

    protected char[] getPassword(String username) {
        throw new IllegalStateException("Should not reach here");
    }

    protected Principal getPrincipal(String username) {
        throw new IllegalStateException("Should not reach here");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean invokeWebSecurityManager(HttpRequest request, HttpResponse response, SecurityConstraint[] constraints) throws IOException {
        HttpServletRequest httpServletRequest;
        boolean evaluated = false;
        try {
            this.rwLock.readLock().lock();
            evaluated = this.contextEvaluated;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
        if (!evaluated) {
            try {
                this.rwLock.writeLock().lock();
                if (!this.contextEvaluated) {
                    Context context = (Context)this.getContainer();
                    LoginConfig config = context.getLoginConfig();
                    if (config != null && FORM.equals(config.getAuthMethod())) {
                        this.loginPage = config.getLoginPage();
                        this.errorPage = config.getErrorPage();
                    }
                    this.contextEvaluated = true;
                }
            }
            finally {
                this.rwLock.writeLock().unlock();
            }
        }
        if (this.loginPage != null || this.errorPage != null) {
            String requestURI = request.getRequestPathMB().toString();
            LOG.fine(() -> "[Web-Security]  requestURI: " + requestURI + " loginPage: " + this.loginPage);
            if (this.loginPage != null && this.loginPage.equals(requestURI)) {
                LOG.fine(() -> " Allow access to login page " + this.loginPage);
                return true;
            }
            if (this.errorPage != null && this.errorPage.equals(requestURI)) {
                LOG.fine(() -> " Allow access to error page " + this.errorPage);
                return true;
            }
            if (requestURI.endsWith("/j_security_check")) {
                LOG.fine(" Allow access to username/password submission");
                return true;
            }
        }
        if ((httpServletRequest = (HttpServletRequest)request).getServletPath() == null) {
            request.setServletPath(this.getResourceName(httpServletRequest.getRequestURI(), httpServletRequest.getContextPath()));
        }
        LOG.fine(() -> "[Web-Security] [ hasResourcePermission ] Principal: " + httpServletRequest.getUserPrincipal() + " ContextPath: " + httpServletRequest.getContextPath());
        JaccWebAuthorizationManager authorizationManager = this.getJaccWebAuthorizationManager(true);
        if (authorizationManager == null) {
            return false;
        }
        return authorizationManager.hasResourcePermission(httpServletRequest);
    }

    private boolean redirect(HttpRequest request, HttpResponse response) throws IOException {
        String queryString;
        HttpServletRequest httpServletRequest = (HttpServletRequest)request.getRequest();
        HttpServletResponse httpServletResponse = (HttpServletResponse)response.getResponse();
        int redirectPort = request.getConnector().getRedirectPort();
        if (redirectPort <= 0) {
            LOG.fine("[Web-Security]  SSL redirect is disabled");
            httpServletResponse.sendError(403, URLEncoder.encode(httpServletRequest.getRequestURI(), "UTF-8"));
            return false;
        }
        StringBuilder file = new StringBuilder(httpServletRequest.getRequestURI());
        String requestedSessionId = httpServletRequest.getRequestedSessionId();
        if (requestedSessionId != null && httpServletRequest.isRequestedSessionIdFromURL()) {
            file.append(";jsessionid=");
            file.append(requestedSessionId);
        }
        if ((queryString = httpServletRequest.getQueryString()) != null) {
            file.append('?');
            file.append(queryString);
        }
        List<String> hostAndPort = this.getHostAndPort(request);
        try {
            httpServletResponse.sendRedirect(new URL("https", hostAndPort.get(0), Integer.parseInt(hostAndPort.get(1)), file.toString()).toExternalForm());
            return false;
        }
        catch (MalformedURLException e) {
            httpServletResponse.sendError(500, URLEncoder.encode(httpServletRequest.getRequestURI(), "UTF-8"));
            return false;
        }
    }

    private List<String> getHostAndPort(HttpRequest request) throws IOException {
        boolean isHostPortNullOrEmpty;
        boolean isWebServerRequest = false;
        Enumeration<String> headerNames = ((HttpServletRequest)request.getRequest()).getHeaderNames();
        String[] hostPort = null;
        boolean isHeaderPresent = false;
        while (headerNames.hasMoreElements()) {
            String headerName = headerNames.nextElement();
            if (!headerName.equalsIgnoreCase("Host")) continue;
            String hostVal = ((HttpServletRequest)request.getRequest()).getHeader(headerName);
            isHeaderPresent = true;
            hostPort = hostVal.split(":");
        }
        if (hostPort == null) {
            throw new ProtocolException(resourceBundle.getString("missing_http_header.host"));
        }
        boolean bl = isHostPortNullOrEmpty = hostPort.length <= 1 || hostPort[1] == null || hostPort[1].trim().isEmpty();
        if (!isHeaderPresent) {
            isWebServerRequest = false;
        } else if (isHostPortNullOrEmpty) {
            isWebServerRequest = true;
        } else {
            boolean breakFromLoop = false;
            for (NetworkListener nwListener : this.nwListeners.getNetworkListener()) {
                String nwAddress = nwListener.getAddress();
                if (nwAddress == null || nwAddress.equals("0.0.0.0")) {
                    nwAddress = NetUtils.getCanonicalHostName();
                    if (!nwAddress.equals(hostPort[0])) {
                        InetAddress[] localHostAdresses = NetUtils.getHostAddresses();
                        InetAddress hostAddress = InetAddress.getByName(hostPort[0]);
                        for (InetAddress inetAdress : localHostAdresses) {
                            if (!inetAdress.equals(hostAddress)) continue;
                            String nwPort = nwListener.getPort();
                            if (!nwPort.equals(hostPort[1])) {
                                isWebServerRequest = true;
                                continue;
                            }
                            isWebServerRequest = false;
                            breakFromLoop = true;
                            break;
                        }
                    } else {
                        String nwPort = nwListener.getPort();
                        if (!nwPort.equals(hostPort[1])) {
                            isWebServerRequest = true;
                        } else {
                            isWebServerRequest = false;
                            breakFromLoop = true;
                        }
                    }
                }
                if (!breakFromLoop || isWebServerRequest) continue;
                break;
            }
        }
        String serverHost = request.getRequest().getServerName();
        int redirectPort = request.getConnector().getRedirectPort();
        if (isWebServerRequest) {
            serverHost = hostPort[0];
            redirectPort = isHostPortNullOrEmpty ? -1 : Integer.parseInt(hostPort[1]);
        }
        return Arrays.asList(serverHost, String.valueOf(redirectPort));
    }

    private String getCanonicalName(HttpRequest currentRequest) {
        return currentRequest.getWrapper().getServletName();
    }

    private String getResourceName(String uri, String contextPath) {
        if (contextPath.length() < uri.length()) {
            return uri.substring(contextPath.length());
        }
        return "";
    }

    private void logHasUserDataPermission(HttpServletRequest httpServletRequest) {
        LOG.fine(() -> "[Web-Security][ hasUserDataPermission ] Principal: " + httpServletRequest.getUserPrincipal() + " ContextPath: " + httpServletRequest.getContextPath());
    }

    private void logRequestSecure(HttpRequest request) {
        LOG.fine(() -> "[Web-Security] request.getRequest().isSecure(): " + request.getRequest().isSecure());
    }

    private void logSSLRedirect() {
        LOG.fine("[Web-Security] redirecting using SSL");
    }

    private void sendBadRequest(HttpResponse response, Exception e) throws IOException {
        LOG.log(Level.WARNING, resourceBundle.getString("realmAdapter.badRequestWithId"), e);
        HttpServletResponse httpServletResponse = (HttpServletResponse)response.getResponse();
        httpServletResponse.sendError(400, resourceBundle.getString("realmAdapter.badRequest"));
    }

    private void sendForbidden(HttpResponse response) throws IOException {
        HttpServletResponse httpServletResponse = (HttpServletResponse)response.getResponse();
        httpServletResponse.sendError(403, resourceBundle.getString("realmBase.forbidden"));
    }

    private void sendServiceUnavailable(HttpResponse response, Throwable e) throws IOException {
        LOG.log(Level.SEVERE, "web_server.excep_authenticate_realmadapter", e);
        HttpServletResponse httpServletResponse = (HttpServletResponse)response.getResponse();
        httpServletResponse.sendError(503);
        response.setDetailMessage(resourceBundle.getString("realmBase.forbidden"));
    }

    private void resetPolicyContext() {
        ((PolicyContextHandlerImpl)PolicyContextHandlerImpl.getInstance()).reset();
        PolicyContext.setContextID(null);
    }

    private SecurityContext getSecurityContextForPrincipal(final Principal principal) {
        if (principal == null) {
            return null;
        }
        if (principal instanceof WebPrincipal) {
            return ((WebPrincipal)principal).getSecurityContext();
        }
        return AccessController.doPrivileged(new PrivilegedAction<SecurityContext>(){

            @Override
            public SecurityContext run() {
                Subject subject = new Subject();
                subject.getPrincipals().add(principal);
                return new SecurityContext(principal.getName(), subject);
            }
        });
    }

    public void setCurrentSecurityContextWithWebPrincipal(Principal principal) {
        if (principal instanceof WebPrincipal) {
            SecurityContext.setCurrent((SecurityContext)this.getSecurityContextForPrincipal(principal));
        }
    }

    public void setCurrentSecurityContext(Principal principal) {
        SecurityContext.setCurrent((SecurityContext)this.getSecurityContextForPrincipal(principal));
    }

    private Subject createSubjectWithCerts(X509Certificate[] certificates) {
        Subject subject = new Subject();
        subject.getPublicCredentials().add(certificates[0].getSubjectX500Principal());
        subject.getPublicCredentials().add(Arrays.asList(certificates));
        return subject;
    }

    public void postConstruct() {
        this.nwListeners = this.networkConfig.getNetworkListeners();
    }

    private DigestAlgorithmParameter[] getDigestParameters(HttpServletRequest request) throws InvalidAlgorithmParameterException {
        return this.cNonceValidator.validateCnonce(DigestParameterGenerator.getInstance((String)"HttpDigest").generateParameters((AlgorithmParameterSpec)new HttpAlgorithmParameterImpl(request)));
    }

    private Key getDigestKey(DigestAlgorithmParameter[] params) {
        for (DigestAlgorithmParameter dap : params) {
            if (!"A1".equals(dap.getName()) || !(dap instanceof Key)) continue;
            return (Key)dap;
        }
        throw new RuntimeException("No key found in parameters");
    }

    private boolean hasRequestPrincipal(HttpRequest request) {
        return ((HttpServletRequest)request).getUserPrincipal() != null;
    }

    @FunctionalInterface
    public static interface IOSupplier<T> {
        public T get() throws IOException;
    }
}

