/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.security.realmadapter;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.security.jaspic.config.PayaraJaspicServletServices;
import com.sun.enterprise.security.web.integration.WebPrincipal;
import com.sun.jaspic.config.servlet.HttpMessageInfo;
import com.sun.logging.LogDomains;
import com.sun.web.security.HttpRequestWrapper;
import com.sun.web.security.HttpResponseWrapper;
import com.sun.web.security.RealmAdapter;
import com.sun.web.security.realmadapter.AuthenticatorProxy;
import fish.payara.notification.requesttracing.RequestTraceSpan;
import fish.payara.nucleus.requesttracing.RequestTracingService;
import java.io.IOException;
import java.security.Principal;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.AuthStatus;
import javax.security.auth.message.MessageInfo;
import javax.security.auth.message.config.ServerAuthConfig;
import javax.security.auth.message.config.ServerAuthContext;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Authenticator;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.connector.RequestFacade;
import org.apache.catalina.deploy.LoginConfig;

public class JaspicRealm {
    private static final Logger logger = LogDomains.getLogger(RealmAdapter.class, (String)"javax.enterprise.system.container.web");
    private static final String SYSTEM_HTTPSERVLET_SECURITY_PROVIDER = "system_httpservlet_security_provider";
    private static final String SERVER_AUTH_CONTEXT = "__javax.security.auth.message.ServerAuthContext";
    private static final String MESSAGE_INFO = "__javax.security.auth.message.MessageInfo";
    private static String jaspicSystemConfigProviderID = JaspicRealm.getDefaultSystemProviderID();
    private String realmName;
    private boolean isSystemApp;
    private WebBundleDescriptor webDescriptor;
    private RequestTracingService requestTracing;
    private Container virtualServer;
    private PayaraJaspicServletServices jaspicServices;
    private AtomicBoolean initialised = new AtomicBoolean();

    public JaspicRealm(String realmName, boolean isSystemApp, WebBundleDescriptor webDescriptor, RequestTracingService requestTracing) {
        this.realmName = realmName;
        this.isSystemApp = isSystemApp;
        this.webDescriptor = webDescriptor;
        this.requestTracing = requestTracing;
    }

    public void setVirtualServer(Container virtualServer) {
        this.virtualServer = virtualServer;
    }

    public synchronized void initJaspicServices(ServletContext servletContext) {
        if (this.jaspicServices != null) {
            return;
        }
        this.jaspicServices = this.getConfigHelper(servletContext);
        this.initialised.set(true);
    }

    public boolean isInitialised() {
        return this.initialised.get();
    }

    public boolean isJaspicEnabled(ServletContext servletContext) {
        if (this.jaspicServices == null) {
            this.initJaspicServices(servletContext);
        }
        return this.isJaspicEnabled();
    }

    public boolean isJaspicEnabled() {
        return this.getServerAuthConfig() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validateRequest(HttpRequest request, HttpResponse response, Context context, Authenticator authenticator, boolean calledFromAuthenticate, Function<HttpServletRequest, Boolean> isMandatoryFn) throws IOException {
        try {
            context.fireContainerEvent("beforeAuthentication", null);
            RequestFacade requestFacade = (RequestFacade)request.getRequest();
            this.setAdditionalPrincipalInContext(requestFacade);
            boolean bl = this.validateRequest(this.getServerAuthConfig(), context, requestFacade, request, response, context.getLoginConfig(), authenticator, calledFromAuthenticate, isMandatoryFn);
            return bl;
        }
        finally {
            this.resetAdditionalPrincipalInContext();
            context.fireContainerEvent("afterAuthentication", null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean secureResponse(HttpRequest request, HttpResponse response, Context context) throws IOException {
        block11: {
            Map.Entry<MessageInfo, ServerAuthContext> messageInfoEntry = null;
            try {
                boolean bl;
                messageInfoEntry = this.getMessageInfoFromRequest((HttpServletRequest)request.getRequest());
                if (messageInfoEntry == null) break block11;
                try {
                    context.fireContainerEvent("beforePostAuthentication", null);
                    ServerAuthContext serverAuthContext = messageInfoEntry.getValue();
                    MessageInfo messageInfo = messageInfoEntry.getKey();
                    bl = AuthStatus.SUCCESS.equals(serverAuthContext.secureResponse(messageInfo, null));
                }
                catch (Throwable throwable) {
                    try {
                        context.fireContainerEvent("afterPostAuthentication", null);
                        throw throwable;
                    }
                    catch (AuthException ex) {
                        throw new IOException(ex);
                    }
                    catch (Throwable throwable2) {
                        throw throwable2;
                    }
                }
                context.fireContainerEvent("afterPostAuthentication", null);
                return bl;
            }
            finally {
                if (messageInfoEntry != null) {
                    if (request instanceof HttpRequestWrapper) {
                        request.removeNote("__javax.security.auth.message.request");
                    }
                    if (response instanceof HttpResponseWrapper) {
                        request.removeNote("__javax.security.auth.message.response");
                    }
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanSubject(HttpRequest httpRequest) throws AuthException {
        MessageInfo messageInfo = (MessageInfo)httpRequest.getRequest().getAttribute(MESSAGE_INFO);
        if (messageInfo == null) {
            messageInfo = new HttpMessageInfo((HttpServletRequest)httpRequest.getRequest(), (HttpServletResponse)httpRequest.getResponse().getResponse());
        }
        messageInfo.getMap().put("javax.security.auth.message.MessagePolicy.isMandatory", Boolean.TRUE.toString());
        ServerAuthContext serverAuthContext = this.jaspicServices.getServerAuthContext(messageInfo, null);
        if (serverAuthContext != null) {
            Subject subject;
            SecurityContext securityContext = SecurityContext.getCurrent();
            Subject subject2 = subject = securityContext.didServerGenerateCredentials() ? new Subject() : securityContext.getSubject();
            if (subject == null) {
                subject = new Subject();
            }
            if (subject.isReadOnly()) {
                logger.log(Level.WARNING, "Read-only subject found during logout processing");
            }
            try {
                httpRequest.getContext().fireContainerEvent("beforePostAuthentication", null);
                serverAuthContext.cleanSubject(messageInfo, subject);
            }
            finally {
                httpRequest.getContext().fireContainerEvent("afterPostAuthentication", null);
            }
        }
    }

    public void destroy() {
        if (this.jaspicServices != null) {
            this.jaspicServices.disable();
        }
    }

    private ServerAuthConfig getServerAuthConfig() {
        if (this.jaspicServices == null) {
            return null;
        }
        try {
            return this.jaspicServices.getServerAuthConfig();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private ServerAuthContext getServerAuthContext(MessageInfo messageInfo) throws AuthException {
        ServerAuthContext authContext = this.jaspicServices.getServerAuthContext(messageInfo, null);
        if (authContext == null) {
            throw new AuthException("null ServerAuthContext");
        }
        return authContext;
    }

    private PayaraJaspicServletServices getConfigHelper(ServletContext servletContext) {
        HashMap<String, WebBundleDescriptor> map = new HashMap<String, WebBundleDescriptor>();
        map.put("WEB_BUNDLE", this.webDescriptor);
        return new PayaraJaspicServletServices(this.getAppContextID(servletContext), map, null, this.realmName, this.isSystemApp, jaspicSystemConfigProviderID);
    }

    private String getAppContextID(ServletContext servletContext) {
        if (!servletContext.getVirtualServerName().equals(this.virtualServer.getName())) {
            logger.log(Level.INFO, "Virtual server name from ServletContext: {0} differs from name from virtual.getName(): {1}", new Object[]{servletContext.getVirtualServerName(), this.virtualServer.getName()});
        }
        if (!servletContext.getContextPath().equals(this.webDescriptor.getContextRoot())) {
            logger.log(Level.INFO, "Context path from ServletContext: {0} differs from path from bundle: {1}", new Object[]{servletContext.getContextPath(), this.webDescriptor.getContextRoot()});
        }
        return servletContext.getVirtualServerName() + " " + servletContext.getContextPath();
    }

    private static String getDefaultSystemProviderID() {
        String p = System.getProperty(SYSTEM_HTTPSERVLET_SECURITY_PROVIDER);
        if (p != null && (p = p.trim()).length() == 0) {
            p = null;
        }
        return p;
    }

    private void setAdditionalPrincipalInContext(RequestFacade requestFacade) {
        Principal wrapped;
        if (requestFacade != null && (wrapped = requestFacade.getPrincipal()) != null) {
            SecurityContext.getCurrent().setAdditionalPrincipal(wrapped);
        }
    }

    private void resetAdditionalPrincipalInContext() {
        SecurityContext.getCurrent().setAdditionalPrincipal(null);
    }

    private boolean validateRequest(ServerAuthConfig serverAuthConfig, Context context, RequestFacade requestFacade, HttpRequest request, HttpResponse response, LoginConfig loginConfig, Authenticator authenticator, boolean calledFromAuthenticate, Function<HttpServletRequest, Boolean> isMandatoryFn) throws IOException {
        if (this.isRequestTracingEnabled()) {
            return this.doTraced(serverAuthConfig, context, requestFacade, () -> this.validateRequest(request, response, loginConfig, authenticator, calledFromAuthenticate, isMandatoryFn));
        }
        return this.validateRequest(request, response, loginConfig, authenticator, calledFromAuthenticate, isMandatoryFn);
    }

    private boolean validateRequest(HttpRequest request, HttpResponse response, LoginConfig config, Authenticator authenticator, boolean calledFromAuthenticate, Function<HttpServletRequest, Boolean> isMandatoryFn) throws IOException {
        HttpServletRequest servletRequest = (HttpServletRequest)request.getRequest();
        HttpServletResponse servletResponse = (HttpServletResponse)response.getResponse();
        Subject subject = new Subject();
        HttpMessageInfo messageInfo = new HttpMessageInfo(servletRequest, servletResponse);
        boolean isValidateSuccess = false;
        boolean isMandatory = true;
        ServerAuthContext authContext = null;
        try {
            isMandatory = isMandatoryFn.apply(servletRequest);
            if (isMandatory || calledFromAuthenticate) {
                this.setMandatory((MessageInfo)messageInfo);
            }
            if (!(isValidateSuccess = AuthStatus.SUCCESS.equals((authContext = this.getServerAuthContext((MessageInfo)messageInfo)).validateRequest((MessageInfo)messageInfo, subject, null)))) {
                return false;
            }
        }
        catch (RuntimeException | AuthException e) {
            logger.log(Level.WARNING, "JASPIC: http msg authentication fail", e);
            servletResponse.setStatus(500);
        }
        this.storeMessageInfoInRequest(servletRequest, (MessageInfo)messageInfo, authContext);
        if (this.hasNewPrincipal(subject.getPrincipals())) {
            this.handleSamAuthenticated(subject, (MessageInfo)messageInfo, request, response, config, authenticator);
        } else {
            isValidateSuccess = this.handleSamNotAuthenticated((MessageInfo)messageInfo, isMandatory, isValidateSuccess, request, response);
        }
        if (isValidateSuccess) {
            this.checkRequestResponseWrappingNeeded((MessageInfo)messageInfo, request, response, servletRequest, servletResponse);
        }
        return isValidateSuccess;
    }

    private void handleSamAuthenticated(Subject subject, MessageInfo messageInfo, HttpRequest request, HttpResponse response, LoginConfig config, Authenticator authenticator) throws IOException {
        SecurityContext securityContext = new SecurityContext(subject);
        WebPrincipal webPrincipal = new WebPrincipal(securityContext.getCallerPrincipal(), securityContext);
        SecurityContext.setCurrent((SecurityContext)securityContext);
        try {
            String authType = this.getAuthType(messageInfo, config);
            if (this.shouldRegisterSession(messageInfo)) {
                new AuthenticatorProxy(authenticator, (Principal)webPrincipal, authType).authenticate(request, response, config);
            } else {
                request.setAuthType(authType == null ? "PLUGGABLE_PROVIDER" : authType);
                request.setUserPrincipal((Principal)webPrincipal);
            }
        }
        catch (LifecycleException le) {
            logger.log(Level.SEVERE, "[Web-Security] unable to register session", le);
        }
    }

    private boolean handleSamNotAuthenticated(MessageInfo messageInfo, boolean isMandatory, boolean isValidateSuccess, HttpRequest request, HttpResponse response) {
        if (this.hasRequestPrincipal(messageInfo)) {
            request.setUserPrincipal(null);
            request.setAuthType(null);
        }
        if (isMandatory) {
            return false;
        }
        return isValidateSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doTraced(ServerAuthConfig serverAuthConfig, Context context, RequestFacade requestFacade, RealmAdapter.IOSupplier<Boolean> supplier) throws IOException {
        boolean result;
        RequestTraceSpan span = null;
        try {
            span = new RequestTraceSpan("authenticateJaspic");
            span.addSpanTag("AppContext", serverAuthConfig.getAppContext());
            span.addSpanTag("Context", context.getPath());
            result = supplier.get();
            span.addSpanTag("AuthResult", Boolean.toString(result));
            Principal principal = requestFacade.getPrincipal();
            String principalName = "null";
            if (principal != null) {
                principalName = principal.getName();
            }
            span.addSpanTag("Principal", principalName);
        }
        finally {
            if (span != null) {
                this.requestTracing.traceSpan(span);
            }
        }
        return result;
    }

    private void checkRequestResponseWrappingNeeded(MessageInfo messageInfo, HttpRequest request, HttpResponse response, HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        HttpServletResponse wrappedServletResponse;
        HttpServletRequest wrappedServletRequest = (HttpServletRequest)messageInfo.getRequestMessage();
        if (wrappedServletRequest != servletRequest) {
            request.setNote("__javax.security.auth.message.request", (Object)new HttpRequestWrapper(request, wrappedServletRequest));
        }
        if ((wrappedServletResponse = (HttpServletResponse)messageInfo.getResponseMessage()) != servletResponse) {
            request.setNote("__javax.security.auth.message.response", (Object)new HttpResponseWrapper(response, wrappedServletResponse));
        }
    }

    private boolean isRequestTracingEnabled() {
        return this.requestTracing != null && this.requestTracing.isRequestTracingEnabled();
    }

    private boolean hasRequestPrincipal(MessageInfo messageInfo) {
        return ((HttpServletRequest)messageInfo.getRequestMessage()).getUserPrincipal() != null;
    }

    private boolean hasNewPrincipal(Set<Principal> principalSet) {
        return principalSet != null && !principalSet.isEmpty() && !this.principalSetContainsOnlyAnonymousPrincipal(principalSet);
    }

    private boolean principalSetContainsOnlyAnonymousPrincipal(Set<Principal> principalSet) {
        boolean containsOnlyAnonymousPrincipal = false;
        Principal defaultPrincipal = SecurityContext.getDefaultCallerPrincipal();
        if (defaultPrincipal != null && principalSet != null) {
            containsOnlyAnonymousPrincipal = principalSet.contains(defaultPrincipal);
        }
        if (containsOnlyAnonymousPrincipal) {
            Iterator<Principal> it = principalSet.iterator();
            while (it.hasNext()) {
                if (it.next().equals(defaultPrincipal)) continue;
                return false;
            }
        }
        return containsOnlyAnonymousPrincipal;
    }

    private void setMandatory(MessageInfo messageInfo) {
        messageInfo.getMap().put("javax.security.auth.message.MessagePolicy.isMandatory", Boolean.TRUE.toString());
    }

    private String getAuthType(MessageInfo messageInfo, LoginConfig config) {
        String authType = this.getAuthType(messageInfo);
        if (authType == null && config != null && config.getAuthMethod() != null) {
            authType = config.getAuthMethod();
        }
        return authType;
    }

    private String getAuthType(MessageInfo messageInfo) {
        return (String)messageInfo.getMap().get("javax.servlet.http.authType");
    }

    private boolean shouldRegisterSession(MessageInfo messageInfo) {
        Map map = messageInfo.getMap();
        return map.containsKey("com.sun.web.RealmAdapter.register") || this.mapEntryToBoolean("javax.servlet.http.registerSession", map);
    }

    private void storeMessageInfoInRequest(HttpServletRequest servletRequest, MessageInfo messageInfo, ServerAuthContext authContext) {
        messageInfo.getMap().put(SERVER_AUTH_CONTEXT, authContext);
        servletRequest.setAttribute(MESSAGE_INFO, messageInfo);
    }

    private Map.Entry<MessageInfo, ServerAuthContext> getMessageInfoFromRequest(HttpServletRequest servletRequest) {
        MessageInfo messageInfo;
        if (this.jaspicServices != null && (messageInfo = (MessageInfo)servletRequest.getAttribute(MESSAGE_INFO)) != null) {
            return new AbstractMap.SimpleImmutableEntry<MessageInfo, ServerAuthContext>(messageInfo, (ServerAuthContext)messageInfo.getMap().get(SERVER_AUTH_CONTEXT));
        }
        return null;
    }

    private boolean mapEntryToBoolean(String propName, Map map) {
        Object value;
        if (map.containsKey(propName) && (value = map.get(propName)) != null && value instanceof String) {
            return Boolean.valueOf((String)value);
        }
        return false;
    }
}

