/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.iiop.security;

import com.sun.corba.ee.spi.ior.IOR;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.presentation.rmi.StubAdapter;
import com.sun.enterprise.common.iiop.security.SecurityContext;
import com.sun.enterprise.iiop.security.ConnectionExecutionContext;
import com.sun.enterprise.iiop.security.InvalidIdentityTokenException;
import com.sun.enterprise.iiop.security.InvalidMechanismException;
import com.sun.enterprise.iiop.security.SecurityMechanismException;
import com.sun.enterprise.iiop.security.SecurityMechanismSelector;
import com.sun.enterprise.security.CORBAObjectPermission;
import com.sun.enterprise.security.auth.WebAndEjbToJaasBridge;
import com.sun.enterprise.security.common.AppservAccessController;
import com.sun.logging.LogDomains;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.security.CodeSource;
import java.security.Permission;
import java.security.Policy;
import java.security.Principal;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.security.auth.Subject;
import org.glassfish.enterprise.iiop.api.GlassFishORBHelper;
import org.glassfish.enterprise.iiop.api.ProtocolManager;
import org.glassfish.hk2.api.PostConstruct;
import org.jvnet.hk2.annotations.Service;
import org.omg.CORBA.Object;

@Service
@Singleton
public class SecurityContextUtil
implements PostConstruct {
    public static final int STATUS_PASSED = 0;
    public static final int STATUS_FAILED = 1;
    public static final int STATUS_RETRY = 2;
    private static Logger _logger = LogDomains.getLogger(SecurityContextUtil.class, (String)"javax.enterprise.system.core.security");
    private static String IS_A = "_is_a";
    private Policy policy;
    @Inject
    private GlassFishORBHelper orbHelper;
    @Inject
    private SecurityMechanismSelector securityMechanismSelector;

    public void postConstruct() {
        AppservAccessController.privilegedAlways(() -> {
            this.policy = Policy.getPolicy();
            return this.policy;
        });
    }

    public SecurityContext getSecurityContext(Object effectiveTarget) throws InvalidMechanismException, InvalidIdentityTokenException {
        IOR ior = ((ORB)this.orbHelper.getORB()).getIOR(effectiveTarget, false);
        if (StubAdapter.isStub((java.lang.Object)effectiveTarget) && StubAdapter.isLocal((java.lang.Object)effectiveTarget)) {
            ConnectionExecutionContext.setClientThreadID(Thread.currentThread().getId());
            return null;
        }
        try {
            return this.securityMechanismSelector.selectSecurityContext(ior);
        }
        catch (InvalidMechanismException ime) {
            _logger.log(Level.SEVERE, "iiop.invalidmechanism_exception", ime);
            throw new InvalidMechanismException(ime.getMessage());
        }
        catch (InvalidIdentityTokenException iite) {
            _logger.log(Level.SEVERE, "iiop.invalididtoken_exception", iite);
            throw new InvalidIdentityTokenException(iite.getMessage());
        }
        catch (SecurityMechanismException sme) {
            _logger.log(Level.SEVERE, "iiop.secmechanism_exception", sme);
            throw new RuntimeException(sme.getMessage());
        }
    }

    public static void receivedReply(int reply_status, Object effective_target) {
        if (reply_status == 1) {
            _logger.log(Level.FINE, "Failed status");
            throw new RuntimeException("Target did not accept security context");
        }
        if (reply_status == 2) {
            _logger.log(Level.FINE, "Retry status");
        } else {
            _logger.log(Level.FINE, "Passed status");
        }
    }

    public int setSecurityContext(SecurityContext context, byte[] objectId, String method, Socket socket) {
        _logger.log(Level.FINE, "ABOUT TO EVALUATE TRUST");
        try {
            SecurityContext securityContext = this.securityMechanismSelector.evaluateTrust(context, objectId, socket);
            if (securityContext == null) {
                return 0;
            }
            this.authenticate(securityContext.getSubject(), securityContext.getCredentialClass());
            if (this.authorizeCORBA(objectId, method)) {
                return 0;
            }
            return 1;
        }
        catch (Exception e) {
            if (!method.equals(IS_A)) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "iiop.authenticate_exception", e.toString());
                }
                _logger.log(Level.FINE, "Authentication Exception", e);
            }
            return 1;
        }
    }

    private void authenticate(Subject subject, Class<?> credentialClass) throws SecurityMechanismException {
        try {
            AppservAccessController.privilegedAlways(() -> WebAndEjbToJaasBridge.login((Subject)subject, (Class)credentialClass));
        }
        catch (Exception e) {
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, "iiop.login_exception", e.toString());
            }
            _logger.log(Level.FINE, "Login Exception", e);
            throw new SecurityMechanismException("Cannot login user:" + e.getMessage());
        }
    }

    private boolean authorizeCORBA(byte[] objectId, String method) throws Exception {
        ProtocolManager protocolManager = this.orbHelper.getProtocolManager();
        if (protocolManager == null) {
            return true;
        }
        if (protocolManager.getEjbDescriptor(objectId) != null) {
            return true;
        }
        ProtectionDomain principalsDomain = this.createPrincipalDomain(this.getPrincipalArray(com.sun.enterprise.security.SecurityContext.getCurrent()));
        CORBAObjectPermission permission = new CORBAObjectPermission("*", method);
        boolean result = this.policy.implies(principalsDomain, (Permission)permission);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "CORBA Object permission evaluation result=" + result + " for method=" + method);
        }
        return result;
    }

    private ProtectionDomain createPrincipalDomain(Principal[] principals) throws MalformedURLException {
        return new ProtectionDomain(new CodeSource(new URL("file://"), (Certificate[])null), null, null, principals);
    }

    private Principal[] getPrincipalArray(com.sun.enterprise.security.SecurityContext securityContext) {
        Set principalSet = securityContext.getPrincipalSet();
        return principalSet == null ? null : principalSet.toArray(new Principal[principalSet.size()]);
    }

    public void sendingReply(SecurityContext context) {
    }

    public static void unsetSecurityContext(boolean isLocal) {
        if (!isLocal) {
            com.sun.enterprise.security.SecurityContext.setCurrent(null);
        }
    }
}

