/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.schemadoc;

import com.sun.enterprise.admin.cli.schemadoc.AttributeMethodVisitor;
import com.sun.enterprise.admin.cli.schemadoc.ClassDef;
import com.sun.enterprise.admin.cli.schemadoc.GenerateDomainSchema;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

public class DocClassVisitor
extends ClassVisitor {
    private boolean hasConfiguredAnnotation = false;
    private String className;
    private List<String> interfaces;
    private ClassDef classDef;
    private boolean showDeprecated;

    public DocClassVisitor(boolean showDep) {
        super(589824);
        this.showDeprecated = showDep;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] intfs) {
        this.className = GenerateDomainSchema.toClassName(name);
        this.interfaces = new ArrayList<String>();
        for (String intf : intfs) {
            this.interfaces.add(GenerateDomainSchema.toClassName(intf));
        }
        this.classDef = new ClassDef(this.className, this.interfaces);
    }

    public List<String> getInterfaces() {
        return this.interfaces;
    }

    public void visitSource(String source, String debug) {
    }

    public void visitOuterClass(String owner, String name, String desc) {
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        this.hasConfiguredAnnotation |= "Lorg/jvnet/hk2/config/Configured;".equals(desc);
        if ("Ljava/lang/Deprecated;".equals(desc) && this.classDef != null) {
            this.classDef.setDeprecated(true);
        }
        return null;
    }

    public void visitAttribute(Attribute attr) {
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        return null;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        String type = null;
        try {
            if ((this.showDeprecated || (access & 0x20000) != 131072) && this.hasConfiguredAnnotation) {
                type = signature != null ? GenerateDomainSchema.toClassName(signature.substring(signature.indexOf(60) + 1, signature.lastIndexOf(62) - 1)) : GenerateDomainSchema.toClassName(desc);
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new RuntimeException(e.getMessage());
        }
        return name.startsWith("get") && type != null ? new AttributeMethodVisitor(this.classDef, name, type) : null;
    }

    public void visitEnd() {
    }

    public boolean isConfigured() {
        return this.hasConfiguredAnnotation;
    }

    public ClassDef getClassDef() {
        return this.hasConfiguredAnnotation ? this.classDef : null;
    }

    public String toString() {
        return "DocClassVisitor{className='" + this.className + '\'' + ", hasConfiguredAnnotation=" + this.hasConfiguredAnnotation + '}';
    }
}

