/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.healthcheck.admin;

import com.sun.enterprise.util.LocalStringManagerImpl;
import fish.payara.nucleus.healthcheck.HealthCheckService;
import fish.payara.nucleus.healthcheck.admin.HealthCheckServiceConfigurer;
import fish.payara.nucleus.healthcheck.configuration.HealthCheckServiceConfiguration;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;

@Deprecated
@Service(name="healthcheck-service-configure-checker-with-thresholds")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="healthcheck.service.configure.checker.with.thresholds")
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG})
@RestEndpoints(value={@RestEndpoint(configBean=HealthCheckServiceConfiguration.class, opType=RestEndpoint.OpType.POST, path="healthcheck-service-configure-checker-with-thresholds", description="Configures a Heakthcheck Service Checker with Thresholds")})
public class HealthCheckServiceConfigureCheckerWithThresholdsCommand
implements AdminCommand {
    private static final LocalStringManagerImpl strings = new LocalStringManagerImpl(HealthCheckServiceConfigurer.class);
    @Inject
    ServiceLocator habitat;
    @Inject
    protected Target targetUtil;
    @Inject
    protected Logger logger;
    @Inject
    HealthCheckService healthCheckService;
    @Param(name="enabled", optional=false)
    private Boolean enabled;
    @Param(name="dynamic", optional=true, defaultValue="false")
    protected Boolean dynamic;
    @Param(name="addToMicroProfileHealth", optional=true, defaultValue="false")
    private Boolean addToMicroProfileHealth;
    @Param(name="target", optional=true, defaultValue="server-config")
    protected String target;
    @Param(name="time", optional=true)
    @Min(value=1L, message="Time period must be 1 or more")
    private @Min(value=1L, message="Time period must be 1 or more") String time;
    @Param(name="unit", optional=true, acceptableValues="DAYS,HOURS,MICROSECONDS,MILLISECONDS,MINUTES,NANOSECONDS,SECONDS")
    private String unit;
    @Param(name="checkerName", optional=true)
    private String checkerName;
    @Param(name="serviceName", optional=false, acceptableValues="healthcheck-cpu,healthcheck-gc,healthcheck-cpool,healthcheck-heap,healthcheck-threads,healthcheck-machinemem, healthcheck-stuck")
    private String serviceName;
    @Param(name="thresholdCritical", optional=true)
    @Min(value=0L, message="Threshold is a percentage so must be greater than zero")
    @Max(value=100L, message="Threshold is a percentage so must be less than 100")
    private @Min(value=0L, message="Threshold is a percentage so must be greater than zero") @Max(value=100L, message="Threshold is a percentage so must be less than 100") String thresholdCritical;
    @Param(name="thresholdWarning", optional=true)
    @Min(value=0L, message="Threshold is a percentage so must be greater than zero")
    @Max(value=100L, message="Threshold is a percentage so must be less than 100")
    private @Min(value=0L, message="Threshold is a percentage so must be greater than zero") @Max(value=100L, message="Threshold is a percentage so must be less than 100") String thresholdWarning;
    @Param(name="thresholdGood", optional=true)
    @Min(value=0L, message="Threshold is a percentage so must be greater than zero")
    @Max(value=100L, message="Threshold is a percentage so must be less than 100")
    private @Min(value=0L, message="Threshold is a percentage so must be greater than zero") @Max(value=100L, message="Threshold is a percentage so must be less than 100") String thresholdGood;
    @Inject
    ServerEnvironment server;
    @Inject
    CommandRunner commandRunner;

    public void execute(AdminCommandContext context) {
        ActionReport mainActionReport = context.getActionReport();
        ActionReport checkerConfigureReport = mainActionReport.addSubActionsReport();
        CommandRunner.CommandInvocation checkerConfigureInvocation = this.commandRunner.getCommandInvocation("healthcheck-configure-service", checkerConfigureReport, context.getSubject());
        ParameterMap checkerConfigureParameters = new ParameterMap();
        checkerConfigureParameters.add((Object)"enabled", (Object)this.enabled.toString());
        checkerConfigureParameters.add((Object)"dynamic", (Object)this.dynamic.toString());
        checkerConfigureParameters.add((Object)"addToMicroProfileHealth", (Object)this.addToMicroProfileHealth.toString());
        checkerConfigureParameters.add((Object)"time", (Object)this.time);
        checkerConfigureParameters.add((Object)"unit", (Object)this.unit);
        checkerConfigureParameters.add((Object)"checkerName", (Object)this.checkerName);
        checkerConfigureParameters.add((Object)"serviceName", (Object)this.serviceName);
        checkerConfigureParameters.add((Object)"target", (Object)this.target);
        checkerConfigureInvocation.parameters(checkerConfigureParameters);
        checkerConfigureInvocation.execute();
        if (checkerConfigureReport.hasFailures()) {
            mainActionReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
            checkerConfigureReport.setMessage("Failed to configure checker");
        } else {
            ActionReport thresholdConfigureReport = mainActionReport.addSubActionsReport();
            CommandRunner.CommandInvocation thresholdConfigureInvocation = this.commandRunner.getCommandInvocation("healthcheck-configure-service-threshold", thresholdConfigureReport, context.getSubject());
            ParameterMap thresholdConfigureParameters = new ParameterMap();
            thresholdConfigureParameters.add((Object)"dynamic", (Object)this.dynamic.toString());
            thresholdConfigureParameters.add((Object)"serviceName", (Object)this.serviceName);
            thresholdConfigureParameters.add((Object)"target", (Object)this.target);
            thresholdConfigureParameters.add((Object)"thresholdCritical", (Object)this.thresholdCritical);
            thresholdConfigureParameters.add((Object)"thresholdWarning", (Object)this.thresholdWarning);
            thresholdConfigureParameters.add((Object)"thresholdGood", (Object)this.thresholdGood);
            thresholdConfigureInvocation.parameters(thresholdConfigureParameters);
            thresholdConfigureInvocation.execute();
            if (thresholdConfigureReport.hasFailures()) {
                mainActionReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
                checkerConfigureReport.setMessage("Failed to configure thresholds");
            }
        }
    }
}

