/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.healthcheck.preliminary;

import fish.payara.monitoring.collect.MonitoringData;
import fish.payara.monitoring.collect.MonitoringDataCollector;
import fish.payara.monitoring.collect.MonitoringDataSource;
import fish.payara.monitoring.collect.MonitoringWatchCollector;
import fish.payara.monitoring.collect.MonitoringWatchSource;
import fish.payara.notification.healthcheck.HealthCheckResultEntry;
import fish.payara.nucleus.healthcheck.HealthCheckResult;
import fish.payara.nucleus.healthcheck.HealthCheckWithThresholdExecutionOptions;
import fish.payara.nucleus.healthcheck.configuration.HeapMemoryUsageChecker;
import fish.payara.nucleus.healthcheck.preliminary.BaseThresholdHealthCheck;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import javax.annotation.PostConstruct;
import org.glassfish.hk2.runlevel.RunLevel;
import org.jvnet.hk2.annotations.Service;

@Service(name="healthcheck-heap")
@RunLevel(value=10)
public class HeapMemoryUsageHealthCheck
extends BaseThresholdHealthCheck<HealthCheckWithThresholdExecutionOptions, HeapMemoryUsageChecker>
implements MonitoringDataSource,
MonitoringWatchSource {
    @PostConstruct
    void postConstruct() {
        this.postConstruct(this, HeapMemoryUsageChecker.class);
    }

    @Override
    public HealthCheckWithThresholdExecutionOptions constructOptions(HeapMemoryUsageChecker checker) {
        return super.constructThresholdOptions(checker);
    }

    @Override
    protected String getDescription() {
        return "healthcheck.description.heapMemory";
    }

    @Override
    protected HealthCheckResult doCheckInternal() {
        HealthCheckResult result = new HealthCheckResult();
        MemoryUsage heap = HeapMemoryUsageHealthCheck.getMemoryUsage();
        String heapValueText = String.format("heap: init: %s, used: %s, committed: %s, max.: %s", this.prettyPrintBytes(heap.getInit()), this.prettyPrintBytes(heap.getUsed()), this.prettyPrintBytes(heap.getCommitted()), this.prettyPrintBytes(heap.getMax()));
        long percentage = HeapMemoryUsageHealthCheck.calculatePercentage(heap);
        result.add(new HealthCheckResultEntry(this.decideOnStatusWithRatio(percentage), heapValueText + "heap%: " + percentage + "%"));
        return result;
    }

    private static MemoryUsage getMemoryUsage() {
        return ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
    }

    public void collect(MonitoringWatchCollector collector) {
        this.collectUsage(collector, "ns:health HeapUsage", "Heap Usage", 15, true);
    }

    @MonitoringData(ns="health", intervalSeconds=4)
    public void collect(MonitoringDataCollector collector) {
        if (this.options != null && ((HealthCheckWithThresholdExecutionOptions)this.options).isEnabled()) {
            collector.collect((CharSequence)"HeapUsage", HeapMemoryUsageHealthCheck.calculatePercentage(HeapMemoryUsageHealthCheck.getMemoryUsage()));
        }
    }

    private static long calculatePercentage(MemoryUsage usage) {
        return usage.getMax() == 0L ? 0L : Math.round((double)usage.getUsed() / (double)usage.getMax() * 100.0);
    }
}

