/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.deployment.util;

import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Base64;

public final class URIUtils {
    private URIUtils() {
        throw new AssertionError();
    }

    public static InputStream openStream(URI uri) throws IOException {
        if (URIUtils.hasFileScheme(uri)) {
            return Files.newInputStream(Paths.get(uri), new OpenOption[0]);
        }
        return URIUtils.openHttpConnection(uri).getInputStream();
    }

    private static HttpURLConnection openHttpConnection(URI uri) throws IOException {
        URL url = uri.toURL();
        HttpURLConnection httpConnection = (HttpURLConnection)url.openConnection();
        String userInfo = url.getUserInfo();
        if (userInfo != null) {
            String encodedUserInfo = Base64.getEncoder().encodeToString(userInfo.getBytes());
            httpConnection.setRequestProperty("Authorization", "Basic " + encodedUserInfo);
        }
        return httpConnection;
    }

    public static File convertToFile(URI uri) throws IOException {
        if (URIUtils.hasFileScheme(uri)) {
            return new File(uri);
        }
        HttpURLConnection connection = URIUtils.openHttpConnection(uri);
        try {
            File file = FileUtils.createTempFile((InputStream)connection.getInputStream(), (String)"app", (String)"tmp");
            return file;
        }
        catch (IOException e) {
            try (InputStream err = connection.getErrorStream();){
                if (err != null) {
                    FileUtils.copy((InputStream)err, (OutputStream)new OutputStream(){

                        @Override
                        public void write(int b) {
                        }
                    }, (long)0L);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
        finally {
            connection.disconnect();
        }
    }

    public static boolean exists(URI uri) throws IOException {
        if (URIUtils.hasFileScheme(uri)) {
            return Files.exists(Paths.get(uri), new LinkOption[0]);
        }
        HttpURLConnection connection = URIUtils.openHttpConnection(uri);
        connection.setRequestMethod("HEAD");
        if (connection.getResponseCode() == 200) {
            return true;
        }
        connection.disconnect();
        return false;
    }

    public static boolean hasFileScheme(URI uri) {
        return "file".equalsIgnoreCase(uri.getScheme());
    }
}

