/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.internal.deployment;

import com.sun.enterprise.module.HK2Module;
import com.sun.enterprise.module.ModuleState;
import com.sun.enterprise.module.ModulesRegistry;
import java.io.PrintStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.internal.deployment.analysis.StructuredDeploymentTracing;

public class DeploymentTracing {
    private final StructuredDeploymentTracing structured;
    final long inception = System.currentTimeMillis();

    public DeploymentTracing(StructuredDeploymentTracing structured) {
        this.structured = structured;
    }

    public void close() {
        this.structured.close();
    }

    public long elapsed() {
        return System.currentTimeMillis() - this.inception;
    }

    public void addMark(Mark mark) {
        this.structured.addApplicationMark(mark);
    }

    public void addContainerMark(ContainerMark mark, String name) {
        this.structured.addContainerMark(name, mark);
    }

    public void addModuleMark(ModuleMark mark, String moduleName) {
        this.structured.addModuleMark(moduleName, mark);
    }

    public void print(PrintStream ps) {
        this.structured.print(ps);
    }

    public static void printModuleStatus(ModulesRegistry registry, Level level, Logger logger) {
        if (!logger.isLoggable(level)) {
            return;
        }
        int counter = 0;
        StringBuilder sb = new StringBuilder("Module Status Report Begins\n");
        for (HK2Module m : registry.getModules()) {
            if (m.getState() != ModuleState.READY) continue;
            sb.append(m).append("\n");
            ++counter;
        }
        sb.append("there were ").append(counter).append(" modules in ACTIVE state");
        sb.append("\n");
        counter = 0;
        for (HK2Module m : registry.getModules()) {
            if (m.getState() != ModuleState.RESOLVED) continue;
            sb.append(m).append("\n");
            ++counter;
        }
        sb.append("there were ").append(counter).append(" modules in RESOLVED state");
        sb.append("\n");
        counter = 0;
        for (HK2Module m : registry.getModules()) {
            if (m.getState() == ModuleState.READY || m.getState() == ModuleState.RESOLVED) continue;
            sb.append(m).append("\n");
            ++counter;
        }
        sb.append("there were ").append(counter).append(" modules in INSTALLED state");
        sb.append("Module Status Report Ends");
        logger.log(level, sb.toString());
    }

    public static enum ContainerMark {
        SNIFFER_DONE,
        BEFORE_CONTAINER_SETUP,
        AFTER_CONTAINER_SETUP,
        GOT_CONTAINER,
        GOT_DEPLOYER,
        PREPARE,
        PREPARED,
        LOAD,
        LOADED,
        START,
        STARTED;

    }

    public static enum ModuleMark {
        PREPARE,
        PREPARE_EVENTS,
        PREPARED,
        LOAD,
        LOADED,
        START,
        STARTED;

    }

    public static enum AppStage {
        OPENING_ARCHIVE,
        TRANSFORM_ARCHIVE,
        VALIDATE_TARGET,
        CREATE_DEPLOYMENT_CONTEXT,
        PROCESS_EVENTS,
        DETERMINE_APP_NAME,
        CLEANUP,
        SWITCH_VERSIONS,
        PREPARE,
        INITIALIZE,
        START,
        REGISTRATION,
        CLASS_SCANNING,
        CONTAINER_START,
        CREATE_CLASSLOADER,
        LOAD,
        RELOAD;

    }

    public static enum Mark {
        ARCHIVE_OPENED,
        ARCHIVE_HANDLER_OBTAINED,
        INITIAL_CONTEXT_CREATED,
        APPINFO_PROVIDED,
        DOL_LOADED,
        APPNAME_DETERMINED,
        TARGET_VALIDATED,
        CONTEXT_CREATED,
        DEPLOY,
        CLASS_LOADER_HIERARCHY,
        PARSING_DONE,
        CLASS_LOADER_CREATED,
        CONTAINERS_SETUP_DONE,
        PREPARE,
        PREPARED,
        LOAD,
        LOAD_EVENTS,
        LOADED,
        START,
        START_EVENTS,
        STARTED,
        REGISTRATION;

    }
}

