/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.faces.integration;

import com.sun.enterprise.module.HK2Module;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.util.net.JarURIPattern;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.glassfish.api.web.TldProvider;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.web.loader.LogFacade;
import org.jvnet.hk2.annotations.Service;

@Service(name="jsfTld")
@Singleton
public class GlassFishTldProvider
implements TldProvider,
PostConstruct {
    private static final Logger logger = LogFacade.getLogger();
    private static final ResourceBundle rb = logger.getResourceBundle();
    @Inject
    ModulesRegistry registry;
    private Map<URI, List<String>> tldMap = new HashMap<URI, List<String>>();
    private Map<URI, List<String>> tldListenerMap = null;

    public String getName() {
        return "jsfTld";
    }

    public Map<URI, List<String>> getTldMap() {
        return (Map)((HashMap)this.tldMap).clone();
    }

    public synchronized Map<URI, List<String>> getTldListenerMap() {
        if (this.tldListenerMap == null) {
            this.tldListenerMap = new HashMap<URI, List<String>>();
            for (Map.Entry<URI, List<String>> entry : this.tldMap.entrySet()) {
                URI uri = entry.getKey();
                if (!entry.getValue().contains("META-INF/jsf_core.tld")) continue;
                this.tldListenerMap.put(uri, entry.getValue());
                break;
            }
            this.tldListenerMap = Collections.unmodifiableMap(this.tldListenerMap);
        }
        return this.tldListenerMap;
    }

    public void postConstruct() {
        Class<?> jsfImplClass = null;
        try {
            jsfImplClass = this.getClass().getClassLoader().loadClass("com.sun.faces.spi.InjectionProvider");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        URI[] uris = null;
        HK2Module m = null;
        if (jsfImplClass != null) {
            m = this.registry.find(jsfImplClass);
        }
        if (m != null) {
            uris = m.getModuleDefinition().getLocations();
        } else {
            ClassLoader classLoader = this.getClass().getClassLoader();
            if (classLoader instanceof URLClassLoader) {
                URL[] urls = ((URLClassLoader)classLoader).getURLs();
                if (urls != null && urls.length > 0) {
                    uris = new URI[urls.length];
                    for (int i = 0; i < urls.length; ++i) {
                        try {
                            uris[i] = urls[i].toURI();
                            continue;
                        }
                        catch (URISyntaxException e) {
                            String msg = rb.getString("AS-WEB-UTIL-00038");
                            msg = MessageFormat.format(msg, urls[i]);
                            logger.log(Level.WARNING, msg, e);
                        }
                    }
                }
            } else {
                logger.log(Level.WARNING, "AS-WEB-UTIL-00039", new Object[]{"JSF", classLoader, GlassFishTldProvider.class.getName()});
            }
        }
        if (uris != null && uris.length > 0) {
            Pattern pattern = Pattern.compile("META-INF/.*\\.tld");
            for (URI uri : uris) {
                List entries = JarURIPattern.getJarEntries((URI)uri, (Pattern)pattern);
                if (entries == null || entries.size() <= 0) continue;
                this.tldMap.put(uri, entries);
            }
        }
    }
}

