/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.threadpool;

import com.sun.corba.ee.impl.threadpool.AbstractThreadPool;
import com.sun.corba.ee.impl.threadpool.ThreadPoolImpl;
import com.sun.corba.ee.spi.threadpool.ThreadPool;
import com.sun.corba.ee.spi.threadpool.Work;
import com.sun.corba.ee.spi.threadpool.WorkQueue;
import org.glassfish.gmbal.NameValue;

public class WorkQueueImpl
implements WorkQueue {
    private final String name;
    private AbstractThreadPool threadPool;
    private long workItemsAdded = 0L;
    private long workItemsDequeued = 0L;
    private long totalTimeInQueue = 0L;
    public static final String WORKQUEUE_DEFAULT_NAME = "default-workqueue";
    private static final long serialVersionUID = 1L;

    public WorkQueueImpl() {
        this(new ThreadPoolImpl(WORKQUEUE_DEFAULT_NAME), WORKQUEUE_DEFAULT_NAME);
    }

    public WorkQueueImpl(ThreadPool workerThreadPool) {
        this(workerThreadPool, WORKQUEUE_DEFAULT_NAME);
    }

    public WorkQueueImpl(ThreadPool workerThreadPool, String name) {
        this.threadPool = (AbstractThreadPool)workerThreadPool;
        this.name = name;
    }

    @Override
    public void addWork(Work aWorkItem) {
        this.addWork(aWorkItem, false);
    }

    @Override
    public void addWork(Work aWorkItem, boolean isLongRunning) {
        if (!isLongRunning) {
            ++this.workItemsAdded;
            aWorkItem.setEnqueueTime(System.currentTimeMillis());
        }
        this.threadPool.submit(aWorkItem, isLongRunning);
    }

    @Override
    @NameValue
    public String getName() {
        return this.name;
    }

    @Override
    public long totalWorkItemsAdded() {
        return this.workItemsAdded;
    }

    @Override
    public int workItemsInQueue() {
        return this.threadPool.getQueue().size();
    }

    @Override
    public long averageTimeInQueue() {
        if (this.workItemsDequeued == 0L) {
            return 0L;
        }
        return this.totalTimeInQueue / this.workItemsDequeued;
    }

    void incrDequeue(Work work) {
        ++this.workItemsDequeued;
        this.totalTimeInQueue += System.currentTimeMillis() - work.getEnqueueTime();
    }

    @Override
    public void setThreadPool(ThreadPool aThreadPool) {
        this.threadPool = (AbstractThreadPool)aThreadPool;
    }

    @Override
    public ThreadPool getThreadPool() {
        return this.threadPool;
    }
}

