/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.ejb.ejbc;

import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.jdo.api.persistence.mapping.ejb.AbstractNameMapper;
import com.sun.jdo.api.persistence.mapping.ejb.ConversionException;
import com.sun.jdo.api.persistence.mapping.ejb.EJBInfoHelper;
import com.sun.jdo.api.persistence.mapping.ejb.MappingFile;
import com.sun.jdo.api.persistence.mapping.ejb.beans.CmpFieldMapping;
import com.sun.jdo.api.persistence.mapping.ejb.beans.CmrFieldMapping;
import com.sun.jdo.api.persistence.mapping.ejb.beans.ColumnPair;
import com.sun.jdo.api.persistence.mapping.ejb.beans.EntityMapping;
import com.sun.jdo.api.persistence.mapping.ejb.beans.SunCmpMapping;
import com.sun.jdo.api.persistence.mapping.ejb.beans.SunCmpMappings;
import com.sun.jdo.api.persistence.model.Model;
import com.sun.jdo.api.persistence.model.ModelException;
import com.sun.jdo.api.persistence.model.mapping.MappingClassElement;
import com.sun.jdo.spi.persistence.generator.database.DatabaseGenerator;
import com.sun.jdo.spi.persistence.support.ejb.codegen.GeneratorException;
import com.sun.jdo.spi.persistence.support.ejb.ejbc.EJBBundleInfoHelper;
import com.sun.jdo.spi.persistence.support.ejb.ejbc.JDOCodeGeneratorHelper;
import com.sun.jdo.spi.persistence.support.ejb.ejbc.LogHelperEJBCompiler;
import com.sun.jdo.spi.persistence.support.ejb.ejbc.NameMapper;
import com.sun.jdo.spi.persistence.support.sqlstore.ejb.DeploymentHelper;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import org.glassfish.api.ActionReport;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.common.util.StringHelper;
import org.glassfish.ejb.deployment.descriptor.EjbBundleDescriptorImpl;
import org.glassfish.persistence.common.I18NHelper;
import org.glassfish.persistence.common.Java2DBProcessorHelper;
import org.glassfish.persistence.common.database.DBVendorTypeHelper;
import org.netbeans.modules.dbschema.DBException;
import org.netbeans.modules.dbschema.DBIdentifier;
import org.netbeans.modules.dbschema.SchemaElement;
import org.netbeans.modules.dbschema.jdbcimpl.ConnectionProvider;
import org.netbeans.modules.dbschema.jdbcimpl.SchemaElementImpl;
import org.netbeans.modules.dbschema.util.NameUtil;
import org.netbeans.modules.schema2beans.Schema2BeansException;
import org.netbeans.modules.schema2beans.ValidateException;

public class MappingGenerator
extends com.sun.jdo.api.persistence.mapping.ejb.MappingGenerator {
    public static final String JAVA_TO_DB_FLAG = "java-to-database";
    private static final String DBSCHEMA_EXTENSION = ".dbschema";
    private static final char DOT = '.';
    private static final Logger logger = LogHelperEJBCompiler.getLogger();
    private final EjbBundleDescriptorImpl bundle;
    private String dbVendorName = null;
    private boolean isJavaToDatabaseFlag = false;
    private boolean isVerifyFlag = false;
    private static final ResourceBundle messages = I18NHelper.loadBundle(MappingGenerator.class);

    public MappingGenerator(EjbBundleDescriptorImpl bundle, Model model, NameMapper nameMapper, ClassLoader loader) {
        super((EJBInfoHelper)new EJBBundleInfoHelper(bundle, nameMapper, model, null), loader, false);
        this.bundle = bundle;
    }

    public SchemaElement generateMapping(DeploymentContext ctx, String inputFilesPath, String generatedXmlsPath, File classout, boolean ignoreSunDeploymentDescriptors) throws IOException, DBException, ModelException, Schema2BeansException, SQLException, GeneratorException, ConversionException {
        SchemaElement schema = null;
        if (ctx == null) {
            this.isVerifyFlag = true;
        }
        File cmpMappingFile = MappingGenerator.getSunCmpMappingFile(inputFilesPath);
        boolean mappedBeans = !ignoreSunDeploymentDescriptors && cmpMappingFile.exists();
        ResourceReferenceDescriptor cmpResource = this.checkOrCreateCMPResource(mappedBeans);
        this.isJavaToDatabaseFlag = DeploymentHelper.isJavaToDatabase(cmpResource.getSchemaGeneratorProperties());
        boolean mustHaveDBVendorName = !mappedBeans || mappedBeans && this.isJavaToDatabaseFlag;
        Results deploymentArguments = this.getDeploymentArguments(ctx, cmpResource, mustHaveDBVendorName);
        this.dbVendorName = deploymentArguments.getDatabaseVendorName();
        if (mappedBeans) {
            if (!this.isVerifyFlag) {
                String warning = null;
                if (this.isJavaToDatabaseFlag) {
                    if (deploymentArguments.hasUniqueTableNames()) {
                        warning = I18NHelper.getMessage((ResourceBundle)messages, (String)"EXC_DisallowJava2DBUniqueTableNames", (String)this.bundle.getApplication().getRegistrationName(), (String)JDOCodeGeneratorHelper.getModuleName((EjbBundleDescriptor)this.bundle));
                        logger.warning(warning);
                    }
                } else if (deploymentArguments.hasJavaToDatabaseArgs()) {
                    warning = I18NHelper.getMessage((ResourceBundle)messages, (String)"EXC_DisallowJava2DBCLIOverrides", (String)this.bundle.getApplication().getRegistrationName(), (String)JDOCodeGeneratorHelper.getModuleName((EjbBundleDescriptor)this.bundle));
                    logger.warning(warning);
                }
                if (warning != null) {
                    ActionReport subActionReport = ctx.getActionReport().addSubActionsReport();
                    Java2DBProcessorHelper.warnUser((ActionReport)subActionReport, warning);
                }
            }
            SunCmpMappings sunCmpMappings = this.getSunCmpMappings(cmpMappingFile);
            this.ensureDBSchemaExistence(cmpResource, sunCmpMappings, inputFilesPath, classout);
            Map mappingClasses = this.loadMappingClasses(sunCmpMappings, this.getClassLoader());
            MappingClassElement mc2 = null;
            for (MappingClassElement mc2 : mappingClasses.values()) {
                if (mc2 == null) continue;
                schema = SchemaElement.forName((String)mc2.getDatabaseRoot());
                break;
            }
            if (logger.isLoggable(500)) {
                logger.fine("Loaded mapped beans for " + cmpResource.getJndiName() + ", isJavaToDatabase=" + this.isJavaToDatabaseFlag);
            }
        } else {
            DatabaseGenerator.Results results = this.generateMappingClasses(this.dbVendorName, deploymentArguments.getUseUniqueTableNames(), deploymentArguments.getUserPolicy(), inputFilesPath);
            if (!this.isVerifyFlag) {
                this.writeSunCmpMappingFile(results.getMappingClasses(), MappingGenerator.getSunCmpMappingFile(generatedXmlsPath));
                schema = results.getSchema();
                MappingGenerator.writeSchemaFile(schema, classout);
                this.setJavaToDatabase(cmpResource, true);
            }
        }
        return schema;
    }

    public String getDatabaseVendorName() {
        return this.dbVendorName;
    }

    public boolean isJavaToDatabase() {
        return this.isJavaToDatabaseFlag;
    }

    private void setJavaToDatabase(ResourceReferenceDescriptor cmpResource, boolean value) {
        Properties schemaGeneratorProperties;
        if (logger.isLoggable(500)) {
            logger.fine("set javatodb flag to " + value + " in cmpResource");
        }
        if ((schemaGeneratorProperties = cmpResource.getSchemaGeneratorProperties()) == null) {
            schemaGeneratorProperties = new Properties();
            cmpResource.setSchemaGeneratorProperties(schemaGeneratorProperties);
        }
        schemaGeneratorProperties.setProperty(JAVA_TO_DB_FLAG, String.valueOf(value));
        this.isJavaToDatabaseFlag = value;
    }

    private SunCmpMappings getSunCmpMappings(File cmpMappingFile) throws IOException, Schema2BeansException, GeneratorException {
        FileInputStream is = null;
        BufferedInputStream iasMapping = null;
        SunCmpMappings sunCmpMapping = null;
        if (cmpMappingFile.length() == 0L) {
            throw JDOCodeGeneratorHelper.createGeneratorException("CMG.BeansFileSizeIsZero", (EjbBundleDescriptor)this.bundle);
        }
        try {
            is = new FileInputStream(cmpMappingFile);
            iasMapping = new BufferedInputStream(is);
            sunCmpMapping = SunCmpMappings.createGraph((InputStream)iasMapping);
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            block20: {
                block19: {
                    if (is != null) {
                        try {
                            ((InputStream)is).close();
                        }
                        catch (Exception ex) {
                            if (!logger.isLoggable(500)) break block19;
                            logger.fine(ex.toString());
                        }
                    }
                }
                if (iasMapping != null) {
                    try {
                        iasMapping.close();
                    }
                    catch (Exception ex) {
                        if (!logger.isLoggable(500)) break block20;
                        logger.fine(ex.toString());
                    }
                }
            }
        }
        try {
            sunCmpMapping.validate();
        }
        catch (ValidateException ex) {
            throw JDOCodeGeneratorHelper.createGeneratorException("CMG.InvalidSunCmpMappingsFile", (EjbBundleDescriptor)this.bundle, (Exception)((Object)ex));
        }
        return sunCmpMapping;
    }

    private static File getSunCmpMappingFile(String filesPath) {
        String dirs;
        File fileDirs;
        String cmpMappingFile = filesPath + File.separator + MappingFile.DEFAULT_LOCATION_IN_EJB_JAR;
        if (cmpMappingFile.lastIndexOf(File.separatorChar) != -1 && !(fileDirs = new File(dirs = cmpMappingFile.substring(0, cmpMappingFile.lastIndexOf(File.separatorChar)))).exists()) {
            fileDirs.mkdirs();
        }
        return new File(cmpMappingFile);
    }

    private void writeSunCmpMappingFile(Set mappingClasses, File cmpMappingFile) throws IOException, ConversionException, Schema2BeansException {
        HashMap<String, MappingClassElement> mappingMap = new HashMap<String, MappingClassElement>();
        AbstractNameMapper nameMapper = this.getNameMapper();
        for (MappingClassElement mappingClass : mappingClasses) {
            String ejbName = nameMapper.getEjbNameForPersistenceClass(mappingClass.getName());
            mappingMap.put(ejbName, mappingClass);
        }
        MappingFile mf = new MappingFile();
        FileOutputStream sunCmpMapping = null;
        try {
            sunCmpMapping = new FileOutputStream(cmpMappingFile);
            mf.fromMappingClasses((OutputStream)sunCmpMapping, mappingMap, this.getConversionHelper());
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            block12: {
                try {
                    if (sunCmpMapping != null) {
                        ((OutputStream)sunCmpMapping).close();
                    }
                }
                catch (IOException ex) {
                    if (!logger.isLoggable(500)) break block12;
                    logger.fine(ex.toString());
                }
            }
        }
    }

    private static void writeSchemaFile(SchemaElement schema, File filePath) throws IOException {
        OutputStream schemaStream = null;
        try {
            schemaStream = new FileOutputStream(new File(filePath, NameUtil.getSchemaResourceName((String)schema.getName().getName())));
            schema.save(schemaStream);
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            block11: {
                try {
                    if (schemaStream != null) {
                        schemaStream.close();
                    }
                }
                catch (IOException ex) {
                    if (!logger.isLoggable(500)) break block11;
                    logger.fine(ex.toString());
                }
            }
        }
    }

    private Results getDeploymentArguments(DeploymentContext ctx, ResourceReferenceDescriptor cmpResource, boolean connectToDatabase) {
        Boolean useUniqueTableNames = null;
        String dbVendorName = null;
        Properties userPolicy = null;
        boolean javaToDatabaseArgs = false;
        if (null == ctx) {
            dbVendorName = cmpResource.getDatabaseVendorName();
        } else {
            Boolean createTables;
            DeployCommandParameters cliOverrides = (DeployCommandParameters)ctx.getCommandParameters(DeployCommandParameters.class);
            useUniqueTableNames = cliOverrides.uniquetablenames;
            javaToDatabaseArgs = useUniqueTableNames != null;
            dbVendorName = cliOverrides.dbvendorname;
            javaToDatabaseArgs |= this.isPropertyDefined(dbVendorName);
            if (null == dbVendorName) {
                dbVendorName = cmpResource.getDatabaseVendorName();
            }
            if (null == dbVendorName && connectToDatabase) {
                try {
                    Connection conn = DeploymentHelper.getConnection(cmpResource.getJndiName());
                    dbVendorName = conn.getMetaData().getDatabaseProductName();
                }
                catch (Exception conn) {
                    // empty catch block
                }
            }
            javaToDatabaseArgs |= (createTables = cliOverrides.createtables) != null;
            Boolean dropAndCreateTables = cliOverrides.dropandcreatetables;
            javaToDatabaseArgs |= dropAndCreateTables != null;
        }
        dbVendorName = null == dbVendorName ? DBVendorTypeHelper.DEFAULT_DB : DBVendorTypeHelper.getDBType((String)dbVendorName);
        userPolicy = cmpResource.getSchemaGeneratorProperties();
        return new Results(useUniqueTableNames, dbVendorName, userPolicy, javaToDatabaseArgs);
    }

    private ResourceReferenceDescriptor checkOrCreateCMPResource(boolean mappedBeans) throws GeneratorException {
        ResourceReferenceDescriptor cmpResource = this.bundle.getCMPResourceReference();
        if (mappedBeans) {
            if (cmpResource == null) {
                throw JDOCodeGeneratorHelper.createGeneratorException("EXC_MissingCMPResource", (EjbBundleDescriptor)this.bundle);
            }
        } else if (cmpResource == null) {
            cmpResource = new ResourceReferenceDescriptor();
            cmpResource.setJndiName("jdbc/__default");
            cmpResource.setDatabaseVendorName(DBVendorTypeHelper.H2);
            cmpResource.setCreateTablesAtDeploy(true);
            cmpResource.setDropTablesAtUndeploy(true);
            this.bundle.setCMPResourceReference(cmpResource);
        }
        return cmpResource;
    }

    private void ensureDBSchemaExistence(ResourceReferenceDescriptor cmpResource, SunCmpMappings sunCmpMappings, String inputFilesPath, File classout) throws DBException, SQLException, GeneratorException {
        String generatedSchemaName = this.getInfoHelper().getSchemaNameToGenerate();
        HashSet tables = new HashSet();
        int size = sunCmpMappings.sizeSunCmpMapping();
        for (int i = 0; i < size; ++i) {
            SunCmpMapping sunCmpMapping = sunCmpMappings.getSunCmpMapping(i);
            String schemaName = sunCmpMapping.getSchema();
            if (StringHelper.isEmpty((String)schemaName)) {
                if (!this.isVerifyFlag) {
                    this.addAllTables(sunCmpMapping, tables);
                    sunCmpMapping.setSchema(generatedSchemaName);
                    continue;
                }
                this.getConversionHelper().setEnsureValidation(false);
                continue;
            }
            File dbschemaFile = new File(inputFilesPath + File.separator + schemaName + DBSCHEMA_EXTENSION);
            if (dbschemaFile.exists() && dbschemaFile.isFile() && dbschemaFile.canRead()) continue;
            throw new GeneratorException(I18NHelper.getMessage((ResourceBundle)messages, (String)"CMG.MissingDBSchema", (String)this.bundle.getApplication().getRegistrationName(), (String)JDOCodeGeneratorHelper.getModuleName((EjbBundleDescriptor)this.bundle), (String)schemaName));
        }
        if (tables.size() > 0) {
            String userSchema = null;
            Connection con = DeploymentHelper.getConnection(cmpResource.getJndiName());
            DatabaseMetaData dmd = con.getMetaData();
            if (DBVendorTypeHelper.requireUpperCaseSchema((DatabaseMetaData)dmd)) {
                userSchema = dmd.getUserName().trim().toUpperCase();
            }
            ConnectionProvider cp = new ConnectionProvider(con, dmd.getDriverName().trim());
            if (userSchema != null) {
                cp.setSchema(userSchema);
            }
            OutputStream outstream = null;
            try {
                SchemaElementImpl outSchemaImpl = new SchemaElementImpl(cp);
                SchemaElement schemaElement = new SchemaElement((SchemaElement.Impl)outSchemaImpl);
                schemaElement.setName(DBIdentifier.create((String)generatedSchemaName));
                if (dmd.getDatabaseProductName().compareToIgnoreCase("MYSQL") == 0) {
                    outSchemaImpl.initTables(cp, new LinkedList(tables), new LinkedList(), true);
                } else {
                    outSchemaImpl.initTables(cp, new LinkedList(tables), new LinkedList(), false);
                }
                outstream = new FileOutputStream(new File(classout, generatedSchemaName + DBSCHEMA_EXTENSION));
                schemaElement.save(outstream);
            }
            catch (IOException ex) {
                throw JDOCodeGeneratorHelper.createGeneratorException("CMG.CannotSaveDBSchema", (EjbBundleDescriptor)this.bundle, ex);
            }
            finally {
                block19: {
                    cp.closeConnection();
                    try {
                        if (outstream != null) {
                            outstream.close();
                        }
                    }
                    catch (IOException ex) {
                        if (!logger.isLoggable(500)) break block19;
                        logger.fine(ex.toString());
                    }
                }
            }
        }
    }

    private void addAllTables(SunCmpMapping sunCmpMapping, Set tables) {
        EntityMapping[] beans = sunCmpMapping.getEntityMapping();
        for (int i = 0; i < beans.length; ++i) {
            this.addTableName(beans[i].getTableName(), tables);
            CmpFieldMapping[] cmpfields = beans[i].getCmpFieldMapping();
            for (int j = 0; j < cmpfields.length; ++j) {
                String[] names = cmpfields[j].getColumnName();
                for (int jj = 0; jj < names.length; ++jj) {
                    this.addRelatedTableName(names[jj], tables);
                }
            }
            CmrFieldMapping[] cmrfields = beans[i].getCmrFieldMapping();
            for (int j = 0; j < cmrfields.length; ++j) {
                ColumnPair[] pairs = cmrfields[j].getColumnPair();
                for (int jj = 0; jj < pairs.length; ++jj) {
                    String[] names = pairs[jj].getColumnName();
                    for (int jjj = 0; jjj < names.length; ++jjj) {
                        this.addRelatedTableName(names[jjj], tables);
                    }
                }
            }
        }
    }

    private void addTableName(String name, Set tables) {
        if (!StringHelper.isEmpty((String)name)) {
            if (logger.isLoggable(500)) {
                logger.fine("Adding Table to Capture Set: " + name);
            }
            tables.add(name);
        }
    }

    private void addRelatedTableName(String columnName, Set tables) {
        int l;
        if (!StringHelper.isEmpty((String)columnName) && (l = columnName.indexOf(46)) > 0) {
            this.addTableName(columnName.substring(0, l), tables);
        }
    }

    private class Results {
        private final Boolean useUniqueTableNames;
        private final String dbVendorName;
        private final Properties userPolicy;
        private final boolean javaToDatabaseArgs;

        Results(Boolean useUniqueTableNames, String dbVendorName, Properties userPolicy, boolean javaToDatabaseArgs) {
            this.useUniqueTableNames = useUniqueTableNames;
            this.dbVendorName = dbVendorName;
            this.userPolicy = userPolicy;
            this.javaToDatabaseArgs = javaToDatabaseArgs;
        }

        public Boolean getUseUniqueTableNames() {
            return this.useUniqueTableNames;
        }

        public boolean hasUniqueTableNames() {
            return this.useUniqueTableNames != null;
        }

        public boolean hasJavaToDatabaseArgs() {
            return this.javaToDatabaseArgs;
        }

        public String getDatabaseVendorName() {
            return this.dbVendorName;
        }

        public Properties getUserPolicy() {
            return this.userPolicy;
        }
    }
}

