/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gjc.util;

import com.sun.gjc.util.SQLTrace;
import com.sun.gjc.util.SQLTraceTimerTask;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class SQLTraceCache {
    protected int numTopQueriesToReport = 10;
    protected long timeToKeepQueries = 60000L;
    protected final String poolName;
    protected ConcurrentSkipListMap<String, SQLTrace> cache = new ConcurrentSkipListMap();
    private SQLTraceTimerTask sqlTraceTimerTask;
    protected static final Logger _logger = LogDomains.getLogger(SQLTraceCache.class, (String)"javax.enterprise.resource.resourceadapter");
    protected static final String LINE_BREAK = "%%%EOL%%%";

    public SQLTraceCache(String poolName, int maxSize, long timeToKeepQueries) {
        this.poolName = poolName;
        this.numTopQueriesToReport = maxSize;
        this.timeToKeepQueries = timeToKeepQueries * 60L * 1000L;
    }

    public Collection<String> getSqlTraceList() {
        return this.cache.keySet();
    }

    public String getPoolName() {
        return this.poolName;
    }

    public void scheduleTimerTask(Timer timer) {
        if (this.sqlTraceTimerTask != null) {
            this.sqlTraceTimerTask.cancel();
            this.sqlTraceTimerTask = null;
        }
        this.sqlTraceTimerTask = this.initializeTimerTask();
        if (timer != null && this.timeToKeepQueries > 0L) {
            timer.scheduleAtFixedRate((TimerTask)this.sqlTraceTimerTask, this.timeToKeepQueries, this.timeToKeepQueries);
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("Scheduled Sql Trace Caching timer task");
        }
    }

    public synchronized void cancelTimerTask() {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("Cancelling Sql Trace Caching timer task");
        }
        if (this.sqlTraceTimerTask != null) {
            this.sqlTraceTimerTask.cancel();
        }
        this.sqlTraceTimerTask = null;
    }

    private SQLTraceTimerTask initializeTimerTask() {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("Initializing Sql Trace Caching timer task");
        }
        return new SQLTraceTimerTask(this);
    }

    public abstract void checkAndUpdateCache(SQLTrace var1);

    public void purgeEntries() {
        ArrayList<SQLTrace> sqlTraceList = new ArrayList<SQLTrace>(this.cache.values());
        Collections.sort(sqlTraceList, SQLTrace.SQLTraceFrequencyComparator);
        for (int elementCount = sqlTraceList.size(); elementCount > this.numTopQueriesToReport; --elementCount) {
            SQLTrace sqlTrace = (SQLTrace)sqlTraceList.get(elementCount - 1);
            this.cache.remove(sqlTrace.getQueryName());
            sqlTraceList.remove(sqlTrace);
        }
    }
}

