/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.microprofile.config.source.extension;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.util.ColumnFormatter;
import fish.payara.internal.notification.NotifierUtils;
import fish.payara.nucleus.microprofile.config.source.extension.ConfigSourceExtensions;
import fish.payara.nucleus.microprofile.config.spi.ConfigSourceConfiguration;
import fish.payara.nucleus.microprofile.config.spi.MicroprofileConfigConfiguration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Target;

public abstract class BaseGetConfigSourceConfigurationCommand<C extends ConfigSourceConfiguration>
implements AdminCommand {
    @Inject
    private Target targetUtil;
    @Inject
    protected ServiceLocator habitat;
    @Param(name="target", optional=true, defaultValue="server")
    private String target;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Config targetConfig = this.targetUtil.getConfig(this.target);
        if (targetConfig == null) {
            report.setMessage("No such config named: " + this.target);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        Properties extraProperties = report.getExtraProperties();
        if (extraProperties == null) {
            extraProperties = new Properties();
            report.setExtraProperties(extraProperties);
        }
        MicroprofileConfigConfiguration mpConfigConfiguration = (MicroprofileConfigConfiguration)targetConfig.getExtensionByType(MicroprofileConfigConfiguration.class);
        Class configSourceConfigurationClass = ConfigSourceExtensions.getConfigurationClass(this.getClass());
        Object c = mpConfigConfiguration.getConfigSourceConfigurationByType(configSourceConfigurationClass);
        Properties extraProps = new Properties();
        extraProps.put("configSourceConfiguration", this.getConfigSourceProperties(c));
        if (c == null) {
            report.setMessage("ConfigSource Configuration is not defined");
        } else {
            report.setMessage(this.listConfiguration(c));
        }
        report.setExtraProperties(extraProps);
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    protected String listConfiguration(C configuration) {
        Map<String, Object> configMap = this.getConfigSourceConfiguration(configuration);
        Iterator<Map.Entry<String, Object>> configIterator = configMap.entrySet().iterator();
        ArrayList<String> headers = new ArrayList<String>(2);
        ArrayList<Object> values = new ArrayList<Object>(2);
        while (configIterator.hasNext()) {
            Map.Entry<String, Object> entry = configIterator.next();
            headers.add(entry.getKey());
            values.add(entry.getValue());
        }
        ColumnFormatter columnFormatter = new ColumnFormatter(headers.toArray(new String[0]));
        columnFormatter.addRow(values.toArray());
        return columnFormatter.toString();
    }

    protected Map<String, Object> getConfigSourceConfiguration(C configuration) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(2);
        if (configuration != null) {
            map.put("Enabled", configuration.getEnabled());
        } else {
            map.put("Enabled", Boolean.FALSE.toString());
        }
        return map;
    }

    protected Map<String, Object> getConfigSourceProperties(C configuration) {
        Map<String, Object> configMap = this.getConfigSourceConfiguration(configuration);
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(2);
        for (Map.Entry<String, Object> entry : configMap.entrySet()) {
            result.put(NotifierUtils.convertToCamelCase((String)entry.getKey()), entry.getValue());
        }
        return result;
    }
}

