/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.healthcheck.admin;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.util.ColumnFormatter;
import fish.payara.microprofile.healthcheck.config.MicroprofileHealthCheckConfiguration;
import java.util.HashMap;
import java.util.Properties;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;

@Service(name="get-microprofile-healthcheck-configuration")
@PerLookup
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG, CommandTarget.DEPLOYMENT_GROUP})
@RestEndpoints(value={@RestEndpoint(configBean=MicroprofileHealthCheckConfiguration.class, opType=RestEndpoint.OpType.GET, path="get-microprofile-healthcheck-configuration", description="Gets the Microprofile Health Check Configuration")})
public class GetMPHealthCheckConfiguration
implements AdminCommand {
    private final String[] OUTPUT_HEADERS = new String[]{"Enabled", "EndPoint", "VirtualServers", "Security Enabled", "Roles"};
    @Inject
    private Target targetUtil;
    @Param(optional=true, defaultValue="server-config")
    private String target;

    public void execute(AdminCommandContext context) {
        Config targetConfig = this.targetUtil.getConfig(this.target);
        if (targetConfig == null) {
            context.getActionReport().setMessage("No such config name: " + this.targetUtil);
            context.getActionReport().setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        MicroprofileHealthCheckConfiguration healthCheckConfiguration = (MicroprofileHealthCheckConfiguration)targetConfig.getExtensionByType(MicroprofileHealthCheckConfiguration.class);
        ColumnFormatter columnFormatter = new ColumnFormatter(this.OUTPUT_HEADERS);
        Object[] outputValues = new Object[]{healthCheckConfiguration.getEnabled(), healthCheckConfiguration.getEndpoint(), healthCheckConfiguration.getVirtualServers(), healthCheckConfiguration.getSecurityEnabled(), healthCheckConfiguration.getRoles()};
        columnFormatter.addRow(outputValues);
        context.getActionReport().appendMessage(columnFormatter.toString());
        HashMap<String, String> extraPropertiesMap = new HashMap<String, String>();
        extraPropertiesMap.put("enabled", healthCheckConfiguration.getEnabled());
        extraPropertiesMap.put("endpoint", healthCheckConfiguration.getEndpoint());
        extraPropertiesMap.put("virtualServers", healthCheckConfiguration.getVirtualServers());
        extraPropertiesMap.put("securityenabled", healthCheckConfiguration.getSecurityEnabled());
        extraPropertiesMap.put("roles", healthCheckConfiguration.getRoles());
        Properties extraProperties = new Properties();
        extraProperties.put("microprofileHealthCheckConfiguration", extraPropertiesMap);
        context.getActionReport().setExtraProperties(extraProperties);
    }
}

