/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.healthcheck.response;

import fish.payara.microprofile.healthcheck.response.HealthCheckResponseImpl;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;
import org.glassfish.common.util.StringHelper;

public class HealthCheckResponseBuilderImpl
extends HealthCheckResponseBuilder {
    private String name;
    private HealthCheckResponse.Status status;
    private final Optional<Map<String, Object>> data = Optional.of(new HashMap());

    @Override
    public HealthCheckResponseBuilder name(String name) {
        if (!StringHelper.isEmpty((String)name)) {
            this.name = name;
            return this;
        }
        throw new IllegalArgumentException("Healthcheck name is null or empty");
    }

    @Override
    public HealthCheckResponseBuilder withData(String key, String value) {
        if (!StringHelper.isEmpty((String)key)) {
            this.data.get().put(key, value);
            return this;
        }
        throw new IllegalArgumentException("Healthcheck key is null or empty");
    }

    @Override
    public HealthCheckResponseBuilder withData(String key, long value) {
        if (!StringHelper.isEmpty((String)key)) {
            this.data.get().put(key, value);
            return this;
        }
        throw new IllegalArgumentException("Healthcheck key is null or empty");
    }

    @Override
    public HealthCheckResponseBuilder withData(String key, boolean value) {
        if (!StringHelper.isEmpty((String)key)) {
            this.data.get().put(key, value);
            return this;
        }
        throw new IllegalArgumentException("Healthcheck key is null or empty");
    }

    @Override
    public HealthCheckResponseBuilder up() {
        this.status = HealthCheckResponse.Status.UP;
        return this;
    }

    @Override
    public HealthCheckResponseBuilder down() {
        this.status = HealthCheckResponse.Status.DOWN;
        return this;
    }

    @Override
    public HealthCheckResponseBuilder status(boolean up) {
        this.status = up ? HealthCheckResponse.Status.UP : HealthCheckResponse.Status.DOWN;
        return this;
    }

    @Override
    public HealthCheckResponse build() {
        this.validate();
        HealthCheckResponseImpl healthCheckResponse = new HealthCheckResponseImpl(this.name, this.status, this.data);
        return healthCheckResponse;
    }

    private void validate() {
        if (StringHelper.isEmpty((String)this.name)) {
            throw new IllegalArgumentException("Healthcheck name is not defined");
        }
        if (this.status == null) {
            throw new IllegalArgumentException(String.format("Healthcheck [%s] status is not defined", this.name));
        }
    }
}

