/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.monitoring.internal.adapt;

import fish.payara.monitoring.adapt.GroupDataRepository;
import fish.payara.monitoring.adapt.MonitoringConsole;
import fish.payara.monitoring.adapt.MonitoringConsolePageConfig;
import fish.payara.monitoring.adapt.MonitoringConsoleRuntime;
import fish.payara.monitoring.alert.AlertService;
import fish.payara.monitoring.collect.MonitoringData;
import fish.payara.monitoring.collect.MonitoringDataCollector;
import fish.payara.monitoring.collect.MonitoringDataSource;
import fish.payara.monitoring.collect.MonitoringWatchSource;
import fish.payara.monitoring.data.SeriesRepository;
import fish.payara.monitoring.internal.alert.InMemoryAlarmService;
import fish.payara.monitoring.internal.data.InMemorySeriesRepository;
import fish.payara.monitoring.model.SeriesLookup;
import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MonitoringConsoleImpl
implements MonitoringConsole,
MonitoringDataSource {
    private static final Logger LOGGER = Logger.getLogger("monitoring-console-core");
    private static final String ALERT_COUNT = "AlertCount";
    private final boolean receiver;
    private final MonitoringConsoleRuntime runtime;
    private final InMemorySeriesRepository data;
    private final InMemoryAlarmService alerts;

    MonitoringConsoleImpl(String instance, boolean receiver, MonitoringConsoleRuntime runtime, Supplier<? extends List<MonitoringDataSource>> dataSources, Supplier<? extends List<MonitoringWatchSource>> watchSources) {
        this.receiver = receiver;
        this.runtime = runtime;
        Supplier<List> extendedDataSource = () -> {
            ArrayList<MonitoringConsoleImpl> extended = new ArrayList<MonitoringConsoleImpl>((Collection)dataSources.get());
            extended.add(this);
            return extended;
        };
        this.data = new InMemorySeriesRepository(instance, receiver, runtime, extendedDataSource);
        this.alerts = new InMemoryAlarmService(instance, receiver, runtime, watchSources, this.data);
        if (receiver) {
            runtime.receive(this::receiveMesssage);
        }
    }

    private void receiveMesssage(byte[] msg) {
        try (ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(msg));){
            Object message = ois.readObject();
            if (message instanceof InMemorySeriesRepository.SeriesDatasetsSnapshot) {
                this.data.addRemoteDatasets((InMemorySeriesRepository.SeriesDatasetsSnapshot)message);
            } else if (message instanceof InMemoryAlarmService.WatchesSnapshot) {
                this.alerts.addRemoteWatches((InMemoryAlarmService.WatchesSnapshot)message);
            } else {
                LOGGER.log(Level.FINE, "Received a message of unknown type: {0}", message.getClass());
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Failed to receive monitoring data message", ex);
        }
    }

    public void setEnabled(boolean enabled) {
        this.data.setEnabled(enabled);
        this.alerts.setEnabled(enabled);
    }

    public void setHistoryEnabled(boolean enabled) {
        this.data.setHistoryEnabled(enabled);
    }

    public <T> T getService(Class<T> type) throws NoSuchElementException {
        if (type == SeriesLookup.class || type == SeriesRepository.class) {
            return (T)this.data;
        }
        if (type == AlertService.class) {
            return (T)this.alerts;
        }
        if (type == GroupDataRepository.class) {
            return (T)this.runtime.getGroupData();
        }
        if (type == MonitoringConsolePageConfig.class) {
            return (T)this.runtime.getPageConfig();
        }
        throw new NoSuchElementException("Unknown service: " + type.getName());
    }

    @MonitoringData(ns="monitoring")
    public void collect(MonitoringDataCollector collector) {
        if (this.receiver) {
            collector.collect((CharSequence)"WatchLoopDuration", this.alerts.getEvaluationLoopTime());
            AlertService.AlertStatistics stats = this.alerts.getAlertStatistics();
            if (stats != null) {
                collector.group((CharSequence)"Red").collect((CharSequence)ALERT_COUNT, (long)stats.unacknowledgedRedAlerts);
                collector.group((CharSequence)"RedAck").collect((CharSequence)ALERT_COUNT, (long)stats.acknowledgedRedAlerts);
                collector.group((CharSequence)"Amber").collect((CharSequence)ALERT_COUNT, (long)stats.unacknowledgedAmberAlerts);
                collector.group((CharSequence)"AmberAck").collect((CharSequence)ALERT_COUNT, (long)stats.acknowledgedAmberAlerts);
            }
        }
    }
}

