/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.login;

import com.sun.enterprise.security.SecurityLoggerInfo;
import com.sun.enterprise.security.SecurityServicesUtil;
import com.sun.enterprise.security.audit.AuditManager;
import com.sun.enterprise.security.auth.login.common.LoginException;
import com.sun.enterprise.security.auth.login.common.PasswordCredential;
import com.sun.enterprise.security.auth.login.common.ServerLoginCallbackHandler;
import com.sun.enterprise.security.auth.login.common.X509CertificateCredential;
import com.sun.enterprise.security.auth.realm.NoSuchRealmException;
import com.sun.enterprise.security.auth.realm.Realm;
import com.sun.enterprise.security.common.AppservAccessController;
import com.sun.enterprise.security.common.ClientSecurityContext;
import java.util.Iterator;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import org.glassfish.internal.api.Globals;

public class LoginContextDriver {
    private static final Logger LOGGER = SecurityLoggerInfo.getLogger();
    public static final ServerLoginCallbackHandler dummyCallback = new ServerLoginCallbackHandler();
    public static final String CERT_REALMNAME = "certificate";
    private static volatile AuditManager AUDIT_MANAGER;

    private LoginContextDriver() {
    }

    public static Subject doClientLogin(int type, CallbackHandler handler) throws LoginException {
        Subject subject = new Subject();
        switch (type) {
            case 1: {
                AppservAccessController.privileged(() -> LoginContextDriver.addCredentialToSubject("default", subject, handler));
                LoginContextDriver.postClientAuth(subject, PasswordCredential.class);
                return subject;
            }
            case 2: {
                AppservAccessController.privileged(() -> LoginContextDriver.addCredentialToSubject(CERT_REALMNAME, subject, handler));
                LoginContextDriver.postClientAuth(subject, X509CertificateCredential.class);
                return subject;
            }
            case 3: {
                AppservAccessController.privileged(() -> LoginContextDriver.addCredentialToSubject("default", subject, handler));
                LoginContextDriver.postClientAuth(subject, PasswordCredential.class);
                AppservAccessController.privileged(() -> LoginContextDriver.addCredentialToSubject("default", subject, handler));
                LoginContextDriver.postClientAuth(subject, X509CertificateCredential.class);
                return subject;
            }
        }
        AppservAccessController.privileged(() -> LoginContextDriver.addCredentialToSubject("default", subject, handler));
        LoginContextDriver.postClientAuth(subject, PasswordCredential.class);
        return subject;
    }

    public static void doClientLogout() throws LoginException {
        LoginContextDriver.unsetClientSecurityContext();
    }

    public static void validateJaasLogin(String username, String jaasCtx, String realm, Subject subject) {
        try {
            LoginContextDriver.tryJaasLogin(jaasCtx, subject);
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "NCLS-SECURITY-05046", username);
            LoginContextDriver.auditAuthenticate(username, realm, false);
            LoginContextDriver.throwLoginException(e);
        }
        LoginContextDriver.auditAuthenticate(username, realm, true);
    }

    public static void tryJaasLogin(String jaasCtx, Subject subject) throws javax.security.auth.login.LoginException {
        LoginContext loginContext = new LoginContext(jaasCtx, subject, dummyCallback);
        loginContext.login();
    }

    public static void addCredentialToSubject(String name, Subject subject, CallbackHandler handler) {
        try {
            LoginContext lg = new LoginContext(name, subject, handler);
            lg.login();
        }
        catch (javax.security.auth.login.LoginException e) {
            throw (LoginException)new LoginException(e.toString()).initCause(e);
        }
    }

    public static Subject getValidSubject(Subject subject) {
        if (subject == null) {
            return new Subject();
        }
        return subject;
    }

    public static String getValidRealm(String realm) {
        if (realm == null || !Realm.isValidRealm(realm)) {
            return Realm.getDefaultRealm();
        }
        return realm;
    }

    public static String getJaasContext(String realm) {
        try {
            return Realm.getInstance(realm).getJAASContext();
        }
        catch (Exception ex) {
            if (ex instanceof LoginException) {
                throw (LoginException)ex;
            }
            throw (LoginException)new LoginException(ex.toString()).initCause(ex);
        }
    }

    public static Realm getRealmInstance(String realmName) throws NoSuchRealmException {
        String validRealmName = realmName;
        if (realmName == null || "".equals(realmName)) {
            validRealmName = Realm.getDefaultRealm();
        }
        return Realm.getInstance(validRealmName);
    }

    public static void throwLoginException(Exception exception) {
        LoginContextDriver.throwLoginException(exception, e -> "Login failed: " + e.getMessage());
    }

    public static void throwLoginException(Exception e, Function<Exception, String> exceptionStringFn) {
        if (e instanceof LoginException) {
            throw (LoginException)e;
        }
        throw new LoginException(exceptionStringFn.apply(e), e);
    }

    private static void postClientAuth(Subject subject, Class<?> clazz) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "LoginContextDriver post login subject :{0}", subject);
        }
        Iterator credentialsIterator = AppservAccessController.privileged(() -> subject.getPrivateCredentials(clazz)).iterator();
        while (credentialsIterator.hasNext()) {
            Object credential = null;
            try {
                credential = AppservAccessController.privileged(() -> credentialsIterator.next());
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "NCLS-SECURITY-05043", e);
            }
            if (credential instanceof PasswordCredential) {
                PasswordCredential passwordCredential = (PasswordCredential)credential;
                String user = passwordCredential.getUser();
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.log(Level.FINEST, "In LoginContextDriver user-pass login:{0} realm :{1}", new Object[]{user, passwordCredential.getRealm()});
                }
                LoginContextDriver.setClientSecurityContext(user, subject);
                return;
            }
            if (!(credential instanceof X509CertificateCredential)) continue;
            X509CertificateCredential certificateCredential = (X509CertificateCredential)credential;
            String user = certificateCredential.getAlias();
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "In LoginContextDriver cert-login::{0} realm :{1}", new Object[]{user, certificateCredential.getRealm()});
            }
            LoginContextDriver.setClientSecurityContext(user, subject);
            return;
        }
    }

    private static void setClientSecurityContext(String username, Subject subject) {
        ClientSecurityContext.setCurrent(new ClientSecurityContext(username, subject));
    }

    private static void unsetClientSecurityContext() {
        ClientSecurityContext.setCurrent(null);
    }

    private static AuditManager getAuditManager() {
        if (AUDIT_MANAGER != null) {
            return AUDIT_MANAGER;
        }
        return LoginContextDriver._getAuditManager();
    }

    private static synchronized AuditManager _getAuditManager() {
        if (AUDIT_MANAGER == null) {
            SecurityServicesUtil secServUtil = (SecurityServicesUtil)Globals.get(SecurityServicesUtil.class);
            AUDIT_MANAGER = secServUtil.getAuditManager();
        }
        return AUDIT_MANAGER;
    }

    public static void auditAuthenticate(String username, String realm, boolean success) {
        if (LoginContextDriver.getAuditManager().isAuditOn()) {
            LoginContextDriver.getAuditManager().authentication(username, realm, success);
        }
    }
}

