/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.realm.certificate;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public enum OID {
    CN("2.5.4.3"),
    SURNAME("2.5.4.4"),
    SERIALNUMBER("2.5.4.5"),
    C("2.5.4.6"),
    L("2.5.4.7"),
    ST("2.5.4.8"),
    STREET("2.5.4.9"),
    O("2.5.4.10"),
    OU("2.5.4.11"),
    T("2.5.4.12"),
    GIVENNAME("2.5.4.42"),
    INITIALS("2.5.4.43"),
    GENERATION("2.5.4.44"),
    DNQUALIFIER("2.5.4.46"),
    UID("0.9.2342.19200300.100.1.1"),
    DC("0.9.2342.19200300.100.1.25"),
    EMAILADDRESS("1.2.840.113549.1.9.1"),
    IP("1.3.6.1.4.1.42.2.11.2.1");

    private static final Map<String, String> OID_TO_NAME;
    private String objectId;

    private OID(String objectId) {
        this.objectId = objectId;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public String getName() {
        return this.name();
    }

    public static Map<String, String> getOIDMap() {
        return OID_TO_NAME;
    }

    public static OID getByObjectId(String objectId) {
        return OID.getByGetter(OID::getObjectId, objectId);
    }

    public static OID getByName(String name) {
        return OID.getByGetter(OID::getName, name);
    }

    public static Set<OID> toOIDS(String[] names) {
        Predicate<OID> filter = o -> o != null;
        return Arrays.stream(names).map(OID::getByName).filter(filter).collect(Collectors.toSet());
    }

    private static OID getByGetter(Function<OID, String> getter, String value) {
        for (OID oid : OID.values()) {
            if (!getter.apply(oid).equalsIgnoreCase(value)) continue;
            return oid;
        }
        return null;
    }

    static {
        OID_TO_NAME = Collections.unmodifiableMap(Arrays.stream(OID.values()).collect(Collectors.toMap(OID::getObjectId, Enum::name)));
    }
}

