/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.requesttracing.store.strategy;

import fish.payara.notification.requesttracing.RequestTrace;
import fish.payara.nucleus.requesttracing.store.strategy.TraceStorageStrategy;
import java.util.Collection;
import java.util.Iterator;
import java.util.Random;

public class ReservoirTraceStorageStrategy
implements TraceStorageStrategy {
    private final Random random;

    public ReservoirTraceStorageStrategy() {
        this.random = new Random();
    }

    protected ReservoirTraceStorageStrategy(long seed) {
        this.random = new Random(seed);
    }

    @Override
    public RequestTrace getTraceForRemoval(Collection<RequestTrace> traces, int maxSize, RequestTrace traceToRemove) {
        if (traces.size() <= maxSize) {
            return null;
        }
        return traceToRemove != null && traces.contains(traceToRemove) ? traceToRemove : this.findRandomTrace(traces);
    }

    private RequestTrace findRandomTrace(Collection<RequestTrace> traces) {
        int itemToReplace = this.random.nextInt(traces.size());
        Iterator<RequestTrace> iter = traces.iterator();
        for (int i = 0; i < itemToReplace; ++i) {
            iter.next();
        }
        return iter.next();
    }
}

