/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.admin.cluster;

import com.sun.enterprise.admin.util.TimeoutParamDefaultCalculator;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.v3.admin.cluster.ClusterCommandHelper;
import com.sun.enterprise.v3.admin.cluster.Strings;
import fish.payara.enterprise.config.serverbeans.DeploymentGroup;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.Progress;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RestParam;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@I18n(value="start.dg.command")
@Service(name="start-deployment-group")
@ExecuteOn(value={RuntimeType.DAS})
@CommandLock(value=CommandLock.LockType.NONE)
@PerLookup
@RestEndpoints(value={@RestEndpoint(configBean=DeploymentGroup.class, opType=RestEndpoint.OpType.POST, path="start-deployment-group", description="Start Deployment Group", params={@RestParam(name="id", value="$parent")})})
@Progress
public class StartDeploymentGroupCommand
implements AdminCommand {
    @Inject
    private ServerEnvironment env;
    @Inject
    private Domain domain;
    @Inject
    private CommandRunner runner;
    @Param(optional=false, primary=true)
    private String deploymentGroup;
    @Param(optional=true, shortName="v", defaultValue="false")
    private boolean verbose;
    @Param(optional=true, defaultCalculator=TimeoutParamDefaultCalculator.class)
    private int instanceTimeout;
    @Param(optional=true, defaultCalculator=TimeoutParamDefaultCalculator.class)
    private int timeout;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Logger logger = context.getLogger();
        if (this.timeout <= 0) {
            String msg = "Timeout must be at least 1 second long.";
            logger.warning(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(msg);
            return;
        }
        if (this.instanceTimeout <= 0) {
            String msg = "Instance Timeout must be at least 1 second long.";
            logger.warning(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(msg);
            return;
        }
        logger.info(Strings.get("start.dg", this.deploymentGroup));
        if (!this.env.isDas()) {
            String msg = Strings.get("cluster.command.notDas");
            logger.warning(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(msg);
            return;
        }
        ClusterCommandHelper clusterHelper = new ClusterCommandHelper(this.domain, this.runner);
        try {
            String commandName = "start-instance";
            ParameterMap parameterMap = new ParameterMap();
            parameterMap.add((Object)"timeout", (Object)String.valueOf(this.instanceTimeout));
            clusterHelper.setAdminTimeout(this.timeout * 1000);
            clusterHelper.runCommand(commandName, parameterMap, this.deploymentGroup, context, this.verbose);
        }
        catch (CommandException e) {
            String msg = e.getLocalizedMessage();
            logger.warning(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(msg);
        }
    }
}

