/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.weld.services;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.concurrent.atomic.AtomicBoolean;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.glassfish.weld.services.WeldProxyException;
import org.jboss.weld.serialization.spi.ProxyServices;

public class ProxyServicesImpl
implements ProxyServices {
    private static Method defineClassMethod;
    private static Method defineClassMethodSM;
    private static final AtomicBoolean CL_METHODS_INITIALIZATION_FINISHED;
    private final ClassLoaderHierarchy classLoaderHierarchy;

    public ProxyServicesImpl(ServiceLocator services) {
        this.classLoaderHierarchy = (ClassLoaderHierarchy)services.getService(ClassLoaderHierarchy.class, new Annotation[0]);
    }

    @Deprecated
    public boolean supportsClassDefining() {
        return true;
    }

    @Deprecated
    public ClassLoader getClassLoader(Class<?> proxiedBeanType) {
        if (System.getSecurityManager() == null) {
            return this.getClassLoaderforBean(proxiedBeanType);
        }
        PrivilegedAction<ClassLoader> action = () -> this.getClassLoaderforBean(proxiedBeanType);
        return AccessController.doPrivileged(action);
    }

    @Deprecated
    public Class<?> loadBeanClass(String className) {
        try {
            if (System.getSecurityManager() == null) {
                return this.loadClassByThreadCL(className);
            }
            PrivilegedExceptionAction<Class> action = () -> this.loadClassByThreadCL(className);
            return AccessController.doPrivileged(action);
        }
        catch (Exception ex) {
            throw new WeldProxyException("Failed to load the bean class: " + className, ex);
        }
    }

    public Class<?> defineClass(Class<?> originalClass, String className, byte[] classBytes, int off, int len) throws ClassFormatError {
        return this.defineClass(originalClass, className, classBytes, off, len, null);
    }

    public Class<?> defineClass(Class<?> originalClass, String className, byte[] classBytes, int off, int len, ProtectionDomain protectionDomain) throws ClassFormatError {
        ProxyServicesImpl.checkClassDefinitionFeature();
        ClassLoader loader = this.getClassLoaderforBean(originalClass);
        if (protectionDomain == null) {
            return this.defineClass(loader, className, classBytes, off, len);
        }
        return this.defineClass(loader, className, classBytes, off, len, protectionDomain);
    }

    public Class<?> loadClass(Class<?> originalClass, String classBinaryName) throws ClassNotFoundException {
        return this.getClassLoaderforBean(originalClass).loadClass(classBinaryName);
    }

    public void cleanup() {
    }

    private static void checkClassDefinitionFeature() {
        if (CL_METHODS_INITIALIZATION_FINISHED.compareAndSet(false, true)) {
            try {
                PrivilegedExceptionAction<Void> action = () -> {
                    Class<?> cl = Class.forName("java.lang.ClassLoader");
                    String name = "defineClass";
                    defineClassMethod = cl.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
                    defineClassMethod.setAccessible(true);
                    defineClassMethodSM = cl.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class);
                    defineClassMethodSM.setAccessible(true);
                    return null;
                };
                AccessController.doPrivileged(action);
            }
            catch (Exception e) {
                throw new WeldProxyException("Could not initialize access to ClassLoader.defineClass method.", e);
            }
        }
    }

    private ClassLoader getClassLoaderforBean(Class<?> originalClass) {
        ClassLoader originalClassLoader = originalClass.getClassLoader();
        if (this.isApplicationClassLoader(originalClassLoader)) {
            return originalClassLoader;
        }
        ClassLoader threadCL = Thread.currentThread().getContextClassLoader();
        if (threadCL != null) {
            return threadCL;
        }
        throw new WeldProxyException("Could not determine classloader for " + originalClass);
    }

    private boolean isApplicationClassLoader(ClassLoader classLoader) {
        while (classLoader != null) {
            if (classLoader.equals(this.classLoaderHierarchy.getCommonClassLoader())) {
                return true;
            }
            classLoader = classLoader.getParent();
        }
        return false;
    }

    private Class<?> loadClassByThreadCL(String className) throws ClassNotFoundException {
        return Class.forName(className, true, Thread.currentThread().getContextClassLoader());
    }

    private Class<?> defineClass(ClassLoader loader, String className, byte[] b, int off, int len, ProtectionDomain protectionDomain) {
        try {
            return (Class)defineClassMethodSM.invoke((Object)loader, className, b, 0, len, protectionDomain);
        }
        catch (Exception e) {
            throw new WeldProxyException("Could not define class " + className, e);
        }
    }

    private Class<?> defineClass(ClassLoader loader, String className, byte[] b, int off, int len) {
        try {
            return (Class)defineClassMethod.invoke((Object)loader, className, b, 0, len);
        }
        catch (Exception e) {
            throw new WeldProxyException("Could not define class " + className, e);
        }
    }

    static {
        CL_METHODS_INITIALIZATION_FINISHED = new AtomicBoolean(false);
    }
}

