/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.weld.services;

import java.beans.Introspector;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Resource;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.weld.injection.spi.ResourceInjectionServices;
import org.jboss.weld.injection.spi.ResourceReferenceFactory;
import org.jboss.weld.injection.spi.helpers.SimpleResourceReference;

public class ResourceInjectionServicesImpl
implements ResourceInjectionServices {
    static final String ENV = "java:comp/env";
    private static final Logger LOG = Logger.getLogger(ResourceInjectionServicesImpl.class.getName());
    private final InitialContext namingContext;

    public ResourceInjectionServicesImpl() {
        try {
            this.namingContext = new InitialContext();
        }
        catch (NamingException e) {
            throw new RuntimeException("Initial context not available at deployment time", e);
        }
    }

    public ResourceReferenceFactory<Object> registerResourceInjectionPoint(InjectionPoint injectionPoint) {
        if (this.getResourceAnnotation(injectionPoint) == null) {
            throw new IllegalArgumentException("No @Resource annotation found on injection point " + injectionPoint);
        }
        if (injectionPoint.getMember() instanceof Method && ((Method)injectionPoint.getMember()).getParameterCount() != 1) {
            throw new IllegalArgumentException("Resource injection point represents a method which doesn't have exactly one parameter " + injectionPoint);
        }
        return () -> new SimpleResourceReference(this.resolveResource(injectionPoint));
    }

    private Context getContext() {
        return this.namingContext;
    }

    private Resource getResourceAnnotation(InjectionPoint injectionPoint) {
        Annotated annotated = injectionPoint.getAnnotated();
        if (annotated instanceof AnnotatedParameter) {
            annotated = ((AnnotatedParameter)annotated).getDeclaringCallable();
        }
        return (Resource)annotated.getAnnotation(Resource.class);
    }

    private Object resolveResource(InjectionPoint injectionPoint) {
        String name = this.determineResourceName(injectionPoint);
        try {
            return this.getContext().lookup(name);
        }
        catch (NamingException e) {
            LOG.log(Level.FINE, e, () -> "Failed to find " + name + " in JNDI");
            return null;
        }
    }

    private String determineResourceName(InjectionPoint injectionPoint) {
        String propertyName;
        Resource resource = this.getResourceAnnotation(injectionPoint);
        String lookup = resource.lookup();
        if (!lookup.isEmpty()) {
            return lookup;
        }
        String mappedName = resource.mappedName();
        if (!mappedName.isEmpty()) {
            return mappedName;
        }
        String name = resource.name();
        if (!name.isEmpty()) {
            return "java:comp/env/" + name;
        }
        if (injectionPoint.getMember() instanceof Field) {
            propertyName = injectionPoint.getMember().getName();
        } else if (injectionPoint.getMember() instanceof Method) {
            propertyName = ResourceInjectionServicesImpl.determinePropertyName((Method)injectionPoint.getMember(), injectionPoint);
        } else {
            throw new AssertionError((Object)("Unable to inject Resource into " + injectionPoint));
        }
        String className = injectionPoint.getMember().getDeclaringClass().getName();
        return "java:comp/env/" + className + "/" + propertyName;
    }

    static String determinePropertyName(Method method, InjectionPoint injectionPoint) {
        String methodName = method.getName();
        if (methodName.startsWith("get") && method.getParameterCount() == 0) {
            return Introspector.decapitalize(methodName.substring(3));
        }
        if (methodName.startsWith("set") && method.getParameterCount() == 1) {
            return Introspector.decapitalize(methodName.substring(3));
        }
        if (methodName.startsWith("is") && method.getParameterCount() == 0) {
            return Introspector.decapitalize(methodName.substring(2));
        }
        throw new IllegalArgumentException("Injection point doesn't follow JavaBean conventions (unable to determine property name) " + injectionPoint);
    }

    public ResourceReferenceFactory<Object> registerResourceInjectionPoint(String jndiName, String mappedName) {
        return () -> new SimpleResourceReference(this.resolveResource(jndiName, mappedName));
    }

    private Object resolveResource(String jndiName, String mappedName) {
        if (mappedName != null && !mappedName.isEmpty()) {
            return mappedName;
        }
        return jndiName;
    }

    public void cleanup() {
    }
}

