/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.sql.generator;

import com.sun.jdo.spi.persistence.support.sqlstore.LogHelperSQLStore;
import com.sun.jdo.spi.persistence.support.sqlstore.database.DBVendorType;
import com.sun.jdo.spi.persistence.support.sqlstore.model.LocalFieldDesc;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import org.netbeans.modules.dbschema.ColumnElement;

public class DBStatement {
    public static final String BATCH_THRESHOLD_PROPERTY = "com.sun.jdo.spi.persistence.support.sqlstore.BATCH_THRESHOLD";
    private static final int BATCH_THRESHOLD = Integer.getInteger("com.sun.jdo.spi.persistence.support.sqlstore.BATCH_THRESHOLD", 100);
    private PreparedStatement preparedStmt;
    private int batchCounter = 0;
    private String statementText;
    private static Logger logger = LogHelperSQLStore.getLogger();

    public DBStatement(Connection conn, String statementText, int timeout) throws SQLException {
        this.statementText = statementText;
        this.preparedStmt = conn.prepareStatement(statementText);
        if (timeout != -1) {
            this.preparedStmt.setQueryTimeout(timeout);
        }
    }

    public String getStatementText() {
        return this.statementText;
    }

    public PreparedStatement getPreparedStatement() {
        return this.preparedStmt;
    }

    public boolean exceedsBatchThreshold() {
        return this.batchCounter >= BATCH_THRESHOLD;
    }

    public void addBatch() throws SQLException {
        ++this.batchCounter;
        if (logger.isLoggable(400)) {
            logger.finer("sqlstore.sql.generator.dbstatement.addbatch", (Object)this.batchCounter);
        }
        this.preparedStmt.addBatch();
    }

    public int[] executeBatch() throws SQLException {
        if (logger.isLoggable(400)) {
            logger.finer("sqlstore.sql.generator.dbstatement.executebatch", (Object)this.batchCounter);
        }
        this.batchCounter = 0;
        return this.preparedStmt.executeBatch();
    }

    public int executeUpdate() throws SQLException {
        return this.preparedStmt.executeUpdate();
    }

    public ResultSet executeQuery() throws SQLException {
        return this.preparedStmt.executeQuery();
    }

    public void close() throws SQLException {
        if (this.preparedStmt != null) {
            this.preparedStmt.close();
        }
    }

    public void bindInputColumn(int index, Object val, ColumnElement columnElement, DBVendorType vendorType) throws SQLException {
        int sqlType = DBStatement.getSqlType(columnElement);
        if (logger.isLoggable(400)) {
            Object[] items = new Object[]{index, val, sqlType};
            logger.finer("sqlstore.sql.generator.dbstatement.bindinputcolumn", items);
        }
        if (val == null) {
            this.preparedStmt.setNull(index, sqlType);
        } else if (val instanceof Number) {
            Number number = (Number)val;
            if (number instanceof Integer) {
                this.preparedStmt.setInt(index, number.intValue());
            } else if (number instanceof Long) {
                this.preparedStmt.setLong(index, number.longValue());
            } else if (number instanceof Short) {
                this.preparedStmt.setShort(index, number.shortValue());
            } else if (number instanceof Byte) {
                this.preparedStmt.setByte(index, number.byteValue());
            } else if (number instanceof Double) {
                this.preparedStmt.setDouble(index, number.doubleValue());
            } else if (number instanceof Float) {
                this.preparedStmt.setFloat(index, number.floatValue());
            } else if (number instanceof BigDecimal) {
                this.preparedStmt.setBigDecimal(index, (BigDecimal)number);
            } else if (number instanceof BigInteger) {
                this.preparedStmt.setBigDecimal(index, new BigDecimal((BigInteger)number));
            }
        } else if (val instanceof String) {
            this.bindStringValue(index, (String)val, columnElement, vendorType);
        } else if (val instanceof Boolean) {
            this.preparedStmt.setBoolean(index, (Boolean)val);
        } else if (val instanceof java.util.Date) {
            if (val instanceof Date) {
                this.preparedStmt.setDate(index, (Date)val);
            } else if (val instanceof Time) {
                this.preparedStmt.setTime(index, (Time)val);
            } else if (val instanceof Timestamp) {
                this.preparedStmt.setTimestamp(index, (Timestamp)val);
            } else {
                Timestamp timestamp = new Timestamp(((java.util.Date)val).getTime());
                this.preparedStmt.setTimestamp(index, timestamp);
            }
        } else if (val instanceof Character) {
            this.bindStringValue(index, val.toString(), columnElement, vendorType);
        } else if (val instanceof byte[]) {
            byte[] ba = (byte[])val;
            this.preparedStmt.setBinaryStream(index, (InputStream)new ByteArrayInputStream(ba), ba.length);
        } else if (val instanceof Blob) {
            this.preparedStmt.setBlob(index, (Blob)val);
        } else if (val instanceof Clob) {
            this.preparedStmt.setClob(index, (Clob)val);
        } else {
            this.preparedStmt.setObject(index, val);
        }
    }

    private void bindStringValue(int index, String strVal, ColumnElement columnElement, DBVendorType vendorType) throws SQLException {
        int sqlType = DBStatement.getSqlType(columnElement);
        if (LocalFieldDesc.isCharLobType(sqlType)) {
            this.preparedStmt.setCharacterStream(index, (Reader)new StringReader(strVal), strVal.length());
        } else if (LocalFieldDesc.isFixedCharType(sqlType)) {
            vendorType.getSpecialDBOperation().bindFixedCharColumn(this.preparedStmt, index, strVal, DBStatement.getLength(columnElement));
        } else {
            this.preparedStmt.setString(index, strVal);
        }
    }

    private static int getSqlType(ColumnElement columnElement) {
        return columnElement != null ? columnElement.getType() : 1111;
    }

    private static int getLength(ColumnElement columnElement) {
        Integer l;
        int length = -1;
        if (columnElement != null && (l = columnElement.getLength()) != null) {
            length = l;
        }
        return length;
    }
}

