/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.sql.generator;

import com.sun.jdo.spi.persistence.support.sqlstore.SQLStateManager;
import com.sun.jdo.spi.persistence.support.sqlstore.Transaction;
import com.sun.jdo.spi.persistence.support.sqlstore.database.DBVendorType;
import com.sun.jdo.spi.persistence.support.sqlstore.model.ForeignFieldDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.LocalFieldDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.UpdateObjectDescImpl;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.ConstraintValue;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.ColumnRef;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.DBStatement;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.InputValue;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.QueryPlan;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.QueryTable;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.Statement;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.UpdateQueryPlan;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.dbschema.ColumnElement;

public class UpdateStatement
extends Statement
implements Cloneable {
    public int minAffectedRows;
    private Map dbStatementCache = new HashMap();
    UpdateQueryPlan plan;
    private List columnRefsForWhereClause;
    private List versionColumns;
    private boolean batch = false;
    private StringBuilder values;
    private boolean isConstraintAdded;
    public static final String UPDATE_VERSION_COL_PROPERTY = "com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.UPDATE_VERSION_COL";
    private static final boolean UPDATE_VERSION_COL = Boolean.valueOf(System.getProperty("com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.UPDATE_VERSION_COL", "true"));

    public UpdateStatement(DBVendorType vendorType, UpdateQueryPlan plan, boolean batch) {
        super(vendorType);
        this.plan = plan;
        this.columnRefsForWhereClause = new ArrayList();
        this.batch = batch;
        this.minAffectedRows = 1;
    }

    public void addColumn(ColumnElement columnElement, Object value) {
        this.addColumnRef(new ColumnRef(columnElement, value));
    }

    protected void addConstraint(ColumnElement columnElement, LocalFieldDesc lf, Object value) {
        this.columnRefsForWhereClause.add(new ColumnRef(columnElement, value));
        this.addConstraint(lf, value);
    }

    private void calculateWhereClauseColumnRefIndexes() {
        int nextIndex = this.columns.size() + this.columnRefsForWhereClause.size();
        for (ColumnRef columnRef : this.columnRefsForWhereClause) {
            columnRef.setIndex(nextIndex--);
        }
    }

    public boolean isConstraintAdded() {
        return this.isConstraintAdded;
    }

    public void markConstraintAdded() {
        this.isConstraintAdded = true;
    }

    @Override
    public QueryPlan getQueryPlan() {
        return this.plan;
    }

    @Override
    protected void generateStatementText() {
        this.statementText = new StringBuilder();
        StringBuilder columnList = this.generateColumnText();
        StringBuilder constraint = this.processConstraints();
        String tableName = ((QueryTable)this.tableList.get(0)).getTableDesc().getName();
        switch (this.action) {
            case 1: {
                this.statementText.append("update ");
                this.appendQuotedText(this.statementText, tableName);
                this.statementText.append(" set ").append((CharSequence)columnList).append(" where ").append((CharSequence)constraint);
                break;
            }
            case 3: {
                this.statementText.append("delete from ");
                this.appendQuotedText(this.statementText, tableName);
                this.statementText.append(" where ").append((CharSequence)constraint);
                break;
            }
            case 2: {
                this.statementText.append("insert into ");
                this.appendQuotedText(this.statementText, tableName);
                this.statementText.append("(").append((CharSequence)columnList).append(") values ").append("(").append((CharSequence)this.values).append(")");
            }
        }
        this.calculateWhereClauseColumnRefIndexes();
    }

    private StringBuilder generateColumnText() {
        StringBuilder columnList = new StringBuilder();
        int numValues = -1;
        for (int i = 0; i < this.columns.size(); ++i) {
            ColumnRef c = (ColumnRef)this.columns.get(i);
            if (columnList.length() > 0) {
                columnList.append(", ");
            }
            switch (this.action) {
                case 1: {
                    this.appendQuotedText(columnList, c.getName());
                    columnList.append("= ?");
                    break;
                }
                case 2: {
                    this.appendQuotedText(columnList, c.getName());
                    if (i == 0) {
                        this.values = new StringBuilder().append(" ?");
                        break;
                    }
                    this.values.append(", ?");
                }
            }
            if (this.batch || this.action != 1 && this.action != 2) continue;
            InputValue val = new InputValue(c.getValue(), c.getColumnElement());
            this.inputDesc.values.add(++numValues, val);
        }
        this.appendVersionColumnUpdateClause(columnList);
        return columnList;
    }

    private void appendVersionColumnUpdateClause(StringBuilder setClause) {
        if (UPDATE_VERSION_COL && this.versionColumns != null) {
            for (int i = 0; i < this.versionColumns.size(); ++i) {
                ColumnElement columnElement = (ColumnElement)this.versionColumns.get(i);
                String columnName = columnElement.getName().getName();
                setClause.append(", ");
                this.appendQuotedText(setClause, columnName);
                setClause.append(" = ");
                this.appendQuotedText(setClause, columnName);
                setClause.append(" + ");
                setClause.append("1");
            }
        }
    }

    public void addLocalConstraints(int action, ForeignFieldDesc f, SQLStateManager sm) {
        for (int i = 0; i < f.localFields.size(); ++i) {
            LocalFieldDesc lf = (LocalFieldDesc)f.localFields.get(i);
            if (action == 2) {
                ColumnElement lc = (ColumnElement)f.assocLocalColumns.get(i);
                this.addColumn(lc, lf.getValue(sm));
                continue;
            }
            if (action != 3) continue;
            LocalFieldDesc alf = (LocalFieldDesc)f.assocLocalFields.get(i);
            this.addConstraint(alf, lf.getValue(sm));
        }
    }

    public void addForeignConstraints(int action, ForeignFieldDesc f, SQLStateManager sm) {
        for (int i = 0; i < f.foreignFields.size(); ++i) {
            LocalFieldDesc ff = (LocalFieldDesc)f.foreignFields.get(i);
            if (action == 2) {
                ColumnElement fc = (ColumnElement)f.assocForeignColumns.get(i);
                this.addColumn(fc, ff.getValue(sm));
                continue;
            }
            if (action != 3) continue;
            LocalFieldDesc aff = (LocalFieldDesc)f.assocForeignFields.get(i);
            this.addConstraint(aff, ff.getValue(sm));
        }
    }

    @Override
    protected void processConstraintValue(ConstraintValue node, StringBuilder result) {
        result.append("?");
        if (!this.batch) {
            this.generateInputValueForConstraintValueNode(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBStatement getDBStatement(Transaction tran, Connection conn) throws SQLException {
        DBStatement dbStatement = null;
        Map map = this.dbStatementCache;
        synchronized (map) {
            dbStatement = (DBStatement)this.dbStatementCache.get(tran);
            if (dbStatement == null) {
                dbStatement = new DBStatement(conn, this.getText(), tran.getUpdateTimeout());
                this.dbStatementCache.put(tran, dbStatement);
            }
        }
        return dbStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exceedsBatchThreshold(Transaction tran) {
        Map map = this.dbStatementCache;
        synchronized (map) {
            DBStatement dbStatement = (DBStatement)this.dbStatementCache.get(tran);
            return dbStatement != null && dbStatement.exceedsBatchThreshold();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBStatement removeDBStatement(Transaction tran) {
        Map map = this.dbStatementCache;
        synchronized (map) {
            DBStatement s = (DBStatement)this.dbStatementCache.remove(tran);
            return s;
        }
    }

    public void bindInputColumns(DBStatement s, UpdateObjectDescImpl updateDesc) throws SQLException {
        Iterator i = this.getColumnRefs().iterator();
        while (i.hasNext()) {
            this.bindInputColumn(s, (ColumnRef)i.next(), updateDesc, false);
        }
        i = this.columnRefsForWhereClause.iterator();
        while (i.hasNext()) {
            this.bindInputColumn(s, (ColumnRef)i.next(), updateDesc, updateDesc.isBeforeImageRequired());
        }
    }

    private void bindInputColumn(DBStatement stmt, ColumnRef columnRef, UpdateObjectDescImpl updateDesc, boolean getBeforeValue) throws SQLException {
        Object inputValue = UpdateStatement.getInputValue(updateDesc, columnRef, getBeforeValue);
        stmt.bindInputColumn(columnRef.getIndex(), inputValue, columnRef.getColumnElement(), this.vendorType);
    }

    private Object[] getInputValues(UpdateObjectDescImpl updateDesc) {
        Object[] inputValues = new Object[this.getColumnRefs().size() + this.columnRefsForWhereClause.size()];
        for (ColumnRef columnRef : this.getColumnRefs()) {
            inputValues[columnRef.getIndex() - 1] = UpdateStatement.getInputValue(updateDesc, columnRef, false);
        }
        boolean getBeforeValue = updateDesc.isBeforeImageRequired();
        for (ColumnRef columnRef : this.columnRefsForWhereClause) {
            inputValues[columnRef.getIndex() - 1] = UpdateStatement.getInputValue(updateDesc, columnRef, getBeforeValue);
        }
        return inputValues;
    }

    public String getFormattedSQLText(UpdateObjectDescImpl updateDesc) {
        return UpdateStatement.formatSqlText(this.getText(), this.getInputValues(updateDesc));
    }

    private static Object getInputValue(UpdateObjectDescImpl updateDesc, ColumnRef columnRef, boolean getBeforeValue) {
        LocalFieldDesc field = (LocalFieldDesc)columnRef.getValue();
        Object value = field.isVersion() ? updateDesc.getAfterValue(field) : (getBeforeValue ? updateDesc.getBeforeValue(field) : updateDesc.getAfterValue(field));
        return value;
    }

    public void addVersionColumn(ColumnElement versionColumn) {
        if (this.versionColumns == null) {
            this.versionColumns = new ArrayList();
        }
        this.versionColumns.add(versionColumn);
    }
}

