/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.impl.attachment;

import com.sun.xml.ws.api.message.Attachment;
import com.sun.xml.ws.encoding.DataSourceStreamingDataHandler;
import com.sun.xml.ws.security.opt.impl.enc.CryptoProcessor;
import com.sun.xml.ws.util.ByteArrayDataSource;
import com.sun.xml.wss.XWSSecurityException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import javax.activation.DataHandler;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

public class EncryptedAttachment
implements Attachment {
    private Attachment attachment;
    private String dataAlgo;
    private Key key;
    private byte[] data;

    public EncryptedAttachment(Attachment attachment, String dataAlgo, Key key) throws XWSSecurityException {
        this.attachment = attachment;
        this.dataAlgo = dataAlgo;
        this.key = key;
        this.doEncryption();
    }

    @Override
    public String getContentId() {
        return this.attachment.getContentId();
    }

    @Override
    public String getContentType() {
        return "application/octet-stream";
    }

    @Override
    public byte[] asByteArray() {
        return this.data;
    }

    @Override
    public DataHandler asDataHandler() {
        return new DataSourceStreamingDataHandler(new ByteArrayDataSource(this.data, this.getContentType()));
    }

    @Override
    public Source asSource() {
        return new StreamSource(this.asInputStream());
    }

    @Override
    public InputStream asInputStream() {
        return new ByteArrayInputStream(this.data);
    }

    @Override
    public void writeTo(OutputStream os) throws IOException {
        os.write(this.asByteArray());
    }

    @Override
    public void writeTo(SOAPMessage saaj) throws SOAPException {
        AttachmentPart part = saaj.createAttachmentPart();
        part.setDataHandler(this.asDataHandler());
        part.setContentId(this.getContentId());
        saaj.addAttachmentPart(part);
    }

    private void doEncryption() throws XWSSecurityException {
        CryptoProcessor dep = new CryptoProcessor(1, this.dataAlgo, this.key);
        this.data = dep.encryptData(this.attachment.asByteArray());
    }
}

