/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.util.xml;

import com.sun.istack.Nullable;
import com.sun.org.apache.xml.internal.resolver.Catalog;
import com.sun.org.apache.xml.internal.resolver.CatalogManager;
import com.sun.org.apache.xml.internal.resolver.tools.CatalogResolver;
import com.sun.xml.ws.api.ResourceLoader;
import com.sun.xml.ws.server.ServerRtException;
import com.sun.xml.ws.util.ServiceFinder;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import javax.xml.ws.WebServiceException;
import org.xml.sax.EntityResolver;

public class XmlCatalogUtil {
    public static EntityResolver createEntityResolver(@Nullable URL catalogUrl) {
        CatalogManager manager = new CatalogManager();
        manager.setIgnoreMissingProperties(true);
        manager.setUseStaticCatalog(false);
        Catalog catalog = manager.getCatalog();
        try {
            if (catalogUrl != null) {
                catalog.parseCatalog(catalogUrl);
            }
        }
        catch (IOException e) {
            throw new ServerRtException("server.rt.err", e);
        }
        return XmlCatalogUtil.workaroundCatalogResolver(catalog);
    }

    public static EntityResolver createDefaultCatalogResolver() {
        CatalogManager manager = new CatalogManager();
        manager.setIgnoreMissingProperties(true);
        manager.setUseStaticCatalog(false);
        manager.getVerbosity();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Catalog catalog = manager.getCatalog();
        XmlCatalogUtil.parseResourcesToCatalog(cl, catalog, "META-INF/jax-ws-catalog.xml");
        XmlCatalogUtil.parseResourcesToCatalog(catalog, "jax-ws-catalog.xml");
        return XmlCatalogUtil.workaroundCatalogResolver(catalog);
    }

    private static void parseResourcesToCatalog(ClassLoader classLoader, Catalog catalog, String resourceName) {
        try {
            Enumeration<URL> catalogEnum = classLoader == null ? ClassLoader.getSystemResources(resourceName) : classLoader.getResources(resourceName);
            while (catalogEnum.hasMoreElements()) {
                URL url = catalogEnum.nextElement();
                catalog.parseCatalog(url);
            }
        }
        catch (IOException e) {
            throw new WebServiceException((Throwable)e);
        }
    }

    private static void parseResourcesToCatalog(Catalog catalog, String resourceName) {
        try {
            for (ResourceLoader resourceLoader : ServiceFinder.find(ResourceLoader.class)) {
                URL resource = resourceLoader.getResource(resourceName);
                if (resource == null) continue;
                catalog.parseCatalog(resourceLoader.getResource(resourceName));
            }
        }
        catch (IOException e) {
            throw new WebServiceException((Throwable)e);
        }
    }

    private static CatalogResolver workaroundCatalogResolver(final Catalog catalog) {
        CatalogManager manager = new CatalogManager(){

            @Override
            public Catalog getCatalog() {
                return catalog;
            }
        };
        manager.setIgnoreMissingProperties(true);
        manager.setUseStaticCatalog(false);
        return new CatalogResolver(manager);
    }
}

