/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config.manager.tasks;

import com.sun.faces.config.ConfigManager;
import com.sun.faces.config.ConfigurationException;
import com.sun.faces.config.manager.DbfFactory;
import com.sun.faces.config.manager.documents.DocumentInfo;
import com.sun.faces.config.processor.FacesFlowDefinitionConfigProcessor;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Timer;
import com.sun.faces.util.Util;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class ParseConfigResourceToDOMTask
implements Callable<DocumentInfo> {
    public static final String WEB_INF_MARKER = "com.sun.faces.webinf";
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
    private static final String JAVAEE_SCHEMA_LEGACY_DEFAULT_NS = "http://java.sun.com/xml/ns/javaee";
    private static final String JAVAEE_SCHEMA_DEFAULT_NS = "http://xmlns.jcp.org/xml/ns/javaee";
    private static final String JAKARTAEE_SCHEMA_DEFAULT_NS = "https://jakarta.ee/xml/ns/jakartaee";
    private static final String EMPTY_FACES_CONFIG = "com/sun/faces/empty-faces-config.xml";
    private static final String FACES_CONFIG_TAGNAME = "faces-config";
    private static final String FACELET_TAGLIB_TAGNAME = "facelet-taglib";
    private static final String FACES_CONFIG_1_X_DEFAULT_NS = "http://java.sun.com/JSF/Configuration";
    private static final String FACELETS_1_0_DEFAULT_NS = "http://java.sun.com/JSF/Facelet";
    private static final String FACELETS_3_0_DEFAULT_NS = "https://jakarta.ee/xml/ns/jakartaee";
    private static final String FACES_TO_1_1_PRIVATE_XSL = "/com/sun/faces/jsf1_0-1_1toSchema.xsl";
    private static final String FACELETS_TO_2_0_XSL = "/com/sun/faces/facelets1_0-2_0toSchema.xsl";
    private ServletContext servletContext;
    private URI documentURI;
    private DocumentBuilderFactory factory;
    private boolean validating;

    public ParseConfigResourceToDOMTask(ServletContext servletContext, boolean validating, URI documentURI) throws Exception {
        this.servletContext = servletContext;
        this.documentURI = documentURI;
        this.validating = validating;
    }

    @Override
    public DocumentInfo call() throws Exception {
        try {
            Timer timer = Timer.getInstance();
            if (timer != null) {
                timer.startTiming();
            }
            Document document = this.getDocument();
            if (timer != null) {
                timer.stopTiming();
                timer.logResult("Parse " + this.documentURI.toURL().toExternalForm());
            }
            return new DocumentInfo(document, this.documentURI);
        }
        catch (Exception e) {
            throw new ConfigurationException(MessageFormat.format("Unable to parse document ''{0}'': {1}", this.documentURI.toURL().toExternalForm(), e.getMessage()), e);
        }
    }

    private Document getDocument() throws Exception {
        Document returnDoc;
        Document doc;
        InputSource is;
        URL documentURL;
        DocumentBuilder db;
        block59: {
            db = this.getNonValidatingBuilder();
            documentURL = this.documentURI.toURL();
            is = new InputSource(ParseConfigResourceToDOMTask.getInputStream(documentURL));
            is.setSystemId(this.documentURI.toURL().toExternalForm());
            doc = null;
            try {
                doc = db.parse(is);
            }
            catch (SAXParseException spe) {
                InputStream stream = is.getByteStream();
                stream.close();
                is = new InputSource(ParseConfigResourceToDOMTask.getInputStream(documentURL));
                stream = is.getByteStream();
                if (!this.streamIsZeroLengthOrEmpty(stream) || !documentURL.toExternalForm().endsWith("faces-config.xml")) break block59;
                ClassLoader loader = this.getClass().getClassLoader();
                is = new InputSource(ParseConfigResourceToDOMTask.getInputStream(loader.getResource(EMPTY_FACES_CONFIG)));
                doc = db.parse(is);
            }
        }
        String documentNS = null;
        if (null == doc) {
            if (FacesFlowDefinitionConfigProcessor.uriIsFlowDefinition(this.documentURI)) {
                documentNS = JAVAEE_SCHEMA_DEFAULT_NS;
                doc = FacesFlowDefinitionConfigProcessor.synthesizeEmptyFlowDefinition(this.documentURI);
            }
        } else {
            boolean isNonFacesConfigDocument;
            Element documentElement = doc.getDocumentElement();
            documentNS = documentElement.getNamespaceURI();
            String rootElementTagName = documentElement.getTagName();
            boolean bl = isNonFacesConfigDocument = !FACES_CONFIG_TAGNAME.equals(rootElementTagName) && !FACELET_TAGLIB_TAGNAME.equals(rootElementTagName);
            if (isNonFacesConfigDocument) {
                ClassLoader loader = this.getClass().getClassLoader();
                is = new InputSource(ParseConfigResourceToDOMTask.getInputStream(loader.getResource(EMPTY_FACES_CONFIG)));
                doc = db.parse(is);
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, MessageFormat.format("Config document {0} with namespace URI {1} is not a faces-config or facelet-taglib file.  Ignoring.", this.documentURI.toURL().toExternalForm(), documentNS));
                }
                return doc;
            }
        }
        if (this.validating && documentNS != null) {
            DOMSource domSource = new DOMSource(doc, documentURL.toExternalForm());
            Element documentElement = ((Document)domSource.getNode()).getDocumentElement();
            switch (documentNS) {
                case "https://jakarta.ee/xml/ns/jakartaee": 
                case "http://xmlns.jcp.org/xml/ns/javaee": {
                    Attr version = (Attr)documentElement.getAttributes().getNamedItem("version");
                    if (version != null) {
                        Schema schema;
                        String versionStr;
                        switch (versionStr = version.getValue()) {
                            case "2.2": {
                                if (FACELET_TAGLIB_TAGNAME.equals(documentElement.getLocalName())) {
                                    schema = DbfFactory.getSchema(this.servletContext, DbfFactory.FacesSchema.FACELET_TAGLIB_22);
                                    break;
                                }
                                schema = DbfFactory.getSchema(this.servletContext, DbfFactory.FacesSchema.FACES_22);
                                break;
                            }
                            case "2.3": {
                                if (FACELET_TAGLIB_TAGNAME.equals(documentElement.getLocalName())) {
                                    schema = DbfFactory.getSchema(this.servletContext, DbfFactory.FacesSchema.FACELET_TAGLIB_22);
                                    break;
                                }
                                schema = DbfFactory.getSchema(this.servletContext, DbfFactory.FacesSchema.FACES_23);
                                break;
                            }
                            case "3.0": {
                                if (FACELET_TAGLIB_TAGNAME.equals(documentElement.getLocalName())) {
                                    schema = DbfFactory.getSchema(this.servletContext, DbfFactory.FacesSchema.FACELET_TAGLIB_30);
                                    break;
                                }
                                schema = DbfFactory.getSchema(this.servletContext, DbfFactory.FacesSchema.FACES_30);
                                break;
                            }
                            default: {
                                throw new ConfigurationException("Unknown Schema version: " + versionStr);
                            }
                        }
                        DocumentBuilder builder = this.getBuilderForSchema(schema);
                        if (builder.isValidating()) {
                            builder.getSchema().newValidator().validate(domSource);
                            returnDoc = (Document)domSource.getNode();
                            break;
                        }
                        returnDoc = (Document)domSource.getNode();
                        break;
                    }
                    throw new ConfigurationException("No document version available.");
                }
                case "http://java.sun.com/xml/ns/javaee": {
                    Attr version = (Attr)documentElement.getAttributes().getNamedItem("version");
                    if (version != null) {
                        Schema schema;
                        String versionStr = version.getValue();
                        switch (versionStr) {
                            case "2.0": {
                                if (FACELET_TAGLIB_TAGNAME.equals(documentElement.getLocalName())) {
                                    schema = DbfFactory.getSchema(this.servletContext, DbfFactory.FacesSchema.FACELET_TAGLIB_20);
                                    break;
                                }
                                schema = DbfFactory.getSchema(this.servletContext, DbfFactory.FacesSchema.FACES_20);
                                break;
                            }
                            case "2.1": {
                                if (FACELET_TAGLIB_TAGNAME.equals(documentElement.getLocalName())) {
                                    schema = DbfFactory.getSchema(this.servletContext, DbfFactory.FacesSchema.FACELET_TAGLIB_20);
                                    break;
                                }
                                schema = DbfFactory.getSchema(this.servletContext, DbfFactory.FacesSchema.FACES_21);
                                break;
                            }
                            case "1.2": {
                                schema = DbfFactory.getSchema(this.servletContext, DbfFactory.FacesSchema.FACES_12);
                                break;
                            }
                            default: {
                                throw new ConfigurationException("Unknown Schema version: " + versionStr);
                            }
                        }
                        Object builder = this.getBuilderForSchema(schema);
                        if (((DocumentBuilder)builder).isValidating()) {
                            ((DocumentBuilder)builder).getSchema().newValidator().validate(domSource);
                            returnDoc = (Document)domSource.getNode();
                            break;
                        }
                        returnDoc = (Document)domSource.getNode();
                        break;
                    }
                    throw new ConfigurationException("No document version available.");
                }
                default: {
                    Schema schemaToApply;
                    DOMResult domResult = new DOMResult();
                    Transformer transformer = ParseConfigResourceToDOMTask.getTransformer(documentNS);
                    transformer.transform(domSource, domResult);
                    ((Document)domResult.getNode()).setDocumentURI(((Document)domSource.getNode()).getDocumentURI());
                    switch (documentNS) {
                        case "http://java.sun.com/JSF/Configuration": {
                            schemaToApply = DbfFactory.getSchema(this.servletContext, DbfFactory.FacesSchema.FACES_11);
                            break;
                        }
                        case "http://java.sun.com/JSF/Facelet": {
                            schemaToApply = DbfFactory.getSchema(this.servletContext, DbfFactory.FacesSchema.FACELET_TAGLIB_20);
                            break;
                        }
                        case "https://jakarta.ee/xml/ns/jakartaee": {
                            schemaToApply = DbfFactory.getSchema(this.servletContext, DbfFactory.FacesSchema.FACELET_TAGLIB_30);
                            break;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                    Object builder = this.getBuilderForSchema(schemaToApply);
                    if (((DocumentBuilder)builder).isValidating()) {
                        ((DocumentBuilder)builder).getSchema().newValidator().validate(new DOMSource(domResult.getNode()));
                        returnDoc = (Document)domResult.getNode();
                        break;
                    }
                    returnDoc = (Document)domResult.getNode();
                }
            }
        } else {
            returnDoc = doc;
        }
        if (documentURL.toExternalForm().contains("/WEB-INF/faces-config.xml")) {
            Attr webInf = returnDoc.createAttribute(WEB_INF_MARKER);
            webInf.setValue("true");
            returnDoc.getDocumentElement().getAttributes().setNamedItem(webInf);
        }
        return returnDoc;
    }

    private boolean streamIsZeroLengthOrEmpty(InputStream is) throws IOException {
        boolean isZeroLengthOrEmpty = 0 == is.available();
        int size = 1024;
        byte[] b = new byte[1024];
        while (!isZeroLengthOrEmpty && -1 != is.read(b, 0, 1024)) {
            String s = new String(b, "UTF-8").trim();
            isZeroLengthOrEmpty = 0 == s.length();
            b[0] = 0;
            for (int i = 1; i < 1024; i += i) {
                System.arraycopy(b, 0, b, i, 1024 - i < i ? 1024 - i : i);
            }
        }
        return isZeroLengthOrEmpty;
    }

    private static Transformer getTransformer(String documentNS) throws Exception {
        String xslToApply;
        TransformerFactory factory = Util.createTransformerFactory();
        switch (documentNS) {
            case "http://java.sun.com/JSF/Configuration": {
                xslToApply = FACES_TO_1_1_PRIVATE_XSL;
                break;
            }
            case "http://java.sun.com/JSF/Facelet": {
                xslToApply = FACELETS_TO_2_0_XSL;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return factory.newTransformer(new StreamSource(ParseConfigResourceToDOMTask.getInputStream(ConfigManager.class.getResource(xslToApply))));
    }

    private static InputStream getInputStream(URL url) throws IOException {
        URLConnection connection = url.openConnection();
        connection.setUseCaches(false);
        return new BufferedInputStream(connection.getInputStream());
    }

    private DocumentBuilder getNonValidatingBuilder() throws Exception {
        DocumentBuilderFactory tFactory = DbfFactory.getFactory();
        tFactory.setValidating(false);
        DocumentBuilder tBuilder = tFactory.newDocumentBuilder();
        tBuilder.setEntityResolver(DbfFactory.FACES_ENTITY_RESOLVER);
        tBuilder.setErrorHandler(DbfFactory.FACES_ERROR_HANDLER);
        return tBuilder;
    }

    private DocumentBuilder getBuilderForSchema(Schema schema) throws Exception {
        this.factory = DbfFactory.getFactory();
        try {
            this.factory.setSchema(schema);
        }
        catch (UnsupportedOperationException upe) {
            return this.getNonValidatingBuilder();
        }
        DocumentBuilder builder = this.factory.newDocumentBuilder();
        builder.setEntityResolver(DbfFactory.FACES_ENTITY_RESOLVER);
        builder.setErrorHandler(DbfFactory.FACES_ERROR_HANDLER);
        return builder;
    }
}

