/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.client.acc;

import java.io.File;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Consumer;
import org.glassfish.appclient.common.ClientClassLoaderDelegate;

public class ACCClassLoader
extends URLClassLoader {
    private static final String AGENT_LOADER_CLASS_NAME = "org.glassfish.appclient.client.acc.agent.ACCAgentClassLoader";
    private static ACCClassLoader instance = null;
    private ACCClassLoader shadow = null;
    private boolean shouldTransform = false;
    private final List<ClassFileTransformer> transformers = Collections.synchronizedList(new ArrayList());
    private ClientClassLoaderDelegate clientCLDelegate;

    public static synchronized ACCClassLoader newInstance(ClassLoader parent, boolean shouldTransform) {
        if (instance != null) {
            throw new IllegalStateException("already set");
        }
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        boolean currentCLWasAgentCL = currentClassLoader.getClass().getName().equals(AGENT_LOADER_CLASS_NAME);
        ClassLoader parentForACCCL = currentCLWasAgentCL ? currentClassLoader.getParent() : currentClassLoader;
        PrivilegedAction<ACCClassLoader> action = () -> new ACCClassLoader(ACCClassLoader.userClassPath(), parentForACCCL, shouldTransform);
        instance = AccessController.doPrivileged(action);
        if (currentCLWasAgentCL) {
            try {
                ACCClassLoader.adjustACCAgentClassLoaderParent(instance);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return instance;
    }

    public static ACCClassLoader instance() {
        return instance;
    }

    private static void adjustACCAgentClassLoaderParent(ACCClassLoader instance) throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
        if (systemClassLoader.getClass().getName().equals(AGENT_LOADER_CLASS_NAME) && systemClassLoader instanceof Consumer) {
            Consumer consumerOfClassLoader = (Consumer)((Object)systemClassLoader);
            consumerOfClassLoader.accept(instance);
            System.setProperty("org.glassfish.appclient.acc.agentLoaderDone", "true");
        }
    }

    private static URL[] userClassPath() {
        URI GFSystemURI = ACCClassLoader.GFSystemURI();
        List<URL> result = ACCClassLoader.classPathToURLs(System.getProperty("java.class.path"));
        ListIterator<URL> it = result.listIterator();
        while (it.hasNext()) {
            URL url = it.next();
            try {
                if (!url.toURI().equals(GFSystemURI)) continue;
                it.remove();
            }
            catch (URISyntaxException ex) {
                throw new RuntimeException(ex);
            }
        }
        result.addAll(ACCClassLoader.classPathToURLs(System.getenv("APPCPATH")));
        return result.toArray(new URL[result.size()]);
    }

    private static URI GFSystemURI() {
        try {
            Class<?> agentClass = Class.forName("org.glassfish.appclient.client.acc.agent.AppClientContainerAgent");
            return agentClass.getProtectionDomain().getCodeSource().getLocation().toURI().normalize();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static List<URL> classPathToURLs(String classPath) {
        if (classPath == null) {
            return Collections.emptyList();
        }
        ArrayList<URL> result = new ArrayList<URL>();
        try {
            for (String classPathElement : classPath.split(File.pathSeparator)) {
                result.add(new File(classPathElement).toURI().normalize().toURL());
            }
            return result;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public ACCClassLoader(ClassLoader parent, boolean shouldTransform) {
        super(new URL[0], parent);
        this.shouldTransform = shouldTransform;
        this.clientCLDelegate = new ClientClassLoaderDelegate(this);
    }

    public ACCClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
        this.clientCLDelegate = new ClientClassLoaderDelegate(this);
    }

    private ACCClassLoader(URL[] urls, ClassLoader parent, boolean shouldTransform) {
        this(urls, parent);
        this.shouldTransform = shouldTransform;
    }

    public synchronized void appendURL(URL url) {
        this.addURL(url);
        if (this.shadow != null) {
            this.shadow.addURL(url);
        }
    }

    public void addTransformer(ClassFileTransformer xf) {
        this.transformers.add(xf);
    }

    public void setShouldTransform(boolean shouldTransform) {
        this.shouldTransform = shouldTransform;
    }

    synchronized ACCClassLoader shadow() {
        if (this.shadow == null) {
            PrivilegedAction<ACCClassLoader> action = () -> new ACCClassLoader(this.getURLs(), this.getParent());
            this.shadow = AccessController.doPrivileged(action);
        }
        return this.shadow;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if (!this.shouldTransform) {
            return super.findClass(name);
        }
        ACCClassLoader s = this.shadow();
        return this.copyClass(s.findClassUnshadowed(name));
    }

    private Class<?> copyClass(Class<?> c) throws ClassNotFoundException {
        String name = c.getName();
        ProtectionDomain pd = c.getProtectionDomain();
        byte[] bytecode = this.readByteCode(name);
        for (ClassFileTransformer xf : this.transformers) {
            try {
                bytecode = xf.transform(this, name, null, pd, bytecode);
            }
            catch (IllegalClassFormatException ex) {
                throw new ClassNotFoundException(name, ex);
            }
        }
        return this.defineClass(name, bytecode, 0, bytecode.length, pd);
    }

    private Class<?> findClassUnshadowed(String name) throws ClassNotFoundException {
        return super.findClass(name);
    }

    /*
     * Exception decompiling
     */
    private byte[] readByteCode(String className) throws ClassNotFoundException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource codesource) {
        if (System.getSecurityManager() == null) {
            return super.getPermissions(codesource);
        }
        if (this.clientCLDelegate.getCachedPerms(codesource) != null) {
            return this.clientCLDelegate.getCachedPerms(codesource);
        }
        return this.clientCLDelegate.getPermissions(codesource, super.getPermissions(codesource));
    }

    public void processDeclaredPermissions() {
        if (this.clientCLDelegate == null) {
            this.clientCLDelegate = new ClientClassLoaderDelegate(this);
        }
    }
}

