/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.common;

import com.sun.enterprise.security.integration.PermsHolder;
import com.sun.enterprise.security.permissionsxml.GlobalPolicyUtil;
import java.io.IOException;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.PermissionCollection;
import org.glassfish.appclient.common.PermissionsUtil;

public class ClientClassLoaderDelegate {
    protected static final String PERMISSIONS_XML = "META-INF/permissions.xml";
    private URLClassLoader classLoader;
    private PermsHolder permHolder;

    public ClientClassLoaderDelegate(URLClassLoader cl) {
        this.classLoader = cl;
        this.loadPemissions();
    }

    private void loadPemissions() {
        try {
            this.processDeclaredPermissions();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void processDeclaredPermissions() throws IOException {
        if (System.getSecurityManager() == null) {
            return;
        }
        PermissionCollection declaredPermissionCollection = PermissionsUtil.getClientDeclaredPermissions(this.classLoader);
        PermissionCollection eePc = PermissionsUtil.getClientEEPolicy(this.classLoader);
        PermissionCollection eeRestriction = PermissionsUtil.getClientRestrictPolicy(this.classLoader);
        GlobalPolicyUtil.checkRestriction((PermissionCollection)eePc, (PermissionCollection)eeRestriction);
        GlobalPolicyUtil.checkRestriction((PermissionCollection)declaredPermissionCollection, (PermissionCollection)eeRestriction);
        this.permHolder = new PermsHolder(eePc, declaredPermissionCollection, eeRestriction);
    }

    public PermissionCollection getCachedPerms(CodeSource codesource) {
        return this.permHolder.getCachedPerms(codesource);
    }

    public PermissionCollection getPermissions(CodeSource codesource, PermissionCollection parentPC) {
        return this.permHolder.getPermissions(codesource, parentPC);
    }
}

