/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.admin.cli;

import com.sun.ejb.containers.EJBTimerService;
import com.sun.ejb.containers.EjbContainerUtil;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;

@Service(name="list-timers")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="list.timers")
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.DEPLOYMENT_GROUP})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.GET, path="list-timers", description="List Timers")})
public class ListTimers
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ListTimers.class);
    @Param(primary=true, optional=true, defaultValue="server")
    String target;
    @Inject
    private EjbContainerUtil ejbContainerUtil;
    @Inject
    Target targetUtil;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        String[] serverIds = null;
        if (this.targetUtil.isCluster(this.target) || this.targetUtil.isDeploymentGroup(this.target)) {
            List serversInCluster = this.targetUtil.getInstances(this.target);
            serverIds = new String[serversInCluster.size()];
            for (int i = 0; i < serverIds.length; ++i) {
                serverIds[i] = ((Server)serversInCluster.get(i)).getName();
            }
        } else {
            serverIds = new String[]{this.target};
        }
        try {
            String[] timerCounts = this.listTimers(serverIds);
            ActionReport actionReport = context.getActionReport();
            Properties extraProperties = actionReport.getExtraProperties();
            if (extraProperties == null) {
                extraProperties = new Properties();
                actionReport.setExtraProperties(extraProperties);
            }
            LinkedList property = new LinkedList();
            extraProperties.put("ejbTimers", property);
            for (int i = 0; i < serverIds.length; ++i) {
                ActionReport.MessagePart part = report.getTopMessagePart().addChild();
                part.setMessage(serverIds[i] + ": " + timerCounts[i]);
                HashMap<String, String> values = new HashMap<String, String>();
                values.put("server", serverIds[i]);
                values.put("timerCount", timerCounts[i]);
                property.add(values);
            }
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (Exception e) {
            report.setMessage(localStrings.getLocalString("list.timers.failed", "List Timers command failed"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
        }
    }

    private String[] listTimers(String[] serverIds) {
        Object[] result;
        EJBTimerService ejbTimerService = null;
        if (EJBTimerService.isPersistentTimerServiceLoaded()) {
            ejbTimerService = EJBTimerService.getPersistentTimerService();
        } else if (EJBTimerService.isNonPersistentTimerServiceLoaded()) {
            ejbTimerService = EJBTimerService.getNonPersistentTimerService();
        }
        if (Objects.nonNull(ejbTimerService)) {
            result = ejbTimerService.listTimers(serverIds);
        } else {
            result = new String[serverIds.length];
            Arrays.fill(result, "0");
        }
        return result;
    }
}

