/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.jbatch.persistence.rdbms;

import com.ibm.jbatch.container.context.impl.StepContextImpl;
import com.ibm.jbatch.container.exception.BatchContainerServiceException;
import com.ibm.jbatch.container.exception.PersistenceException;
import com.ibm.jbatch.container.jobinstance.JobInstanceImpl;
import com.ibm.jbatch.container.jobinstance.JobOperatorJobExecution;
import com.ibm.jbatch.container.jobinstance.RuntimeFlowInSplitExecution;
import com.ibm.jbatch.container.jobinstance.RuntimeJobExecution;
import com.ibm.jbatch.container.jobinstance.StepExecutionImpl;
import com.ibm.jbatch.container.persistence.CheckpointData;
import com.ibm.jbatch.container.persistence.CheckpointDataKey;
import com.ibm.jbatch.container.services.IJobExecution;
import com.ibm.jbatch.container.services.IPersistenceManagerService;
import com.ibm.jbatch.container.status.JobStatus;
import com.ibm.jbatch.container.status.StepStatus;
import com.ibm.jbatch.container.util.TCCLObjectInputStream;
import com.ibm.jbatch.spi.services.IBatchConfig;
import fish.payara.jbatch.persistence.rdbms.JDBCQueryConstants;
import fish.payara.jbatch.persistence.rdbms.OracleJDBCConstants;
import fish.payara.notification.requesttracing.RequestTraceSpanLog;
import fish.payara.nucleus.requesttracing.RequestTracingService;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.batch.operations.NoSuchJobExecutionException;
import javax.batch.runtime.BatchStatus;
import javax.batch.runtime.JobInstance;
import javax.batch.runtime.Metric;
import javax.batch.runtime.StepExecution;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.glassfish.batch.spi.impl.BatchRuntimeConfiguration;
import org.glassfish.internal.api.Globals;

public class JBatchJDBCPersistenceManager
implements IPersistenceManagerService,
JDBCQueryConstants,
OracleJDBCConstants {
    private static final String CLASSNAME = JBatchJDBCPersistenceManager.class.getName();
    private static final Logger logger = Logger.getLogger(CLASSNAME);
    private IBatchConfig batchConfig = null;
    protected DataSource dataSource = null;
    protected String jndiName = null;
    protected String prefix = null;
    protected String suffix = null;
    protected String schema = "";
    protected Map<String, String> tableNames;
    protected Map<String, String> queryStrings;
    protected Map<String, String> createH2Strings;
    protected RequestTracingService requestTracing;
    private static final String JAVA_EE_MODE = "Java EE mode, getting connection from data source";
    private static final String NULL_TAGGED = "<null>";

    public void init(IBatchConfig batchConfig) throws BatchContainerServiceException {
        logger.log(Level.CONFIG, "Entering CLASSNAME.init(), batchConfig ={0}", batchConfig);
        this.batchConfig = batchConfig;
        this.schema = batchConfig.getDatabaseConfigurationBean().getSchema();
        this.jndiName = batchConfig.getDatabaseConfigurationBean().getJndiName();
        this.prefix = batchConfig.getConfigProperties().getProperty("payara.jbatch.table.prefix", "");
        this.suffix = batchConfig.getConfigProperties().getProperty("payara.jbatch.table.suffix", "");
        logger.log(Level.CONFIG, "JNDI name = {0}", this.jndiName);
        if (this.jndiName == null || this.jndiName.equals("")) {
            throw new BatchContainerServiceException("JNDI name is not defined.");
        }
        try {
            this.dataSource = (DataSource)new InitialContext().lookup(this.jndiName);
        }
        catch (NamingException e) {
            logger.severe("Lookup failed for JNDI name: " + this.jndiName + ".  One cause of this could be that the batch runtime is incorrectly configured to EE mode when it should be in SE mode.");
            throw new BatchContainerServiceException((Throwable)e);
        }
        this.tableNames = this.getSharedTableMap();
        try {
            this.queryStrings = this.getSharedQueryMap(batchConfig);
        }
        catch (SQLException e1) {
            throw new BatchContainerServiceException((Throwable)e1);
        }
        try {
            if (!this.isSchemaValid()) {
                this.setDefaultSchema();
            }
            this.checkTables();
        }
        catch (SQLException e) {
            logger.severe(e.getLocalizedMessage());
            throw new BatchContainerServiceException((Throwable)e);
        }
        try {
            this.requestTracing = (RequestTracingService)Globals.getDefaultHabitat().getService(RequestTracingService.class, new Annotation[0]);
        }
        catch (NullPointerException ex) {
            logger.log(Level.INFO, "Error retrieving Request Tracing service during initialisation of JBatchJDBCPersistenceManager - NullPointerException");
        }
        logger.config("Exiting CLASSNAME.init()");
    }

    public CheckpointData getCheckpointData(CheckpointDataKey key) {
        logger.entering(CLASSNAME, "getCheckpointData", key == null ? NULL_TAGGED : key);
        CheckpointData checkpointData = key == null ? null : this.queryCheckpointData(key.getCommaSeparatedKey());
        logger.exiting(CLASSNAME, "getCheckpointData", checkpointData == null ? NULL_TAGGED : checkpointData);
        return checkpointData;
    }

    public void updateCheckpointData(CheckpointDataKey key, CheckpointData value) {
        logger.entering(CLASSNAME, "updateCheckpointData", new Object[]{key, value});
        CheckpointData data = this.queryCheckpointData(key.getCommaSeparatedKey());
        if (data != null) {
            this.updateCheckpointData(key.getCommaSeparatedKey(), value);
        } else {
            this.createCheckpointData(key, value);
        }
        logger.exiting(CLASSNAME, "updateCheckpointData");
    }

    public void createCheckpointData(CheckpointDataKey key, CheckpointData value) {
        logger.entering(CLASSNAME, "createCheckpointData", new Object[]{key, value});
        this.insertCheckpointData(key.getCommaSeparatedKey(), value);
        logger.exiting(CLASSNAME, "createCheckpointData");
    }

    public String setDefaultSchema() throws SQLException {
        logger.finest("Entering setDefaultSchema");
        logger.finest(JAVA_EE_MODE);
        try (Connection connection = this.dataSource.getConnection();){
            DatabaseMetaData dbmd = connection.getMetaData();
            this.schema = dbmd.getUserName();
            String databaseProductName = dbmd.getDatabaseProductName().toLowerCase();
            if (databaseProductName.contains("mysql")) {
                this.schema = "test";
            } else if (databaseProductName.contains("postgres")) {
                this.schema = "public";
            } else if (databaseProductName.contains("h2")) {
                this.schema = "PUBLIC";
            }
        }
        catch (SQLException e) {
            logger.severe(e.getLocalizedMessage());
            throw e;
        }
        logger.finest("Exiting setDefaultSchema");
        return this.schema;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isSchemaValid() throws SQLException {
        logger.entering(CLASSNAME, "isH2SchemaValid");
        try (Connection connection = this.getConnectionToDefaultSchema();
             ResultSet rs = connection.getMetaData().getSchemas();){
            while (rs.next()) {
                if (!this.schema.equalsIgnoreCase(rs.getString("TABLE_SCHEM"))) continue;
                logger.exiting(CLASSNAME, "isSchemaValid", true);
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException e) {
            logger.severe(e.getLocalizedMessage());
            throw e;
        }
        logger.exiting(CLASSNAME, "isH2SchemaValid", false);
        return false;
    }

    protected void checkTables() throws SQLException {
        this.setCreateH2StringsMap(this.tableNames);
        this.createTableIfNotExists(this.tableNames.get("CHECKPOINT_TABLE_KEY"), this.createH2Strings.get("H2_CREATE_TABLE_CHECKPOINTDATA"));
        this.createTableIfNotExists(this.tableNames.get("JOB_INSTANCE_TABLE_KEY"), this.createH2Strings.get("H2_CREATE_TABLE_JOBINSTANCEDATA"));
        this.createTableIfNotExists(this.tableNames.get("EXECUTION_INSTANCE_TABLE_KEY"), this.createH2Strings.get("H2_CREATE_TABLE_EXECUTIONINSTANCEDATA"));
        this.createTableIfNotExists(this.tableNames.get("STEP_EXECUTION_INSTANCE_TABLE_KEY"), this.createH2Strings.get("H2_CREATE_TABLE_STEPINSTANCEDATA"));
        this.createTableIfNotExists(this.tableNames.get("JOB_STATUS_TABLE_KEY"), this.createH2Strings.get("H2_CREATE_TABLE_JOBSTATUS"));
        this.createTableIfNotExists(this.tableNames.get("STEP_STATUS_TABLE_KEY"), this.createH2Strings.get("H2_CREATE_TABLE_STEPSTATUS"));
    }

    public void createTables(DataSource dataSource, BatchRuntimeConfiguration batchRuntimeConfiguration) {
        this.dataSource = dataSource;
        this.prefix = batchRuntimeConfiguration.getTablePrefix();
        this.suffix = batchRuntimeConfiguration.getTableSuffix();
        this.schema = batchRuntimeConfiguration.getSchemaName();
        this.tableNames = this.getSharedTableMap();
        try {
            if (!this.isSchemaValid()) {
                this.setDefaultSchema();
            }
            this.checkTables();
        }
        catch (SQLException ex) {
            logger.severe(ex.getLocalizedMessage());
        }
    }

    protected void createTableIfNotExists(String tableName, String createTableStatement) throws SQLException {
        block29: {
            logger.entering(CLASSNAME, "createTableIfNotExists", new Object[]{tableName, createTableStatement});
            try (Connection connection = this.getConnection();){
                if (this.checkIfTableExists(this.dataSource, tableName, this.schema)) break block29;
                logger.log(Level.INFO, "{0} table does not exists. Trying to create it.", tableName);
                try (PreparedStatement statement = connection.prepareStatement(createTableStatement);){
                    statement.executeUpdate();
                }
            }
            catch (SQLException e) {
                logger.severe(e.getLocalizedMessage());
                throw e;
            }
            finally {
                logger.exiting(CLASSNAME, "createTableIfNotExists");
            }
        }
    }

    public boolean checkIfTableExists(DataSource dSource, String tableName, String schemaName) {
        boolean result = true;
        this.dataSource = dSource;
        try (Connection connection = this.dataSource.getConnection();){
            this.schema = schemaName;
            if (!this.isSchemaValid()) {
                this.setDefaultSchema();
            }
            try (ResultSet resultSet = connection.getMetaData().getTables(null, this.schema, tableName.toUpperCase(), null);){
                if (!resultSet.next()) {
                    result = false;
                }
            }
        }
        catch (SQLException e) {
            logger.severe(e.getLocalizedMessage());
        }
        return result;
    }

    public int getTableRowCount(ResultSet resultSet) throws SQLException {
        int rowcount = 0;
        try {
            if (resultSet.last()) {
                rowcount = resultSet.getRow();
                resultSet.beforeFirst();
            }
        }
        catch (SQLException e) {
            logger.severe(e.getLocalizedMessage());
            throw e;
        }
        return rowcount;
    }

    protected void executeStatement(String statement) throws SQLException {
        logger.entering(CLASSNAME, "executeStatement", statement);
        try (Connection connection = this.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(statement);){
            preparedStatement.executeUpdate();
        }
        catch (SQLException e) {
            logger.severe(e.getLocalizedMessage());
            throw e;
        }
        logger.exiting(CLASSNAME, "executeStatement");
    }

    protected Connection getConnection() throws SQLException {
        logger.log(Level.FINEST, "Entering: {0}.getConnection", CLASSNAME);
        logger.finest(JAVA_EE_MODE);
        Connection connection = this.dataSource.getConnection();
        logger.log(Level.FINEST, "autocommit={0}", connection.getAutoCommit());
        this.setSchemaOnConnection(connection);
        logger.log(Level.FINEST, "Exiting: {0}.getConnection() with connection ={1}", new Object[]{CLASSNAME, connection});
        return connection;
    }

    protected Connection getConnectionToDefaultSchema() throws SQLException {
        logger.finest("Entering getConnectionToDefaultSchema");
        Connection connection = null;
        logger.finest(JAVA_EE_MODE);
        try {
            connection = this.dataSource.getConnection();
        }
        catch (SQLException e) {
            this.logException("FAILED GETTING DATABASE CONNECTION", e);
            throw new PersistenceException((Throwable)e);
        }
        logger.log(Level.FINEST, "autocommit={0}", connection.getAutoCommit());
        logger.log(Level.FINEST, "Exiting from getConnectionToDefaultSchema, conn= {0}", connection);
        return connection;
    }

    protected void logException(String msg, Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        logger.log(Level.SEVERE, "{0}; Exception stack trace: {1}", new Object[]{msg, sw});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setSchemaOnConnection(Connection connection) throws SQLException {
        logger.log(Level.FINEST, "Entering {0}.setSchemaOnConnection()", CLASSNAME);
        if (!connection.getMetaData().getDatabaseProductName().contains("Oracle")) {
            try (PreparedStatement preparedStatement = connection.prepareStatement("SET SCHEMA " + this.schema);){
                preparedStatement.executeUpdate();
            }
            finally {
                logger.log(Level.FINEST, "Exiting {0}.setSchemaOnConnection()", CLASSNAME);
            }
        }
    }

    protected CheckpointData queryCheckpointData(Object key) {
        logger.entering(CLASSNAME, "queryCheckpointData", new Object[]{key, "SELECT_CHECKPOINTDATA"});
        CheckpointData data = null;
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(this.queryStrings.get("SELECT_CHECKPOINTDATA"));){
            statement.setObject(1, key);
            try (ResultSet resultSet = statement.executeQuery();){
                if (resultSet.next()) {
                    data = (CheckpointData)this.deserializeObject(resultSet.getBytes("obj"));
                }
            }
        }
        catch (IOException | ClassNotFoundException | SQLException e) {
            throw new PersistenceException((Throwable)e);
        }
        logger.exiting(CLASSNAME, "queryCheckpointData");
        return data;
    }

    protected <T> void insertCheckpointData(Object key, T value) {
        logger.entering(CLASSNAME, "insertCheckpointData", new Object[]{key, value});
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(this.queryStrings.get("INSERT_CHECKPOINTDATA"));){
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try (ObjectOutputStream oout = new ObjectOutputStream(baos);){
                oout.writeObject(value);
                statement.setObject(1, key);
                statement.setBytes(2, baos.toByteArray());
                statement.executeUpdate();
            }
        }
        catch (IOException | SQLException e) {
            throw new PersistenceException((Throwable)e);
        }
        logger.exiting(CLASSNAME, "insertCheckpointData");
    }

    protected void updateCheckpointData(Object key, CheckpointData value) {
        logger.entering(CLASSNAME, "updateCheckpointData", new Object[]{key, value});
        try (Connection conn = this.getConnection();
             PreparedStatement statement = conn.prepareStatement(this.queryStrings.get("UPDATE_CHECKPOINTDATA"));
             ByteArrayOutputStream baos = new ByteArrayOutputStream();
             ObjectOutputStream oout = new ObjectOutputStream(baos);){
            oout.writeObject(value);
            byte[] b = baos.toByteArray();
            statement.setBytes(1, b);
            statement.setObject(2, key);
            statement.executeUpdate();
        }
        catch (IOException | SQLException e) {
            logger.severe(e.getLocalizedMessage());
            throw new PersistenceException((Throwable)e);
        }
        logger.exiting(CLASSNAME, "updateCheckpointData");
    }

    protected void cleanupConnection(Connection conn, ResultSet rs, PreparedStatement statement) {
        logger.logp(Level.FINEST, CLASSNAME, "cleanupConnection", "Entering", new Object[]{conn, rs == null ? NULL_TAGGED : rs, statement == null ? NULL_TAGGED : statement});
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException e) {
                throw new PersistenceException((Throwable)e);
            }
        }
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                throw new PersistenceException((Throwable)e);
            }
        }
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                throw new PersistenceException((Throwable)e);
            }
            finally {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    throw new PersistenceException((Throwable)e);
                }
            }
        }
        logger.logp(Level.FINEST, CLASSNAME, "cleanupConnection", "Exiting");
    }

    protected void cleanupConnection(Connection conn, PreparedStatement statement) {
        logger.logp(Level.FINEST, CLASSNAME, "cleanupConnection", "Entering", new Object[]{conn, statement});
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException e) {
                throw new PersistenceException((Throwable)e);
            }
        }
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                throw new PersistenceException((Throwable)e);
            }
            finally {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    throw new PersistenceException((Throwable)e);
                }
            }
        }
        logger.logp(Level.FINEST, CLASSNAME, "cleanupConnection", "Exiting");
    }

    public int jobOperatorGetJobInstanceCount(String jobName, String appTag) {
        int count;
        try (Connection conn = this.getConnection();
             PreparedStatement statement = conn.prepareStatement(this.queryStrings.get("JOBOPERATOR_GET_JOB_INSTANCE_COUNT"));){
            statement.setString(1, jobName);
            statement.setString(2, appTag);
            try (ResultSet rs = statement.executeQuery();){
                rs.next();
                count = rs.getInt("jobinstancecount");
            }
        }
        catch (SQLException e) {
            logger.severe(e.getLocalizedMessage());
            throw new PersistenceException((Throwable)e);
        }
        return count;
    }

    public int jobOperatorGetJobInstanceCount(String jobName) {
        int count;
        try (Connection conn = this.getConnection();
             PreparedStatement statement = conn.prepareStatement(this.queryStrings.get("SELECT_JOBINSTANCEDATA_COUNT"));){
            statement.setString(1, jobName);
            try (ResultSet rs = statement.executeQuery();){
                rs.next();
                count = rs.getInt("jobinstancecount");
            }
        }
        catch (SQLException e) {
            throw new PersistenceException((Throwable)e);
        }
        return count;
    }

    public List<Long> jobOperatorGetJobInstanceIds(String jobName, String appTag, int start, int count) {
        ArrayList<Long> data = new ArrayList<Long>();
        try (Connection conn = this.getConnection();
             PreparedStatement statement = conn.prepareStatement(this.queryStrings.get("JOBOPERATOR_GET_JOB_INSTANCE_IDS"));){
            statement.setObject(1, jobName);
            statement.setObject(2, appTag);
            try (ResultSet rs = statement.executeQuery();){
                while (rs.next()) {
                    long id = rs.getLong("jobinstanceid");
                    data.add(id);
                }
            }
        }
        catch (SQLException e) {
            throw new PersistenceException((Throwable)e);
        }
        if (!data.isEmpty()) {
            try {
                return data.subList(start, start + count);
            }
            catch (IndexOutOfBoundsException oobEx) {
                return data.subList(start, data.size());
            }
        }
        return data;
    }

    public List<Long> jobOperatorGetJobInstanceIds(String jobName, int start, int count) {
        ArrayList<Long> data = new ArrayList<Long>();
        try (Connection conn = this.getConnection();
             PreparedStatement statement = conn.prepareStatement(this.queryStrings.get("SELECT_JOBINSTANCEDATA_IDS"));){
            statement.setObject(1, jobName);
            try (ResultSet rs = statement.executeQuery();){
                while (rs.next()) {
                    long id = rs.getLong("jobinstanceid");
                    data.add(id);
                }
            }
        }
        catch (SQLException e) {
            throw new PersistenceException((Throwable)e);
        }
        if (!data.isEmpty()) {
            try {
                return data.subList(start, start + count);
            }
            catch (IndexOutOfBoundsException oobEx) {
                return data.subList(start, data.size());
            }
        }
        return data;
    }

    public Map<Long, String> jobOperatorGetExternalJobInstanceData() {
        HashMap<Long, String> data = new HashMap<Long, String>();
        String filter = "not like ':%'";
        try (Connection conn = this.getConnection();
             PreparedStatement statement = conn.prepareStatement(this.queryStrings.get("JOB_OPERATOR_GET_EXTERNAL_JOB_INSTANCE_DATA") + "not like ':%'");
             ResultSet rs = statement.executeQuery();){
            while (rs.next()) {
                long id = rs.getLong("jobinstanceid");
                String name = rs.getString("name");
                data.put(id, name);
            }
        }
        catch (SQLException e) {
            throw new PersistenceException((Throwable)e);
        }
        return data;
    }

    public Timestamp jobOperatorQueryJobExecutionTimestamp(long key, IPersistenceManagerService.TimestampType timestampType) {
        Timestamp createTimestamp = null;
        Timestamp endTimestamp = null;
        Timestamp updateTimestamp = null;
        Timestamp startTimestamp = null;
        try (Connection conn = this.getConnection();
             PreparedStatement statement = conn.prepareStatement(this.queryStrings.get("JOB_OPERATOR_QUERY_JOB_EXECUTION_TIMESTAMP"));){
            statement.setObject(1, key);
            try (ResultSet rs = statement.executeQuery();){
                while (rs.next()) {
                    createTimestamp = rs.getTimestamp(1);
                    endTimestamp = rs.getTimestamp(2);
                    updateTimestamp = rs.getTimestamp(3);
                    startTimestamp = rs.getTimestamp(4);
                }
            }
        }
        catch (SQLException e) {
            throw new PersistenceException((Throwable)e);
        }
        switch (timestampType) {
            case CREATE: {
                return createTimestamp;
            }
            case END: {
                return endTimestamp;
            }
            case LAST_UPDATED: {
                return updateTimestamp;
            }
            case STARTED: {
                return startTimestamp;
            }
        }
        throw new IllegalArgumentException("Unexpected enum value.");
    }

    public String jobOperatorQueryJobExecutionBatchStatus(long key) {
        String status = null;
        try (Connection conn = this.getConnection();
             PreparedStatement statement = conn.prepareStatement(this.queryStrings.get("JOB_OPERATOR_QUERY_JOB_EXECUTION_BATCH_STATUS"));){
            statement.setLong(1, key);
            try (ResultSet rs = statement.executeQuery();){
                while (rs.next()) {
                    status = rs.getString(1);
                }
            }
        }
        catch (SQLException e) {
            throw new PersistenceException((Throwable)e);
        }
        return status;
    }

    public String jobOperatorQueryJobExecutionExitStatus(long key) {
        String status = null;
        try (Connection conn = this.getConnection();
             PreparedStatement statement = conn.prepareStatement(this.queryStrings.get("JOB_OPERATOR_QUERY_JOB_EXECUTION_EXIT_STATUS"));){
            statement.setLong(1, key);
            try (ResultSet rs = statement.executeQuery();){
                while (rs.next()) {
                    status = rs.getString(1);
                }
            }
        }
        catch (SQLException e) {
            throw new PersistenceException((Throwable)e);
        }
        return status;
    }

    public long jobOperatorQueryJobExecutionJobInstanceId(long executionID) throws NoSuchJobExecutionException {
        long jobinstanceID;
        block39: {
            jobinstanceID = 0L;
            try (Connection conn = this.getConnection();
                 PreparedStatement statement = conn.prepareStatement(this.queryStrings.get("JOB_OPERATOR_QUERY_JOB_EXECUTION_JOB_ID"));){
                statement.setLong(1, executionID);
                try (ResultSet rs = statement.executeQuery();){
                    if (rs.next()) {
                        jobinstanceID = rs.getLong("jobinstanceid");
                        break block39;
                    }
                    String msg = "Did not find job instance associated with executionID =" + executionID;
                    logger.fine(msg);
                    throw new NoSuchJobExecutionException(msg);
                }
            }
            catch (SQLException e) {
                throw new PersistenceException((Throwable)e);
            }
        }
        return jobinstanceID;
    }

    public Properties getParameters(long executionId) throws NoSuchJobExecutionException {
        Properties props;
        block39: {
            props = null;
            try (Connection conn = this.getConnection();
                 PreparedStatement statement = conn.prepareStatement(this.queryStrings.get("GET_PARAMETERS"));){
                statement.setLong(1, executionId);
                try (ResultSet rs = statement.executeQuery();){
                    if (rs.next()) {
                        byte[] buf = rs.getBytes("parameters");
                        props = (Properties)this.deserializeObject(buf);
                        break block39;
                    }
                    String msg = "Did not find table entry for executionID =" + executionId;
                    logger.fine(msg);
                    throw new NoSuchJobExecutionException(msg);
                }
            }
            catch (IOException | ClassNotFoundException | SQLException e) {
                throw new PersistenceException((Throwable)e);
            }
        }
        return props;
    }

    public Map<String, StepExecution> getMostRecentStepExecutionsForJobInstance(long instanceId) {
        HashMap<String, StepExecution> data = new HashMap<String, StepExecution>();
        try (Connection conn = this.getConnection();
             PreparedStatement statement = conn.prepareStatement(this.queryStrings.get("MOST_RECENT_STEPS_FOR_JOB"));){
            statement.setLong(1, instanceId);
            try (ResultSet rs = statement.executeQuery();){
                while (rs.next()) {
                    String stepname = null;
                    stepname = rs.getString("stepname");
                    if (data.containsKey(stepname)) continue;
                    long jobexecid = rs.getLong("jobexecid");
                    long stepexecid = rs.getLong("stepexecid");
                    String batchstatus = rs.getString("batchstatus");
                    String exitstatus = rs.getString("exitstatus");
                    long readCount = rs.getLong("readcount");
                    long writeCount = rs.getLong("writecount");
                    long commitCount = rs.getLong("commitcount");
                    long rollbackCount = rs.getLong("rollbackcount");
                    long readSkipCount = rs.getLong("readskipcount");
                    long processSkipCount = rs.getLong("processskipcount");
                    long filterCount = rs.getLong("filtercount");
                    long writeSkipCount = rs.getLong("writeSkipCount");
                    Timestamp startTS = rs.getTimestamp("startTime");
                    Timestamp endTS = rs.getTimestamp("endTime");
                    Serializable persistentData = null;
                    byte[] pDataBytes = rs.getBytes("persistentData");
                    if (pDataBytes != null) {
                        try (TCCLObjectInputStream objectIn = new TCCLObjectInputStream((InputStream)new ByteArrayInputStream(pDataBytes));){
                            persistentData = (Serializable)objectIn.readObject();
                        }
                    }
                    StepExecutionImpl stepEx = new StepExecutionImpl(jobexecid, stepexecid);
                    stepEx.setBatchStatus(BatchStatus.valueOf((String)batchstatus));
                    stepEx.setExitStatus(exitstatus);
                    stepEx.setStepName(stepname);
                    stepEx.setReadCount(readCount);
                    stepEx.setWriteCount(writeCount);
                    stepEx.setCommitCount(commitCount);
                    stepEx.setRollbackCount(rollbackCount);
                    stepEx.setReadSkipCount(readSkipCount);
                    stepEx.setProcessSkipCount(processSkipCount);
                    stepEx.setFilterCount(filterCount);
                    stepEx.setWriteSkipCount(writeSkipCount);
                    stepEx.setStartTime(startTS);
                    stepEx.setEndTime(endTS);
                    stepEx.setPersistentUserData(persistentData);
                    data.put(stepname, (StepExecution)stepEx);
                }
            }
        }
        catch (IOException | ClassNotFoundException | SQLException e) {
            throw new PersistenceException((Throwable)e);
        }
        return data;
    }

    public List<StepExecution> getStepExecutionsForJobExecution(long execid) {
        ArrayList<StepExecution> data = new ArrayList<StepExecution>();
        try (Connection conn = this.getConnection();
             PreparedStatement statement = conn.prepareStatement(this.queryStrings.get("STEP_EXECUTIONS_FOR_JOB_EXECUTION"));){
            statement.setLong(1, execid);
            try (ResultSet rs = statement.executeQuery();){
                while (rs.next()) {
                    long jobexecid = rs.getLong("jobexecid");
                    long stepexecid = rs.getLong("stepexecid");
                    String stepname = rs.getString("stepname");
                    String batchstatus = rs.getString("batchstatus");
                    String exitstatus = rs.getString("exitstatus");
                    long readCount = rs.getLong("readcount");
                    long writeCount = rs.getLong("writecount");
                    long commitCount = rs.getLong("commitcount");
                    long rollbackCount = rs.getLong("rollbackcount");
                    long readSkipCount = rs.getLong("readskipcount");
                    long processSkipCount = rs.getLong("processskipcount");
                    long filterCount = rs.getLong("filtercount");
                    long writeSkipCount = rs.getLong("writeSkipCount");
                    Timestamp startTS = rs.getTimestamp("startTime");
                    Timestamp endTS = rs.getTimestamp("endTime");
                    Serializable persistentData = null;
                    byte[] pDataBytes = rs.getBytes("persistentData");
                    if (pDataBytes != null) {
                        try (TCCLObjectInputStream objectIn = new TCCLObjectInputStream((InputStream)new ByteArrayInputStream(pDataBytes));){
                            persistentData = (Serializable)objectIn.readObject();
                        }
                    }
                    StepExecutionImpl stepEx = new StepExecutionImpl(jobexecid, stepexecid);
                    stepEx.setBatchStatus(BatchStatus.valueOf((String)batchstatus));
                    stepEx.setExitStatus(exitstatus);
                    stepEx.setStepName(stepname);
                    stepEx.setReadCount(readCount);
                    stepEx.setWriteCount(writeCount);
                    stepEx.setCommitCount(commitCount);
                    stepEx.setRollbackCount(rollbackCount);
                    stepEx.setReadSkipCount(readSkipCount);
                    stepEx.setProcessSkipCount(processSkipCount);
                    stepEx.setFilterCount(filterCount);
                    stepEx.setWriteSkipCount(writeSkipCount);
                    stepEx.setStartTime(startTS);
                    stepEx.setEndTime(endTS);
                    stepEx.setPersistentUserData(persistentData);
                    logger.log(Level.FINE, "BatchStatus: {0} | StepName: {1} | JobExecID: {2} | StepExecID: {3}", new Object[]{batchstatus, stepname, jobexecid, stepexecid});
                    data.add((StepExecution)stepEx);
                }
            }
        }
        catch (IOException | ClassNotFoundException | SQLException e) {
            throw new PersistenceException((Throwable)e);
        }
        return data;
    }

    public StepExecution getStepExecutionByStepExecutionId(long stepExecId) {
        StepExecutionImpl stepEx = null;
        try (Connection conn = this.getConnection();
             PreparedStatement statement = conn.prepareStatement(this.queryStrings.get("STEP_EXECUTIONS_BY_STEP_ID"));){
            statement.setLong(1, stepExecId);
            try (ResultSet rs = statement.executeQuery();){
                while (rs.next()) {
                    long jobexecid = rs.getLong("jobexecid");
                    long stepexecid = rs.getLong("stepexecid");
                    String stepname = rs.getString("stepname");
                    String batchstatus = rs.getString("batchstatus");
                    String exitstatus = rs.getString("exitstatus");
                    long readCount = rs.getLong("readcount");
                    long writeCount = rs.getLong("writecount");
                    long commitCount = rs.getLong("commitcount");
                    long rollbackCount = rs.getLong("rollbackcount");
                    long readSkipCount = rs.getLong("readskipcount");
                    long processSkipCount = rs.getLong("processskipcount");
                    long filterCount = rs.getLong("filtercount");
                    long writeSkipCount = rs.getLong("writeSkipCount");
                    Timestamp startTS = rs.getTimestamp("startTime");
                    Timestamp endTS = rs.getTimestamp("endTime");
                    Serializable persistentData = null;
                    byte[] pDataBytes = rs.getBytes("persistentData");
                    if (pDataBytes != null) {
                        try (TCCLObjectInputStream objectIn = new TCCLObjectInputStream((InputStream)new ByteArrayInputStream(pDataBytes));){
                            persistentData = (Serializable)objectIn.readObject();
                        }
                    }
                    stepEx = new StepExecutionImpl(jobexecid, stepexecid);
                    stepEx.setBatchStatus(BatchStatus.valueOf((String)batchstatus));
                    stepEx.setExitStatus(exitstatus);
                    stepEx.setStepName(stepname);
                    stepEx.setReadCount(readCount);
                    stepEx.setWriteCount(writeCount);
                    stepEx.setCommitCount(commitCount);
                    stepEx.setRollbackCount(rollbackCount);
                    stepEx.setReadSkipCount(readSkipCount);
                    stepEx.setProcessSkipCount(processSkipCount);
                    stepEx.setFilterCount(filterCount);
                    stepEx.setWriteSkipCount(writeSkipCount);
                    stepEx.setStartTime(startTS);
                    stepEx.setEndTime(endTS);
                    stepEx.setPersistentUserData(persistentData);
                    logger.log(Level.FINE, "stepExecution BatchStatus: {0} StepName: {1}", new Object[]{batchstatus, stepname});
                }
            }
        }
        catch (IOException | ClassNotFoundException | SQLException e) {
            throw new PersistenceException((Throwable)e);
        }
        return stepEx;
    }

    public void updateBatchStatusOnly(long key, BatchStatus batchStatus, Timestamp updates) {
        try (Connection conn = this.getConnection();
             PreparedStatement statement = conn.prepareStatement(this.queryStrings.get("UPDATE_BATCH_STATUS_ONLY"));){
            statement.setString(1, batchStatus.name());
            statement.setTimestamp(2, updates);
            statement.setLong(3, key);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public void updateWithFinalExecutionStatusesAndTimestamps(long key, BatchStatus batchStatus, String exitStatus, Timestamp updates) {
        try (Connection conn = this.getConnection();
             PreparedStatement statement = conn.prepareStatement(this.queryStrings.get("UPDATE_FINAL_STATUS_AND_TIMESTAMP"));){
            statement.setString(1, batchStatus.name());
            statement.setString(2, exitStatus);
            statement.setTimestamp(3, updates);
            statement.setTimestamp(4, updates);
            statement.setLong(5, key);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public void markJobStarted(long key, Timestamp startTS) {
        try (Connection conn = this.getConnection();
             PreparedStatement statement = conn.prepareStatement(this.queryStrings.get("MARK_JOB_STARTED"));){
            statement.setString(1, BatchStatus.STARTED.name());
            statement.setTimestamp(2, startTS);
            statement.setTimestamp(3, startTS);
            statement.setLong(4, key);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public IJobExecution jobOperatorGetJobExecution(long jobExecutionId) {
        IJobExecution jobEx;
        try (Connection conn = this.getConnection();
             PreparedStatement statement = conn.prepareStatement(this.queryStrings.get("JOB_OPERATOR_GET_JOB_EXECUTION"));){
            statement.setLong(1, jobExecutionId);
            try (ResultSet rs = statement.executeQuery();){
                jobEx = rs.next() ? this.readJobExecutionRecord(rs) : null;
            }
        }
        catch (IOException | ClassNotFoundException | SQLException e) {
            throw new PersistenceException((Throwable)e);
        }
        return jobEx;
    }

    public List<IJobExecution> jobOperatorGetJobExecutions(long jobInstanceId) {
        ArrayList<IJobExecution> data = new ArrayList<IJobExecution>();
        try (Connection conn = this.getConnection();
             PreparedStatement statement = conn.prepareStatement(this.queryStrings.get("JOB_OPERATOR_GET_JOB_EXECUTIONS"));){
            statement.setLong(1, jobInstanceId);
            try (ResultSet rs = statement.executeQuery();){
                while (rs.next()) {
                    data.add(this.readJobExecutionRecord(rs));
                }
            }
        }
        catch (IOException | ClassNotFoundException | SQLException e) {
            throw new PersistenceException((Throwable)e);
        }
        return data;
    }

    protected IJobExecution readJobExecutionRecord(ResultSet rs) throws SQLException, IOException, ClassNotFoundException {
        if (rs == null) {
            return null;
        }
        JobOperatorJobExecution retMe = new JobOperatorJobExecution(rs.getLong("jobexecid"), rs.getLong("jobinstanceid"));
        retMe.setCreateTime(rs.getTimestamp("createtime"));
        retMe.setStartTime(rs.getTimestamp("starttime"));
        retMe.setEndTime(rs.getTimestamp("endtime"));
        retMe.setLastUpdateTime(rs.getTimestamp("updatetime"));
        retMe.setJobParameters((Properties)this.deserializeObject(rs.getBytes("parameters")));
        retMe.setBatchStatus(rs.getString("batchstatus"));
        retMe.setExitStatus(rs.getString("exitstatus"));
        retMe.setJobName(rs.getString("name"));
        return retMe;
    }

    public Set<Long> jobOperatorGetRunningExecutions(String jobName) {
        HashSet<Long> executionIds = new HashSet<Long>();
        try (Connection conn = this.getConnection();
             PreparedStatement statement = conn.prepareStatement(this.queryStrings.get("JOB_OPERATOR_GET_RUNNING_EXECUTIONS"));){
            statement.setString(1, BatchStatus.STARTED.name());
            statement.setString(2, BatchStatus.STARTING.name());
            statement.setString(3, BatchStatus.STOPPING.name());
            statement.setString(4, jobName);
            try (ResultSet rs = statement.executeQuery();){
                while (rs.next()) {
                    executionIds.add(rs.getLong("jobexecid"));
                }
            }
        }
        catch (SQLException e) {
            throw new PersistenceException((Throwable)e);
        }
        return executionIds;
    }

    public String getJobCurrentTag(long jobInstanceId) {
        String apptag = null;
        try (Connection conn = this.getConnection();
             PreparedStatement statement = conn.prepareStatement(this.queryStrings.get("SELECT_JOBINSTANCEDATA_APPTAG"));){
            statement.setLong(1, jobInstanceId);
            try (ResultSet rs = statement.executeQuery();){
                while (rs.next()) {
                    apptag = rs.getString("apptag");
                }
            }
        }
        catch (SQLException e) {
            throw new PersistenceException((Throwable)e);
        }
        return apptag;
    }

    public void purge(String apptag) {
        logger.entering(CLASSNAME, "purge", apptag);
        String deleteJobs = this.queryStrings.get("DELETE_JOBS");
        String deleteJobExecutions = this.queryStrings.get("DELETE_JOB_EXECUTIONS");
        String deleteStepExecutions = this.queryStrings.get("DELETE_STEP_EXECUTIONS");
        try (Connection conn = this.getConnection();){
            try (PreparedStatement statement = conn.prepareStatement(deleteStepExecutions);){
                statement.setString(1, apptag);
                statement.executeUpdate();
            }
            statement = conn.prepareStatement(deleteJobExecutions);
            var8_11 = null;
            try {
                statement.setString(1, apptag);
                statement.executeUpdate();
            }
            catch (Throwable throwable) {
                var8_11 = throwable;
                throw throwable;
            }
            finally {
                if (statement != null) {
                    if (var8_11 != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable) {
                            var8_11.addSuppressed(throwable);
                        }
                    } else {
                        statement.close();
                    }
                }
            }
            statement = conn.prepareStatement(deleteJobs);
            var8_11 = null;
            try {
                statement.setString(1, apptag);
                statement.executeUpdate();
            }
            catch (Throwable throwable) {
                var8_11 = throwable;
                throw throwable;
            }
            finally {
                if (statement != null) {
                    if (var8_11 != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable) {
                            var8_11.addSuppressed(throwable);
                        }
                    } else {
                        statement.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new PersistenceException((Throwable)e);
        }
        logger.exiting(CLASSNAME, "purge");
    }

    public JobStatus getJobStatusFromExecution(long executionId) {
        JobStatus retVal = null;
        try (Connection conn = this.getConnection();
             PreparedStatement statement = conn.prepareStatement(this.queryStrings.get("GET_JOB_STATUS_FROM_EXECUTIONS"));){
            statement.setLong(1, executionId);
            try (ResultSet rs = statement.executeQuery();){
                byte[] buf = null;
                if (rs.next()) {
                    buf = rs.getBytes("obj");
                }
                retVal = (JobStatus)this.deserializeObject(buf);
            }
        }
        catch (Exception e) {
            throw new PersistenceException((Throwable)e);
        }
        logger.exiting(CLASSNAME, "executeQuery");
        return retVal;
    }

    public long getJobInstanceIdByExecutionId(long executionId) throws NoSuchJobExecutionException {
        long instanceId;
        block39: {
            instanceId = 0L;
            try (Connection conn = this.getConnection();
                 PreparedStatement statement = conn.prepareStatement(this.queryStrings.get("JOB_INSTANCE_ID_BY_EXECUTION_ID"));){
                statement.setObject(1, executionId);
                try (ResultSet rs = statement.executeQuery();){
                    if (rs.next()) {
                        instanceId = rs.getLong("jobinstanceid");
                        break block39;
                    }
                    String msg = "Did not find job instance associated with executionID =" + executionId;
                    logger.fine(msg);
                    throw new NoSuchJobExecutionException(msg);
                }
            }
            catch (SQLException e) {
                throw new PersistenceException((Throwable)e);
            }
        }
        return instanceId;
    }

    /*
     * Exception decompiling
     */
    protected byte[] serializeObject(Serializable theObject) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected Serializable deserializeObject(byte[] buffer) throws IOException, ClassNotFoundException {
        Serializable theObject = null;
        if (buffer != null) {
            try (ObjectInputStream objectIn = new ObjectInputStream(new ByteArrayInputStream(buffer));){
                theObject = (Serializable)objectIn.readObject();
            }
        }
        return theObject;
    }

    public JobInstance createSubJobInstance(String name, String apptag) {
        JobInstanceImpl jobInstance = null;
        try (Connection conn = this.getConnection();
             PreparedStatement statement = conn.prepareStatement(this.queryStrings.get("CREATE_SUB_JOB_INSTANCE"), new String[]{"JOBINSTANCEID"});){
            statement.setString(1, name);
            statement.setString(2, apptag);
            statement.executeUpdate();
            try (ResultSet rs = statement.getGeneratedKeys();){
                if (rs.next()) {
                    long jobInstanceID = rs.getLong(1);
                    jobInstance = new JobInstanceImpl(jobInstanceID);
                    jobInstance.setJobName(name);
                }
            }
        }
        catch (SQLException e) {
            throw new PersistenceException((Throwable)e);
        }
        return jobInstance;
    }

    public JobInstance createJobInstance(String name, String apptag, String jobXml) {
        JobInstanceImpl jobInstance = null;
        try (Connection conn = this.getConnection();
             PreparedStatement statement = conn.prepareStatement(this.queryStrings.get("CREATE_JOB_INSTANCE"), new String[]{"JOBINSTANCEID"});){
            statement.setString(1, name);
            statement.setString(2, apptag);
            statement.executeUpdate();
            try (ResultSet rs = statement.getGeneratedKeys();){
                if (rs.next()) {
                    long jobInstanceID = rs.getLong(1);
                    jobInstance = new JobInstanceImpl(jobInstanceID, jobXml);
                    jobInstance.setJobName(name);
                }
            }
        }
        catch (SQLException e) {
            throw new PersistenceException((Throwable)e);
        }
        return jobInstance;
    }

    public RuntimeJobExecution createJobExecution(JobInstance jobInstance, Properties jobParameters, BatchStatus batchStatus) {
        Timestamp now = new Timestamp(System.currentTimeMillis());
        long newExecutionId = this.createRuntimeJobExecutionEntry(jobInstance, jobParameters, batchStatus, now);
        RuntimeJobExecution jobExecution = new RuntimeJobExecution(jobInstance, newExecutionId);
        jobExecution.setBatchStatus(batchStatus.name());
        jobExecution.setCreateTime(now);
        jobExecution.setLastUpdateTime(now);
        if (this.requestTracing != null && this.requestTracing.isRequestTracingEnabled() && this.requestTracing.isTraceInProgress()) {
            RequestTraceSpanLog spanLog = this.constructJBatchExecutionSpanLog(jobExecution);
            this.requestTracing.addSpanLog(spanLog);
        }
        return jobExecution;
    }

    protected long createRuntimeJobExecutionEntry(JobInstance jobInstance, Properties jobParameters, BatchStatus batchStatus, Timestamp timestamp) {
        long newJobExecutionId = 0L;
        try (Connection conn = this.getConnection();
             PreparedStatement statement = conn.prepareStatement(this.queryStrings.get("CREATE_JOB_EXECUTION_ENTRY"), new String[]{"JOBEXECID"});){
            statement.setLong(1, jobInstance.getInstanceId());
            statement.setTimestamp(2, timestamp);
            statement.setTimestamp(3, timestamp);
            statement.setString(4, batchStatus.name());
            statement.setObject(5, this.serializeObject(jobParameters));
            statement.executeUpdate();
            try (ResultSet rs = statement.getGeneratedKeys();){
                if (rs.next()) {
                    newJobExecutionId = rs.getLong(1);
                }
            }
        }
        catch (IOException | SQLException e) {
            throw new PersistenceException((Throwable)e);
        }
        return newJobExecutionId;
    }

    public RuntimeFlowInSplitExecution createFlowInSplitExecution(JobInstance jobInstance, BatchStatus batchStatus) {
        Timestamp now = new Timestamp(System.currentTimeMillis());
        long newExecutionId = this.createRuntimeJobExecutionEntry(jobInstance, null, batchStatus, now);
        RuntimeFlowInSplitExecution flowExecution = new RuntimeFlowInSplitExecution(jobInstance, newExecutionId);
        flowExecution.setBatchStatus(batchStatus.name());
        flowExecution.setCreateTime(now);
        flowExecution.setLastUpdateTime(now);
        return flowExecution;
    }

    public StepExecutionImpl createStepExecution(long rootJobExecId, StepContextImpl stepContext) {
        Metric[] metrics;
        StepExecutionImpl stepExecution = null;
        String batchStatus = stepContext.getBatchStatus() == null ? BatchStatus.STARTING.name() : stepContext.getBatchStatus().name();
        String exitStatus = stepContext.getExitStatus();
        String stepName = stepContext.getStepName();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "batchStatus: {0} | stepName: {1}", new Object[]{batchStatus, stepName});
        }
        long readCount = 0L;
        long writeCount = 0L;
        long commitCount = 0L;
        long rollbackCount = 0L;
        long readSkipCount = 0L;
        long processSkipCount = 0L;
        long filterCount = 0L;
        long writeSkipCount = 0L;
        Timestamp startTime = stepContext.getStartTimeTS();
        Timestamp endTime = stepContext.getEndTimeTS();
        block10: for (Metric metric : metrics = stepContext.getMetrics()) {
            switch (metric.getType()) {
                case READ_COUNT: {
                    readCount = metric.getValue();
                    continue block10;
                }
                case WRITE_COUNT: {
                    writeCount = metric.getValue();
                    continue block10;
                }
                case PROCESS_SKIP_COUNT: {
                    processSkipCount = metric.getValue();
                    continue block10;
                }
                case COMMIT_COUNT: {
                    commitCount = metric.getValue();
                    continue block10;
                }
                case ROLLBACK_COUNT: {
                    rollbackCount = metric.getValue();
                    continue block10;
                }
                case READ_SKIP_COUNT: {
                    readSkipCount = metric.getValue();
                    continue block10;
                }
                case FILTER_COUNT: {
                    filterCount = metric.getValue();
                    continue block10;
                }
                case WRITE_SKIP_COUNT: {
                    writeSkipCount = metric.getValue();
                    continue block10;
                }
            }
        }
        Serializable persistentData = stepContext.getPersistentUserData();
        stepExecution = this.createStepExecution(rootJobExecId, batchStatus, exitStatus, stepName, readCount, writeCount, commitCount, rollbackCount, readSkipCount, processSkipCount, filterCount, writeSkipCount, startTime, endTime, persistentData);
        return stepExecution;
    }

    protected StepExecutionImpl createStepExecution(long rootJobExecId, String batchStatus, String exitStatus, String stepName, long readCount, long writeCount, long commitCount, long rollbackCount, long readSkipCount, long processSkipCount, long filterCount, long writeSkipCount, Timestamp startTime, Timestamp endTime, Serializable persistentData) {
        logger.entering(CLASSNAME, "createStepExecution", new Object[]{rootJobExecId, batchStatus, exitStatus == null ? NULL_TAGGED : exitStatus, stepName, readCount, writeCount, commitCount, rollbackCount, readSkipCount, processSkipCount, filterCount, writeSkipCount, startTime == null ? NULL_TAGGED : startTime, endTime == null ? NULL_TAGGED : endTime, persistentData == null ? NULL_TAGGED : persistentData});
        StepExecutionImpl stepExecution = null;
        String query = this.queryStrings.get("CREATE_STEP_EXECUTION");
        try (Connection conn = this.getConnection();
             PreparedStatement statement = conn.prepareStatement(query, new String[]{"STEPEXECID"});){
            statement.setLong(1, rootJobExecId);
            statement.setString(2, batchStatus);
            statement.setString(3, exitStatus);
            statement.setString(4, stepName);
            statement.setLong(5, readCount);
            statement.setLong(6, writeCount);
            statement.setLong(7, commitCount);
            statement.setLong(8, rollbackCount);
            statement.setLong(9, readSkipCount);
            statement.setLong(10, processSkipCount);
            statement.setLong(11, filterCount);
            statement.setLong(12, writeSkipCount);
            statement.setTimestamp(13, startTime);
            statement.setTimestamp(14, endTime);
            statement.setObject(15, this.serializeObject(persistentData));
            statement.executeUpdate();
            try (ResultSet rs = statement.getGeneratedKeys();){
                if (rs.next()) {
                    long stepExecutionId = rs.getLong(1);
                    stepExecution = new StepExecutionImpl(rootJobExecId, stepExecutionId);
                    stepExecution.setStepName(stepName);
                }
            }
        }
        catch (IOException | SQLException e) {
            throw new PersistenceException((Throwable)e);
        }
        logger.exiting(CLASSNAME, "createStepExecution");
        return stepExecution;
    }

    public void updateStepExecution(StepContextImpl stepContext) {
        Metric[] metrics = stepContext.getMetrics();
        long readCount = 0L;
        long writeCount = 0L;
        long commitCount = 0L;
        long rollbackCount = 0L;
        long readSkipCount = 0L;
        long processSkipCount = 0L;
        long filterCount = 0L;
        long writeSkipCount = 0L;
        block10: for (Metric metric : metrics) {
            switch (metric.getType()) {
                case READ_COUNT: {
                    readCount = metric.getValue();
                    continue block10;
                }
                case WRITE_COUNT: {
                    writeCount = metric.getValue();
                    continue block10;
                }
                case PROCESS_SKIP_COUNT: {
                    processSkipCount = metric.getValue();
                    continue block10;
                }
                case COMMIT_COUNT: {
                    commitCount = metric.getValue();
                    continue block10;
                }
                case ROLLBACK_COUNT: {
                    rollbackCount = metric.getValue();
                    continue block10;
                }
                case READ_SKIP_COUNT: {
                    readSkipCount = metric.getValue();
                    continue block10;
                }
                case FILTER_COUNT: {
                    filterCount = metric.getValue();
                    continue block10;
                }
                case WRITE_SKIP_COUNT: {
                    writeSkipCount = metric.getValue();
                    continue block10;
                }
            }
        }
        this.updateStepExecutionWithMetrics(stepContext, readCount, writeCount, commitCount, rollbackCount, readSkipCount, processSkipCount, filterCount, writeSkipCount);
    }

    protected String getPartitionLevelJobInstanceWildCard(long rootJobExecutionId, String stepName) {
        long jobInstanceId = this.getJobInstanceIdByExecutionId(rootJobExecutionId);
        StringBuilder sb = new StringBuilder(":");
        sb.append(Long.toString(jobInstanceId));
        sb.append(":");
        sb.append(stepName);
        sb.append(":%");
        return sb.toString();
    }

    public void updateWithFinalPartitionAggregateStepExecution(long rootJobExecutionId, StepContextImpl stepContext) {
        long readCount = 0L;
        long writeCount = 0L;
        long commitCount = 0L;
        long rollbackCount = 0L;
        long readSkipCount = 0L;
        long processSkipCount = 0L;
        long filterCount = 0L;
        long writeSkipCount = 0L;
        try (Connection conn = this.getConnection();
             PreparedStatement statement = conn.prepareStatement(this.queryStrings.get("UPDATE_WITH_FINAL_PARTITION_STEP_EXECUTION"));){
            statement.setString(1, this.getPartitionLevelJobInstanceWildCard(rootJobExecutionId, stepContext.getStepName()));
            try (ResultSet rs = statement.executeQuery();){
                if (rs.next()) {
                    readCount = rs.getLong("readcount");
                    writeCount = rs.getLong("writecount");
                    commitCount = rs.getLong("commitcount");
                    rollbackCount = rs.getLong("rollbackcount");
                    readSkipCount = rs.getLong("readskipcount");
                    processSkipCount = rs.getLong("processskipcount");
                    filterCount = rs.getLong("filtercount");
                    writeSkipCount = rs.getLong("writeSkipCount");
                }
            }
        }
        catch (SQLException e) {
            throw new PersistenceException((Throwable)e);
        }
        this.updateStepExecutionWithMetrics(stepContext, readCount, writeCount, commitCount, rollbackCount, readSkipCount, processSkipCount, filterCount, writeSkipCount);
    }

    protected void updateStepExecutionWithMetrics(StepContextImpl stepContext, long readCount, long writeCount, long commitCount, long rollbackCount, long readSkipCount, long processSkipCount, long filterCount, long writeSkipCount) {
        long stepExecutionId = stepContext.getInternalStepExecutionId();
        String batchStatus = stepContext.getBatchStatus() == null ? BatchStatus.STARTING.name() : stepContext.getBatchStatus().name();
        String exitStatus = stepContext.getExitStatus();
        String stepName = stepContext.getStepName();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "batchStatus: {0} | stepName: {1} | stepExecID: {2}", new Object[]{batchStatus, stepName, stepContext.getStepExecutionId()});
        }
        Timestamp startTime = stepContext.getStartTimeTS();
        Timestamp endTime = stepContext.getEndTimeTS();
        Serializable persistentData = stepContext.getPersistentUserData();
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "About to update StepExecution with: ", new Object[]{stepExecutionId, batchStatus, exitStatus == null ? NULL_TAGGED : exitStatus, stepName, readCount, writeCount, commitCount, rollbackCount, readSkipCount, processSkipCount, filterCount, writeSkipCount, startTime == null ? NULL_TAGGED : startTime, endTime == null ? NULL_TAGGED : endTime, persistentData == null ? NULL_TAGGED : persistentData});
        }
        String query = this.queryStrings.get("UPDATE_STEP_EXECUTION_WITH_METRICS");
        try (Connection conn = this.getConnection();
             PreparedStatement statement = conn.prepareStatement(query);){
            statement.setString(1, batchStatus);
            statement.setString(2, exitStatus);
            statement.setString(3, stepName);
            statement.setLong(4, readCount);
            statement.setLong(5, writeCount);
            statement.setLong(6, commitCount);
            statement.setLong(7, rollbackCount);
            statement.setLong(8, readSkipCount);
            statement.setLong(9, processSkipCount);
            statement.setLong(10, filterCount);
            statement.setLong(11, writeSkipCount);
            statement.setTimestamp(12, startTime);
            statement.setTimestamp(13, endTime);
            statement.setObject(14, this.serializeObject(persistentData));
            statement.setLong(15, stepExecutionId);
            statement.executeUpdate();
        }
        catch (IOException | SQLException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public JobStatus createJobStatus(long jobInstanceId) {
        logger.entering(CLASSNAME, "createJobStatus", jobInstanceId);
        JobStatus jobStatus = new JobStatus(jobInstanceId);
        try (Connection conn = this.getConnection();
             PreparedStatement statement = conn.prepareStatement(this.queryStrings.get("CREATE_JOBSTATUS"));){
            statement.setLong(1, jobInstanceId);
            statement.setBytes(2, this.serializeObject((Serializable)jobStatus));
            statement.executeUpdate();
        }
        catch (IOException | SQLException e) {
            throw new PersistenceException((Throwable)e);
        }
        logger.exiting(CLASSNAME, "createJobStatus");
        return jobStatus;
    }

    public JobStatus getJobStatus(long instanceId) {
        logger.entering(CLASSNAME, "getJobStatus", instanceId);
        String query = this.queryStrings.get("GET_JOB_STATUS");
        JobStatus jobStatus = null;
        try (Connection conn = this.getConnection();
             PreparedStatement statement = conn.prepareStatement(query);){
            statement.setLong(1, instanceId);
            try (ResultSet rs = statement.executeQuery();){
                if (rs.next()) {
                    jobStatus = (JobStatus)this.deserializeObject(rs.getBytes(1));
                }
            }
        }
        catch (IOException | ClassNotFoundException | SQLException e) {
            throw new PersistenceException((Throwable)e);
        }
        logger.exiting(CLASSNAME, "getJobStatus", jobStatus);
        return jobStatus;
    }

    public void updateJobStatus(long instanceId, JobStatus jobStatus) {
        logger.entering(CLASSNAME, "updateJobStatus", new Object[]{instanceId, jobStatus});
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Updating Job Status to: {0}", jobStatus.getBatchStatus());
        }
        try (Connection conn = this.getConnection();
             PreparedStatement statement = conn.prepareStatement(this.queryStrings.get("UPDATE_JOBSTATUS"));){
            statement.setBytes(1, this.serializeObject((Serializable)jobStatus));
            statement.setLong(2, instanceId);
            statement.executeUpdate();
        }
        catch (IOException | SQLException e) {
            throw new PersistenceException((Throwable)e);
        }
        logger.exiting(CLASSNAME, "updateJobStatus");
    }

    public StepStatus createStepStatus(long stepExecId) {
        logger.entering(CLASSNAME, "createStepStatus", stepExecId);
        StepStatus stepStatus = new StepStatus(stepExecId);
        try (Connection conn = this.getConnection();
             PreparedStatement statement = conn.prepareStatement(this.queryStrings.get("CREATE_STEP_STATUS"));){
            statement.setLong(1, stepExecId);
            statement.setBytes(2, this.serializeObject((Serializable)stepStatus));
            statement.executeUpdate();
        }
        catch (IOException | SQLException e) {
            throw new PersistenceException((Throwable)e);
        }
        logger.exiting(CLASSNAME, "createStepStatus");
        return stepStatus;
    }

    public StepStatus getStepStatus(long instanceId, String stepName) {
        logger.entering(CLASSNAME, "getStepStatus", new Object[]{instanceId, stepName});
        String query = this.queryStrings.get("GET_STEP_STATUS");
        StepStatus stepStatus = null;
        try (Connection conn = this.getConnection();
             PreparedStatement statement = conn.prepareStatement(query);){
            statement.setLong(1, instanceId);
            statement.setString(2, stepName);
            try (ResultSet rs = statement.executeQuery();){
                if (rs.next()) {
                    stepStatus = (StepStatus)this.deserializeObject(rs.getBytes(1));
                }
            }
        }
        catch (IOException | ClassNotFoundException | SQLException e) {
            throw new PersistenceException((Throwable)e);
        }
        logger.exiting(CLASSNAME, "getStepStatus", stepStatus == null ? NULL_TAGGED : stepStatus);
        return stepStatus;
    }

    public void updateStepStatus(long stepExecutionId, StepStatus stepStatus) {
        logger.entering(CLASSNAME, "updateStepStatus", new Object[]{stepExecutionId, stepStatus});
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Updating StepStatus to: {0}", stepStatus.getBatchStatus());
        }
        try (Connection conn = this.getConnection();
             PreparedStatement statement = conn.prepareStatement(this.queryStrings.get("UPDATE_STEP_STATUS"));){
            statement.setBytes(1, this.serializeObject((Serializable)stepStatus));
            statement.setLong(2, stepExecutionId);
            statement.executeUpdate();
        }
        catch (IOException | SQLException e) {
            throw new PersistenceException((Throwable)e);
        }
        logger.exiting(CLASSNAME, "updateStepStatus");
    }

    public String getTagName(long jobExecutionId) {
        logger.entering(CLASSNAME, "getTagName", jobExecutionId);
        String apptag = null;
        String query = this.queryStrings.get("GET_TAGNAME");
        try (Connection conn = this.getConnection();
             PreparedStatement statement = conn.prepareStatement(query);){
            statement.setLong(1, jobExecutionId);
            try (ResultSet rs = statement.executeQuery();){
                if (rs.next()) {
                    apptag = rs.getString(1);
                }
            }
        }
        catch (SQLException e) {
            throw new PersistenceException((Throwable)e);
        }
        logger.exiting(CLASSNAME, "getTagName");
        return apptag;
    }

    public long getMostRecentExecutionId(long jobInstanceId) {
        logger.entering(CLASSNAME, "getMostRecentExecutionId", jobInstanceId);
        long mostRecentId = -1L;
        String query = this.queryStrings.get("GET_MOST_RECENT_EXECUTION_ID");
        try (Connection conn = this.getConnection();
             PreparedStatement statement = conn.prepareStatement(query);){
            statement.setLong(1, jobInstanceId);
            try (ResultSet rs = statement.executeQuery();){
                if (rs.next()) {
                    mostRecentId = rs.getLong(1);
                }
            }
        }
        catch (SQLException e) {
            throw new PersistenceException((Throwable)e);
        }
        logger.exiting(CLASSNAME, "getMostRecentExecutionId");
        return mostRecentId;
    }

    public void shutdown() throws BatchContainerServiceException {
    }

    protected Map<String, String> getSharedTableMap() {
        HashMap<String, String> result = new HashMap<String, String>(6);
        result.put("JOB_INSTANCE_TABLE_KEY", this.prefix + "JOBINSTANCEDATA" + this.suffix);
        result.put("EXECUTION_INSTANCE_TABLE_KEY", this.prefix + "EXECUTIONINSTANCEDATA" + this.suffix);
        result.put("STEP_EXECUTION_INSTANCE_TABLE_KEY", this.prefix + "STEPEXECUTIONINSTANCEDATA" + this.suffix);
        result.put("JOB_STATUS_TABLE_KEY", this.prefix + "JOBSTATUS" + this.suffix);
        result.put("STEP_STATUS_TABLE_KEY", this.prefix + "STEPSTATUS" + this.suffix);
        result.put("CHECKPOINT_TABLE_KEY", this.prefix + "CHECKPOINTDATA" + this.suffix);
        return result;
    }

    protected Map<String, String> getSharedQueryMap(IBatchConfig batchConfig) throws SQLException {
        this.queryStrings = new HashMap<String, String>();
        this.queryStrings.put("Q_SET_SCHEMA", "SET SCHEMA ");
        this.queryStrings.put("SELECT_CHECKPOINTDATA", "select id, obj from " + this.tableNames.get("CHECKPOINT_TABLE_KEY") + " where id = ?");
        this.queryStrings.put("INSERT_CHECKPOINTDATA", "insert into " + this.tableNames.get("CHECKPOINT_TABLE_KEY") + " values(?, ?)");
        this.queryStrings.put("UPDATE_CHECKPOINTDATA", "update " + this.tableNames.get("CHECKPOINT_TABLE_KEY") + " set obj = ? where id = ?");
        this.queryStrings.put("LOCK_CHECKPOINTDATA", "lock table " + this.tableNames.get("CHECKPOINT_TABLE_KEY") + " in exclusive mode");
        this.queryStrings.put("JOBOPERATOR_GET_JOB_INSTANCE_COUNT", "select count(jobinstanceid) as jobinstancecount from " + this.tableNames.get("JOB_INSTANCE_TABLE_KEY") + " where name = ? and apptag = ?");
        this.queryStrings.put("SELECT_JOBINSTANCEDATA_COUNT", "select count(jobinstanceid) as jobinstancecount from " + this.tableNames.get("JOB_INSTANCE_TABLE_KEY") + " where name = ?");
        this.queryStrings.put("JOBOPERATOR_GET_JOB_INSTANCE_IDS", "select jobinstanceid from " + this.tableNames.get("JOB_INSTANCE_TABLE_KEY") + " where name = ? and apptag = ? order by jobinstanceid desc");
        this.queryStrings.put("SELECT_JOBINSTANCEDATA_IDS", "select jobinstanceid from " + this.tableNames.get("JOB_INSTANCE_TABLE_KEY") + " where name = ? order by jobinstanceid desc");
        this.queryStrings.put("JOB_OPERATOR_GET_EXTERNAL_JOB_INSTANCE_DATA", "select distinct jobinstanceid, name from " + this.tableNames.get("JOB_INSTANCE_TABLE_KEY") + " where name ");
        this.queryStrings.put("JOB_OPERATOR_QUERY_JOB_EXECUTION_TIMESTAMP", "select createtime, endtime, updatetime, starttime from " + this.tableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + " where jobexecid = ?");
        this.queryStrings.put("JOB_OPERATOR_QUERY_JOB_EXECUTION_BATCH_STATUS", "select batchstatus from " + this.tableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + " where jobexecid = ?");
        this.queryStrings.put("JOB_OPERATOR_QUERY_JOB_EXECUTION_EXIT_STATUS", "select exitstatus from " + this.tableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + " where jobexecid = ?");
        this.queryStrings.put("JOB_OPERATOR_QUERY_JOB_EXECUTION_JOB_ID", "select jobinstanceid from " + this.tableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + " where jobexecid = ?");
        this.queryStrings.put("GET_PARAMETERS", "select parameters from " + this.tableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + " where jobexecid = ?");
        this.queryStrings.put("MOST_RECENT_STEPS_FOR_JOB", "select A.* from " + this.tableNames.get("STEP_EXECUTION_INSTANCE_TABLE_KEY") + " as A inner join " + this.tableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + " as B on A.jobexecid = B.jobexecid where B.jobinstanceid = ? order by A.stepexecid desc");
        this.queryStrings.put("STEP_EXECUTIONS_FOR_JOB_EXECUTION", "select * from " + this.tableNames.get("STEP_EXECUTION_INSTANCE_TABLE_KEY") + " where jobexecid = ?");
        this.queryStrings.put("STEP_EXECUTIONS_BY_STEP_ID", "select * from " + this.tableNames.get("STEP_EXECUTION_INSTANCE_TABLE_KEY") + " where stepexecid = ?");
        this.queryStrings.put("UPDATE_BATCH_STATUS_ONLY", "update " + this.tableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + " set batchstatus = ?, updatetime = ? where jobexecid = ?");
        this.queryStrings.put("UPDATE_FINAL_STATUS_AND_TIMESTAMP", "update " + this.tableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + " set batchstatus = ?, exitstatus = ?, endtime = ?, updatetime = ? where jobexecid = ?");
        this.queryStrings.put("MARK_JOB_STARTED", "update " + this.tableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + " set batchstatus = ?, starttime = ?, updatetime = ? where jobexecid = ?");
        this.queryStrings.put("JOB_OPERATOR_GET_JOB_EXECUTION", "select A.jobexecid, A.createtime, A.starttime, A.endtime, A.updatetime, A.parameters, A.jobinstanceid, A.batchstatus, A.exitstatus, B.name from " + this.tableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + " as A inner join " + this.tableNames.get("JOB_INSTANCE_TABLE_KEY") + " as B on A.jobinstanceid = B.jobinstanceid where jobexecid = ?");
        this.queryStrings.put("JOB_OPERATOR_GET_JOB_EXECUTIONS", "select A.jobexecid, A.jobinstanceid, A.createtime, A.starttime, A.endtime, A.updatetime, A.parameters, A.batchstatus, A.exitstatus, B.name from " + this.tableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + " as A inner join " + this.tableNames.get("JOB_INSTANCE_TABLE_KEY") + " as B ON A.jobinstanceid = B.jobinstanceid where A.jobinstanceid = ?");
        this.queryStrings.put("JOB_OPERATOR_GET_RUNNING_EXECUTIONS", "SELECT A.jobexecid FROM " + this.tableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + " A INNER JOIN " + this.tableNames.get("JOB_INSTANCE_TABLE_KEY") + " B ON A.jobinstanceid = B.jobinstanceid WHERE A.batchstatus IN (?,?,?) AND B.name = ?");
        this.queryStrings.put("SELECT_JOBINSTANCEDATA_APPTAG", "select apptag from " + this.tableNames.get("JOB_INSTANCE_TABLE_KEY") + " where jobinstanceid = ?");
        this.queryStrings.put("DELETE_JOBS", "DELETE FROM " + this.tableNames.get("JOB_INSTANCE_TABLE_KEY") + " WHERE apptag = ?");
        String deleteJobExecutions = "DELETE FROM " + this.tableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + " WHERE jobexecid IN (SELECT B.jobexecid FROM " + this.tableNames.get("JOB_INSTANCE_TABLE_KEY") + " A INNER JOIN " + this.tableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + " B ON A.jobinstanceid = B.jobinstanceid WHERE A.apptag = ?)";
        this.queryStrings.put("DELETE_JOB_EXECUTIONS", deleteJobExecutions);
        String deleteStepExecutions = "DELETE FROM " + this.tableNames.get("STEP_EXECUTION_INSTANCE_TABLE_KEY") + " WHERE stepexecid IN (SELECT C.stepexecid FROM " + this.tableNames.get("JOB_INSTANCE_TABLE_KEY") + " A INNER JOIN " + this.tableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + " B ON A.jobinstanceid = B.jobinstanceid INNER JOIN " + this.tableNames.get("STEP_EXECUTION_INSTANCE_TABLE_KEY") + " C ON B.jobexecid = C.jobexecid WHERE A.apptag = ?)";
        this.queryStrings.put("DELETE_STEP_EXECUTIONS", deleteStepExecutions);
        this.queryStrings.put("GET_JOB_STATUS_FROM_EXECUTIONS", "select A.obj from " + this.tableNames.get("JOB_STATUS_TABLE_KEY") + " as A inner join " + this.tableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + " as B on A.id = B.jobinstanceid where B.jobexecid = ?");
        this.queryStrings.put("JOB_INSTANCE_ID_BY_EXECUTION_ID", "select jobinstanceid from " + this.tableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + " where jobexecid = ?");
        this.queryStrings.put("CREATE_SUB_JOB_INSTANCE", "INSERT INTO " + this.tableNames.get("JOB_INSTANCE_TABLE_KEY") + " (name, apptag) VALUES(?, ?)");
        this.queryStrings.put("CREATE_JOB_INSTANCE", "INSERT INTO " + this.tableNames.get("JOB_INSTANCE_TABLE_KEY") + " (name, apptag) VALUES(?, ?)");
        this.queryStrings.put("CREATE_JOB_EXECUTION_ENTRY", "INSERT INTO " + this.tableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + " (jobinstanceid, createtime, updatetime, batchstatus, parameters) VALUES(?, ?, ?, ?, ?)");
        this.queryStrings.put("CREATE_STEP_EXECUTION", "INSERT INTO " + this.tableNames.get("STEP_EXECUTION_INSTANCE_TABLE_KEY") + " (jobexecid, batchstatus, exitstatus, stepname, readcount,writecount, commitcount, rollbackcount, readskipcount, processskipcount, filtercount, writeskipcount, starttime,endtime, persistentdata) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        this.queryStrings.put("UPDATE_WITH_FINAL_PARTITION_STEP_EXECUTION", "select SUM(STEPEX.readcount) readcount, SUM(STEPEX.writecount) writecount, SUM(STEPEX.commitcount) commitcount,  SUM(STEPEX.rollbackcount) rollbackcount, SUM(STEPEX.readskipcount) readskipcount, SUM(STEPEX.processskipcount) processskipcount, SUM(STEPEX.filtercount) filtercount, SUM(STEPEX.writeSkipCount) writeSkipCount from " + this.tableNames.get("STEP_EXECUTION_INSTANCE_TABLE_KEY") + " STEPEX inner join " + this.tableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + " JOBEX on STEPEX.jobexecid = JOBEX.jobexecid where JOBEX.jobinstanceid IN (select jobinstanceid from " + this.tableNames.get("JOB_INSTANCE_TABLE_KEY") + " where name like ?)");
        this.queryStrings.put("UPDATE_STEP_EXECUTION_WITH_METRICS", "UPDATE " + this.tableNames.get("STEP_EXECUTION_INSTANCE_TABLE_KEY") + " SET batchstatus = ?, exitstatus = ?, stepname = ?,  readcount = ?,writecount = ?, commitcount = ?, rollbackcount = ?, readskipcount = ?, processskipcount = ?, filtercount = ?, writeskipcount = ?, starttime = ?, endtime = ?, persistentdata = ? WHERE stepexecid = ?");
        this.queryStrings.put("CREATE_JOBSTATUS", "INSERT INTO " + this.tableNames.get("JOB_STATUS_TABLE_KEY") + " (id, obj) VALUES(?, ?)");
        this.queryStrings.put("GET_JOB_STATUS", "SELECT obj FROM " + this.tableNames.get("JOB_STATUS_TABLE_KEY") + " WHERE id = ?");
        this.queryStrings.put("UPDATE_JOBSTATUS", "UPDATE " + this.tableNames.get("JOB_STATUS_TABLE_KEY") + " SET obj = ? WHERE id = ?");
        this.queryStrings.put("CREATE_STEP_STATUS", "INSERT INTO " + this.tableNames.get("STEP_STATUS_TABLE_KEY") + " (id, obj) VALUES(?, ?)");
        this.queryStrings.put("GET_STEP_STATUS", "SELECT obj FROM " + this.tableNames.get("STEP_STATUS_TABLE_KEY") + " WHERE id IN (SELECT B.stepexecid FROM " + this.tableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + " A INNER JOIN " + this.tableNames.get("STEP_EXECUTION_INSTANCE_TABLE_KEY") + " B ON A.jobexecid = B.jobexecid WHERE A.jobinstanceid = ? and B.stepname = ?)");
        this.queryStrings.put("UPDATE_STEP_STATUS", "UPDATE " + this.tableNames.get("STEP_STATUS_TABLE_KEY") + " SET obj = ? WHERE id = ?");
        this.queryStrings.put("GET_TAGNAME", "SELECT A.apptag FROM " + this.tableNames.get("JOB_INSTANCE_TABLE_KEY") + " A INNER JOIN " + this.tableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + " B ON A.jobinstanceid = B.jobinstanceid WHERE B.jobexecid = ?");
        this.queryStrings.put("GET_MOST_RECENT_EXECUTION_ID", "SELECT jobexecid FROM " + this.tableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + " WHERE jobinstanceid = ? ORDER BY createtime DESC");
        return this.queryStrings;
    }

    private Map<String, String> setCreateH2StringsMap(Map<String, String> tableNames) {
        this.createH2Strings = new HashMap<String, String>();
        this.createH2Strings.put("H2_CREATE_TABLE_CHECKPOINTDATA", "CREATE TABLE " + tableNames.get("CHECKPOINT_TABLE_KEY") + "(id VARCHAR(512),obj BLOB)");
        this.createH2Strings.put("H2_CREATE_TABLE_JOBINSTANCEDATA", "CREATE TABLE " + tableNames.get("JOB_INSTANCE_TABLE_KEY") + "(jobinstanceid BIGINT NOT NULL IDENTITY PRIMARY KEY,name VARCHAR(512),apptag VARCHAR(512))");
        this.createH2Strings.put("H2_CREATE_TABLE_EXECUTIONINSTANCEDATA", "CREATE TABLE " + tableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + "(jobexecid BIGINT NOT NULL IDENTITY PRIMARY KEY,jobinstanceid BIGINT,createtime TIMESTAMP,starttime TIMESTAMP,endtime TIMESTAMP,updatetime TIMESTAMP,parameters BLOB,batchstatus VARCHAR(512),exitstatus VARCHAR(512),CONSTRAINT JOBINST_JOBEXEC_FK FOREIGN KEY (jobinstanceid) REFERENCES " + tableNames.get("JOB_INSTANCE_TABLE_KEY") + "(jobinstanceid))");
        this.createH2Strings.put("H2_CREATE_TABLE_STEPINSTANCEDATA", "CREATE TABLE " + tableNames.get("STEP_EXECUTION_INSTANCE_TABLE_KEY") + "(stepexecid BIGINT NOT NULL IDENTITY PRIMARY KEY,jobexecid BIGINT,batchstatus VARCHAR(512),exitstatus VARCHAR(512),stepname VARCHAR(512),readcount INTEGER,writecount INTEGER,commitcount INTEGER,rollbackcount INTEGER,readskipcount INTEGER,processskipcount INTEGER,filtercount INTEGER,writeskipcount INTEGER,startTime TIMESTAMP,endTime TIMESTAMP,persistentData BLOB,CONSTRAINT JOBEXEC_STEPEXEC_FK FOREIGN KEY (jobexecid) REFERENCES " + tableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + "(jobexecid))");
        this.createH2Strings.put("H2_CREATE_TABLE_JOBSTATUS", "CREATE TABLE " + tableNames.get("JOB_STATUS_TABLE_KEY") + "(id BIGINT CONSTRAINT JOBSTATUS_PK PRIMARY KEY,obj BLOB,CONSTRAINT JOBSTATUS_JOBINST_FK FOREIGN KEY (id) REFERENCES " + tableNames.get("JOB_INSTANCE_TABLE_KEY") + " (jobinstanceid) ON DELETE CASCADE)");
        this.createH2Strings.put("H2_CREATE_TABLE_STEPSTATUS", "CREATE TABLE " + tableNames.get("STEP_STATUS_TABLE_KEY") + "(id BIGINT CONSTRAINT STEPSTATUS_PK PRIMARY KEY,obj BLOB,CONSTRAINT STEPSTATUS_STEPEXEC_FK FOREIGN KEY (id) REFERENCES " + tableNames.get("STEP_EXECUTION_INSTANCE_TABLE_KEY") + "(stepexecid) ON DELETE CASCADE)");
        return this.createH2Strings;
    }

    private RequestTraceSpanLog constructJBatchExecutionSpanLog(RuntimeJobExecution jobExecution) {
        RequestTraceSpanLog spanLog = new RequestTraceSpanLog("jBatchExecutionContextEvent");
        try {
            spanLog.addLogEntry("Execution ID", Long.toString(jobExecution.getExecutionId()));
            spanLog.addLogEntry("Job ID", Long.toString(jobExecution.getInstanceId()));
            spanLog.addLogEntry("Job Name", jobExecution.getJobInstance().getJobName());
            spanLog.addLogEntry("Batch Status", jobExecution.getJobOperatorJobExecution().getBatchStatus().toString());
            if (jobExecution.getJobParameters() != null) {
                spanLog.addLogEntry("Job Parameters", jobExecution.getJobParameters().toString());
            } else {
                spanLog.addLogEntry("Job Parameters", "null");
            }
        }
        catch (NullPointerException e) {
            logger.log(Level.INFO, "NullPointerException when creating request tracing JBatchExecutionContextEvent");
        }
        return spanLog;
    }
}

