/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer.impl;

import com.sun.jdo.api.persistence.enhancer.classfile.ClassMethod;
import com.sun.jdo.api.persistence.enhancer.classfile.CodeAttribute;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstClass;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstFieldRef;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstMethodRef;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstNameAndType;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstantPool;
import com.sun.jdo.api.persistence.enhancer.classfile.Descriptor;
import com.sun.jdo.api.persistence.enhancer.classfile.Insn;
import com.sun.jdo.api.persistence.enhancer.classfile.InsnConstOp;
import com.sun.jdo.api.persistence.enhancer.classfile.InsnInterfaceInvoke;
import com.sun.jdo.api.persistence.enhancer.classfile.InsnTarget;
import com.sun.jdo.api.persistence.enhancer.classfile.InsnUtils;
import com.sun.jdo.api.persistence.enhancer.impl.AnnotationConstants;
import com.sun.jdo.api.persistence.enhancer.impl.AnnotationFragment;
import com.sun.jdo.api.persistence.enhancer.impl.ClassAction;
import com.sun.jdo.api.persistence.enhancer.impl.Environment;
import com.sun.jdo.api.persistence.enhancer.impl.InsnNote;
import com.sun.jdo.api.persistence.enhancer.impl.StackState;
import com.sun.jdo.api.persistence.enhancer.meta.JDOMetaData;
import com.sun.jdo.api.persistence.enhancer.util.InternalError;
import com.sun.jdo.api.persistence.enhancer.util.Support;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;

class MethodAnnotater
extends Support
implements AnnotationConstants {
    private final ClassAction ca;
    private final ClassMethod method;
    private final ConstantPool pool;
    private final Environment env;
    private int annotate;
    private Vector tmpRegisters;
    private Vector tmpDoubleRegisters;
    private short annotationStack = 0;
    private Map insnNotes = new HashMap(11);

    boolean needsAnnotation() {
        return this.annotate != 0;
    }

    MethodAnnotater(ClassAction ca, ClassMethod method, Environment env) {
        this.ca = ca;
        this.method = method;
        this.env = env;
        this.pool = ca.classFile().pool();
    }

    void checkMethod() {
        this.env.message("checking method " + this.ca.userClassName() + "." + this.method.name().asString() + Descriptor.userMethodArgs(this.method.signature().asString()));
        this.annotate = 0;
        CodeAttribute codeAttr = this.method.codeAttribute();
        if (codeAttr == null) {
            return;
        }
        if (this.avoidAnnotation()) {
            return;
        }
        this.checkCode(codeAttr);
    }

    private boolean avoidAnnotation() {
        return false;
    }

    void checkCode(CodeAttribute codeAttr) {
        Insn firstInsn;
        for (Insn markInsn = firstInsn = codeAttr.theCode(); markInsn != null; markInsn = markInsn.next()) {
            markInsn.markTargets();
        }
        int allFlags = 0;
        for (Insn insn = firstInsn; insn != null; insn = insn.next()) {
            InsnNote note = null;
            switch (insn.opcode()) {
                case 180: {
                    note = this.noteGetFieldAnnotation(insn);
                    break;
                }
                case 181: {
                    note = this.notePutFieldAnnotation(insn);
                    break;
                }
            }
            if (note == null) continue;
            this.addNoteList(note);
            MethodAnnotater.affirm(note.next() == null, "Number of annotation notes for instruction > 1.");
            allFlags |= note.insnFlags;
        }
        String methodName = this.method.name().asString();
        String methodSig = this.method.signature().asString();
        boolean implementsPersistence = this.ca.getImplementsPersistence();
        if (methodName.equals("clone") && methodSig.equals("()Ljava/lang/Object;") && implementsPersistence) {
            allFlags |= 0x8000;
        }
        this.annotate = allFlags;
    }

    private InsnNote noteGetFieldAnnotation(Insn insn) {
        InsnConstOp getFieldInsn = (InsnConstOp)insn;
        ConstFieldRef fieldRef = (ConstFieldRef)getFieldInsn.value();
        String fieldOf = fieldRef.className().asString();
        String fieldName = fieldRef.nameAndType().name().asString();
        JDOMetaData meta = this.env.getJDOMetaData();
        if (!meta.isPersistentField(fieldOf, fieldName)) {
            return null;
        }
        boolean dfgField = meta.isDefaultFetchGroupField(fieldOf, fieldName);
        boolean pkField = meta.isPrimaryKeyField(fieldOf, fieldName);
        int fieldIndex = meta.getFieldNo(fieldOf, fieldName);
        String targetPCRootClass = meta.getPersistenceCapableRootClass(fieldOf);
        int flags = 0;
        String fieldSig = fieldRef.nameAndType().signature().asString();
        boolean stackArgSize = false;
        Insn dep = this.findArgDepositer(insn, 0);
        flags = dep != null && dep.opcode() == 42 && !this.method.isStatic() ? (flags |= 1) : (flags |= 0x10);
        if (dfgField) {
            flags |= 0x800;
        }
        if (pkField) {
            flags |= 0x1000;
        }
        return new InsnNote(insn, flags, 0, fieldSig, fieldOf, fieldName, fieldIndex, targetPCRootClass);
    }

    private InsnNote notePutFieldAnnotation(Insn insn) {
        InsnConstOp putFieldInsn = (InsnConstOp)insn;
        ConstFieldRef fieldRef = (ConstFieldRef)putFieldInsn.value();
        String fieldOf = fieldRef.className().asString();
        String fieldName = fieldRef.nameAndType().name().asString();
        JDOMetaData meta = this.env.getJDOMetaData();
        if (!meta.isPersistentField(fieldOf, fieldName)) {
            return null;
        }
        boolean dfgField = meta.isDefaultFetchGroupField(fieldOf, fieldName);
        boolean pkField = meta.isPrimaryKeyField(fieldOf, fieldName);
        int fieldIndex = meta.getFieldNo(fieldOf, fieldName);
        String targetPCRootClass = meta.getPersistenceCapableRootClass(fieldOf);
        int flags = 0;
        String fieldSig = fieldRef.nameAndType().signature().asString();
        int stackArgSize = fieldSig.equals("J") || fieldSig.equals("D") ? 2 : 1;
        Insn dep = this.findArgDepositer(insn, stackArgSize);
        flags = dep != null && dep.opcode() == 42 && !this.method.isStatic() ? (flags |= 2) : (flags |= 0x20);
        if (dfgField) {
            flags |= 0x800;
        }
        if (pkField) {
            flags |= 0x1000;
        }
        return new InsnNote(insn, flags, stackArgSize, fieldSig, fieldOf, fieldName, fieldIndex, targetPCRootClass);
    }

    void annotateMethod() {
        CodeAttribute codeAttr = this.method.codeAttribute();
        if (codeAttr == null || !this.needsAnnotation()) {
            return;
        }
        this.env.message("annotating method " + this.ca.userClassName() + "." + this.method.name().asString() + Descriptor.userMethodArgs(this.method.signature().asString()));
        Insn firstInsn = codeAttr.theCode();
        block3: for (Insn insn = firstInsn.next(); insn != null; insn = insn.next()) {
            switch (insn.opcode()) {
                case 180: 
                case 181: {
                    insn = this.insnAnnotation(insn);
                    continue block3;
                }
            }
        }
        if ((this.annotate & 0x8000) != 0) {
            String superName = this.ca.classFile().superName().asString();
            this.annotateClone(codeAttr, superName);
        }
        if (this.annotationStack > 0) {
            codeAttr.setStackUsed(codeAttr.stackUsed() + this.annotationStack);
        }
    }

    private void annotateClone(CodeAttribute codeAttr, String superName) {
        for (Insn insn = codeAttr.theCode(); insn != null; insn = insn.next()) {
            boolean needCheckcast;
            if (insn.opcode() != 183) continue;
            InsnConstOp invoke = (InsnConstOp)insn;
            ConstMethodRef methodRef = (ConstMethodRef)invoke.value();
            ConstNameAndType methodNT = methodRef.nameAndType();
            String methodName = methodNT.name().asString();
            String methodSig = methodNT.signature().asString();
            if (!methodName.equals("clone") || !methodSig.equals("()Ljava/lang/Object;")) continue;
            String thisClass = this.ca.className();
            Insn checkCastInsn = insn.next();
            if (checkCastInsn.opcode() != 192) {
                needCheckcast = true;
            } else {
                ConstClass target = (ConstClass)((InsnConstOp)checkCastInsn).value();
                if (target.asString().equals(thisClass)) {
                    insn = checkCastInsn;
                    needCheckcast = false;
                } else {
                    needCheckcast = true;
                }
            }
            Insn newInsn = Insn.create(89);
            if (needCheckcast) {
                newInsn.append(Insn.create(192, this.pool.addClass(thisClass)));
            }
            newInsn.append(Insn.create(89));
            newInsn.append(Insn.create(1));
            newInsn.append(Insn.create(181, this.pool.addFieldRef(thisClass, "jdoStateManager", "Lcom/sun/jdo/spi/persistence/support/sqlstore/StateManager;")));
            newInsn.append(Insn.create(3));
            newInsn.append(Insn.create(181, this.pool.addFieldRef(thisClass, "jdoFlags", "B")));
            insn.insert(newInsn);
            this.noteStack(3);
        }
    }

    private Insn insnAnnotation(Insn insn) {
        int initialSingleRegs = 0;
        InsnNote note = this.getNoteList(insn);
        if (note == null) {
            return insn;
        }
        MethodAnnotater.affirm(insn == note.insn);
        MethodAnnotater.affirm(note.next() == null, "Number of annotation notes for instruction > 1.");
        boolean fetch = note.fetchPersistent() || note.fetchThis();
        boolean dirty = note.dirtyPersistent() || note.dirtyThis();
        MethodAnnotater.affirm(fetch ^ dirty, "Inconsistent fetch/dirty flags.");
        boolean dfgField = note.dfgFieldAccess();
        boolean pkField = note.pkFieldAccess();
        if (pkField && fetch) {
            return insn;
        }
        if (pkField || !dfgField) {
            Insn prev = insn.prev();
            insn.remove();
            AnnotationFragment frag1 = this.buildAccessAnnotation(note);
            MethodAnnotater.affirm(frag1, "Illegal annotation of PK or non-dfg field.");
            Insn last = prev.insert(frag1.annotation);
            this.noteStack(frag1.stackRequired - note.arg());
            return last;
        }
        AnnotationFragment frag0 = this.buildBasicAnnotation(note);
        MethodAnnotater.affirm(frag0, "Illegal annotation of dfg field.");
        StackState state = new StackState(note.arg(), note.sig(), insn.prev());
        this.minimizeStack(state);
        Insn annotation = null;
        if (state.argDepth == 0) {
            annotation = frag0.annotation;
            this.noteStack(frag0.stackRequired);
        } else if (state.argDepth == 1) {
            annotation = Insn.create(95);
            annotation.append(frag0.annotation);
            annotation.append(Insn.create(95));
            this.noteStack(frag0.stackRequired - (note.arg() - 1));
        } else {
            int elemSize;
            int depth;
            Stack stackTypes = state.stackTypes;
            int elem = stackTypes.size() - 1;
            int singleRegs = initialSingleRegs;
            int doubleRegs = 0;
            int[] regnums = new int[depth];
            int regtotal = 0;
            for (depth = state.argDepth; depth > 0; depth -= elemSize) {
                int elemType = (Integer)stackTypes.elementAt(elem--);
                elemSize = Descriptor.elementSize(elemType);
                int reg = elemSize == 1 ? this.tmpReg(singleRegs++) : this.tmpReg2(doubleRegs++);
                regnums[regtotal++] = reg;
                Insn store = InsnUtils.store(elemType, reg, this.pool);
                if (annotation == null) {
                    annotation = store;
                    continue;
                }
                annotation.append(store);
            }
            MethodAnnotater.affirm(depth >= 0, "Stack underflow while computing save registers");
            annotation.append(frag0.annotation);
            while (regtotal > 0) {
                annotation.append(InsnUtils.load((Integer)stackTypes.elementAt(++elem), regnums[--regtotal], this.pool));
            }
            this.noteStack(frag0.stackRequired - note.arg());
        }
        state.insn.insert(annotation);
        return insn;
    }

    private AnnotationFragment buildAccessAnnotation(InsnNote note) {
        int requiredStack;
        Insn annotation;
        String targetClassName = note.targetClassName;
        String targetFieldName = note.targetFieldName;
        String targetPCRootClass = note.targetPCRootClass;
        boolean fetch = note.fetchPersistent() || note.fetchThis();
        boolean dirty = note.dirtyPersistent() || note.dirtyThis();
        MethodAnnotater.affirm(fetch ^ dirty, "Inconsistent fetch/dirty flags.");
        int argSize = note.arg();
        String fieldSig = note.sig();
        int fieldType = Descriptor.elementType(fieldSig);
        int fieldIndex = note.targetFieldIndex;
        if (fetch) {
            Insn insn = annotation = Insn.create(89);
            insn = insn.append(Insn.create(180, this.pool.addFieldRef(targetPCRootClass, "jdoStateManager", "Lcom/sun/jdo/spi/persistence/support/sqlstore/StateManager;")));
            InsnTarget fetchDirty = new InsnTarget();
            InsnTarget afterFetchDirty = new InsnTarget();
            insn = insn.append(Insn.create(89));
            insn = insn.append(Insn.create(199, fetchDirty));
            insn = insn.append(Insn.create(87));
            insn = insn.append(Insn.create(167, afterFetchDirty));
            insn = insn.append(fetchDirty);
            insn = insn.append(InsnUtils.integerConstant(fieldIndex, this.pool));
            requiredStack = 2;
            insn = insn.append(new InsnInterfaceInvoke(this.pool.addInterfaceMethodRef("com/sun/jdo/spi/persistence/support/sqlstore/StateManager", "prepareGetField", "(I)V"), requiredStack));
            insn = insn.append(afterFetchDirty);
            insn = insn.append(note.insn);
        } else {
            int singleRegs = 0;
            int doubleRegs = 0;
            MethodAnnotater.affirm(argSize > 0);
            int reg = argSize == 1 ? this.tmpReg(singleRegs++) : this.tmpReg2(doubleRegs++);
            Insn insn = annotation = InsnUtils.store(fieldType, reg, this.pool);
            insn = insn.append(Insn.create(89));
            insn = insn.append(Insn.create(180, this.pool.addFieldRef(targetPCRootClass, "jdoStateManager", "Lcom/sun/jdo/spi/persistence/support/sqlstore/StateManager;")));
            InsnTarget fetchDirty = new InsnTarget();
            InsnTarget afterFetchDirty = new InsnTarget();
            insn = insn.append(Insn.create(89));
            insn = insn.append(Insn.create(199, fetchDirty));
            insn = insn.append(Insn.create(87));
            MethodAnnotater.affirm(argSize > 0);
            insn = insn.append(InsnUtils.load(fieldType, reg, this.pool));
            insn = insn.append(note.insn);
            insn = insn.append(Insn.create(167, afterFetchDirty));
            insn = insn.append(fetchDirty);
            insn = insn.append(InsnUtils.integerConstant(fieldIndex, this.pool));
            MethodAnnotater.affirm(argSize > 0);
            insn = insn.append(InsnUtils.load(fieldType, reg, this.pool));
            switch (fieldType) {
                case 4: {
                    requiredStack = 3;
                    insn = insn.append(new InsnInterfaceInvoke(this.pool.addInterfaceMethodRef("com/sun/jdo/spi/persistence/support/sqlstore/StateManager", "setBooleanField", "(IB)B"), requiredStack));
                    insn = insn.append(Insn.create(88));
                    break;
                }
                case 5: {
                    requiredStack = 3;
                    insn = insn.append(new InsnInterfaceInvoke(this.pool.addInterfaceMethodRef("com/sun/jdo/spi/persistence/support/sqlstore/StateManager", "setCharField", "(IC)C"), requiredStack));
                    insn = insn.append(Insn.create(88));
                    break;
                }
                case 8: {
                    requiredStack = 3;
                    insn = insn.append(new InsnInterfaceInvoke(this.pool.addInterfaceMethodRef("com/sun/jdo/spi/persistence/support/sqlstore/StateManager", "setByteField", "(IZ)Z"), requiredStack));
                    insn = insn.append(Insn.create(88));
                    break;
                }
                case 9: {
                    requiredStack = 3;
                    insn = insn.append(new InsnInterfaceInvoke(this.pool.addInterfaceMethodRef("com/sun/jdo/spi/persistence/support/sqlstore/StateManager", "setShortField", "(IS)S"), requiredStack));
                    insn = insn.append(Insn.create(88));
                    break;
                }
                case 10: {
                    requiredStack = 3;
                    insn = insn.append(new InsnInterfaceInvoke(this.pool.addInterfaceMethodRef("com/sun/jdo/spi/persistence/support/sqlstore/StateManager", "setIntField", "(II)I"), requiredStack));
                    insn = insn.append(Insn.create(88));
                    break;
                }
                case 11: {
                    requiredStack = 4;
                    insn = insn.append(new InsnInterfaceInvoke(this.pool.addInterfaceMethodRef("com/sun/jdo/spi/persistence/support/sqlstore/StateManager", "setLongField", "(IJ)J"), requiredStack));
                    insn = insn.append(Insn.create(88));
                    insn = insn.append(Insn.create(87));
                    break;
                }
                case 6: {
                    requiredStack = 3;
                    insn = insn.append(new InsnInterfaceInvoke(this.pool.addInterfaceMethodRef("com/sun/jdo/spi/persistence/support/sqlstore/StateManager", "setFloatField", "(IF)F"), requiredStack));
                    insn = insn.append(Insn.create(88));
                    break;
                }
                case 7: {
                    requiredStack = 4;
                    insn = insn.append(new InsnInterfaceInvoke(this.pool.addInterfaceMethodRef("com/sun/jdo/spi/persistence/support/sqlstore/StateManager", "setDoubleField", "(ID)D"), requiredStack));
                    insn = insn.append(Insn.create(88));
                    insn = insn.append(Insn.create(87));
                    break;
                }
                case 12: 
                case 13: {
                    requiredStack = 3;
                    insn = insn.append(new InsnInterfaceInvoke(this.pool.addInterfaceMethodRef("com/sun/jdo/spi/persistence/support/sqlstore/StateManager", "setObjectField", "(ILjava/lang/Object;)Ljava/lang/Object;"), requiredStack));
                    insn = insn.append(Insn.create(88));
                    break;
                }
                default: {
                    throw new InternalError("Unexpected field type");
                }
            }
            insn = insn.append(afterFetchDirty);
        }
        return new AnnotationFragment(annotation, requiredStack);
    }

    private AnnotationFragment buildBasicAnnotation(InsnNote note) {
        int requiredStack = 2;
        Insn basicAnnotation = null;
        String targetClassName = note.targetClassName;
        String targetFieldName = note.targetFieldName;
        String targetPCRootClass = note.targetPCRootClass;
        boolean fetch = note.fetchPersistent() || note.fetchThis();
        boolean dirty = note.dirtyPersistent() || note.dirtyThis();
        MethodAnnotater.affirm(fetch ^ dirty, "Inconsistent fetch/dirty flags.");
        Insn insn = null;
        basicAnnotation = insn = Insn.create(89);
        insn = insn.append(Insn.create(180, this.pool.addFieldRef(targetPCRootClass, "jdoFlags", "B")));
        InsnTarget afterFetchDirty = new InsnTarget();
        insn = insn.append(Insn.create(fetch ? 158 : 153, afterFetchDirty));
        insn = insn.append(Insn.create(89));
        insn = insn.append(Insn.create(180, this.pool.addFieldRef(targetPCRootClass, "jdoStateManager", "Lcom/sun/jdo/spi/persistence/support/sqlstore/StateManager;")));
        insn = insn.append(new InsnInterfaceInvoke(this.pool.addInterfaceMethodRef("com/sun/jdo/spi/persistence/support/sqlstore/StateManager", fetch ? "loadForRead" : "loadForUpdate", "()V"), 1));
        insn = insn.append(afterFetchDirty);
        return new AnnotationFragment(basicAnnotation, requiredStack);
    }

    private int tmpReg2(int idx) {
        if (this.tmpDoubleRegisters == null) {
            this.tmpDoubleRegisters = new Vector(3);
        }
        while (this.tmpDoubleRegisters.size() <= idx) {
            CodeAttribute codeAttr = this.method.codeAttribute();
            int reg = codeAttr.localsUsed();
            this.tmpDoubleRegisters.addElement(reg);
            codeAttr.setLocalsUsed(reg + 2);
        }
        return (Integer)this.tmpDoubleRegisters.elementAt(idx);
    }

    private int tmpReg(int idx) {
        if (this.tmpRegisters == null) {
            this.tmpRegisters = new Vector(3);
        }
        while (this.tmpRegisters.size() <= idx) {
            CodeAttribute codeAttr = this.method.codeAttribute();
            int reg = codeAttr.localsUsed();
            this.tmpRegisters.addElement(reg);
            codeAttr.setLocalsUsed(reg + 1);
        }
        return (Integer)this.tmpRegisters.elementAt(idx);
    }

    private void noteStack(int stk) {
        if (stk > this.annotationStack) {
            this.annotationStack = (short)stk;
        }
    }

    private Insn findArgDepositer(Insn currInsn, int argDepth) {
        Insn depositer = null;
        Insn i = currInsn.prev();
        while (!(argDepth < 0 || i.branches() || i instanceof InsnTarget && ((InsnTarget)i).isBranchTarget())) {
            int nArgs = i.nStackArgs();
            int nResults = i.nStackResults();
            if (argDepth - nResults < 0) {
                if (nResults > 1 && i.opcode() != 89) break;
                depositer = i;
                switch (i.opcode()) {
                    case 89: {
                        if (argDepth != 0) break;
                        ++argDepth;
                        break;
                    }
                    case 192: {
                        break;
                    }
                    default: {
                        return i;
                    }
                }
            }
            argDepth += nArgs - nResults;
            i = i.prev();
        }
        return depositer;
    }

    private void minimizeStack(StackState state) {
        Insn i = state.insn;
        int argDepth = state.argDepth;
        Stack argTypesStack = new Stack();
        Stack resultTypesStack = new Stack();
        Stack stackTypes = new Stack();
        this.copyStack(state.stackTypes, stackTypes);
        while (!(argDepth <= 0 || i.branches() || i instanceof InsnTarget && ((InsnTarget)i).isBranchTarget())) {
            int nArgs = i.nStackArgs();
            int nResults = i.nStackResults();
            String argTypes = i.argTypes();
            String resultTypes = i.resultTypes();
            if ((argDepth -= nResults) < 0) break;
            argDepth += nArgs;
            if (i.opcode() == 95) {
                Object x = stackTypes.pop();
                Object y = stackTypes.pop();
                stackTypes.push(x);
                stackTypes.push(y);
            } else {
                while (!argTypesStack.empty()) {
                    argTypesStack.pop();
                }
                while (!resultTypesStack.empty()) {
                    resultTypesStack.pop();
                }
                Descriptor.computeStackTypes(argTypes, argTypesStack);
                Descriptor.computeStackTypes(resultTypes, resultTypesStack);
                int expectWords = 0;
                while (!resultTypesStack.empty()) {
                    expectWords += Descriptor.elementSize((Integer)resultTypesStack.pop());
                }
                while (expectWords > 0) {
                    expectWords -= Descriptor.elementSize((Integer)stackTypes.pop());
                }
                if (expectWords < 0) {
                    return;
                }
                this.transferStackArgs(argTypesStack, stackTypes);
            }
            if (argDepth >= 0 && argDepth < state.argDepth && this.knownTypes(stackTypes, argDepth)) {
                state.argDepth = argDepth;
                state.insn = i.prev();
                this.copyStack(stackTypes, state.stackTypes);
            }
            i = i.prev();
        }
    }

    private final void transferStackArgs(Stack fromStack, Stack toStack) {
        if (!fromStack.empty()) {
            Object o = fromStack.pop();
            this.transferStackArgs(fromStack, toStack);
            toStack.push(o);
        }
    }

    private final void copyStack(Stack fromStack, Stack toStack) {
        while (!toStack.empty()) {
            toStack.pop();
        }
        for (int i = 0; i < fromStack.size(); ++i) {
            toStack.addElement(fromStack.elementAt(i));
        }
    }

    private final boolean knownTypes(Stack stack, int nWords) {
        int words;
        block5: for (int i = stack.size() - 1; i >= 0 && nWords > 0; nWords -= words, --i) {
            words = 0;
            switch ((Integer)stack.elementAt(i)) {
                case 15: 
                case 16: 
                case 17: {
                    return false;
                }
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 12: 
                case 13: 
                case 14: {
                    words = 1;
                    continue block5;
                }
                case 7: 
                case 11: {
                    words = 2;
                    continue block5;
                }
            }
        }
        return true;
    }

    private final void addNoteList(InsnNote note) {
        this.insnNotes.put(note.insn, note);
    }

    private final InsnNote getNoteList(Insn insn) {
        return (InsnNote)this.insnNotes.get(insn);
    }
}

