/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.concurrent.admin;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.naming.DefaultResourceProxy;
import org.glassfish.concurrent.config.ManagedScheduledExecutorService;
import org.glassfish.concurrent.runtime.deployer.DefaultManagedScheduledExecutorService;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.resourcebase.resources.util.BindableResourcesHelper;
import org.jvnet.hk2.annotations.Service;

@TargetType(value={CommandTarget.DAS, CommandTarget.DOMAIN, CommandTarget.CLUSTER, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG, CommandTarget.DEPLOYMENT_GROUP})
@ExecuteOn(value={RuntimeType.DAS})
@Service(name="list-managed-scheduled-executor-services")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="list.managed.scheduled.executor.service")
@RestEndpoints(value={@RestEndpoint(configBean=Resources.class, opType=RestEndpoint.OpType.GET, path="list-managed-scheduled-executor-services", description="List Managed Scheduled Executor Services")})
public class ListManagedScheduledExecutorServices
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ListManagedScheduledExecutorServices.class);
    @Param(primary=true, optional=true, defaultValue="server")
    private String target;
    @Inject
    private Domain domain;
    @Inject
    private BindableResourcesHelper bindableResourcesHelper;
    @Inject
    private ServiceLocator habitat;
    @Inject
    private DefaultManagedScheduledExecutorService defaultService;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            Collection<ManagedScheduledExecutorService> managedScheduledExecutorServices = this.domain.getResources().getResources(ManagedScheduledExecutorService.class);
            ArrayList resourcesList = new ArrayList();
            List drps = this.habitat.getAllServices(DefaultResourceProxy.class, new Annotation[0]);
            for (ManagedScheduledExecutorService managedScheduledExecutorService : managedScheduledExecutorServices) {
                String jndiName = managedScheduledExecutorService.getJndiName();
                if (!this.bindableResourcesHelper.resourceExists(jndiName, this.target)) continue;
                ActionReport.MessagePart part = report.getTopMessagePart().addChild();
                part.setMessage(jndiName);
                HashMap<String, String> resourceNameMap = new HashMap<String, String>();
                String logicalName = DefaultResourceProxy.Util.getLogicalName((List)drps, (String)jndiName);
                if (logicalName != null) {
                    resourceNameMap.put("logical-jndi-name", logicalName);
                }
                resourceNameMap.put("name", jndiName);
                resourcesList.add(resourceNameMap);
            }
            Properties extraProperties = new Properties();
            extraProperties.put("managedScheduledExecutorServices", resourcesList);
            report.setExtraProperties(extraProperties);
        }
        catch (Exception e) {
            report.setMessage(localStrings.getLocalString("list.managed.scheduled.executor.service.failed", "List managed scheduled executor services failed"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

