/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.concurrent.runtime;

import com.sun.enterprise.security.SecurityContext;
import fish.payara.nucleus.requesttracing.RequestTracingService;
import fish.payara.opentracing.OpenTracingService;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import jakarta.enterprise.concurrent.spi.ThreadContextRestorer;
import jakarta.enterprise.concurrent.spi.ThreadContextSnapshot;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.annotation.Annotation;
import java.util.List;
import javax.security.auth.Subject;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.concurrent.runtime.ConcurrentRuntime;
import org.glassfish.enterprise.concurrent.spi.ContextHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;

public class InvocationContext
implements ContextHandle {
    static final long serialVersionUID = 5642415011655486579L;
    private transient ComponentInvocation invocation;
    private transient ClassLoader contextClassLoader;
    private transient SecurityContext securityContext;
    private boolean useTransactionOfExecutionThread;
    private List<ThreadContextSnapshot> threadContextSnapshots;
    private List<ThreadContextRestorer> threadContextRestorers;
    private transient SpanContext parentTraceContext;

    public InvocationContext(ComponentInvocation invocation, ClassLoader contextClassLoader, SecurityContext securityContext, boolean useTransactionOfExecutionThread, List<ThreadContextSnapshot> threadContextSnapshots, List<ThreadContextRestorer> threadContextRestorers) {
        this.invocation = invocation;
        this.contextClassLoader = contextClassLoader;
        this.securityContext = securityContext;
        this.useTransactionOfExecutionThread = useTransactionOfExecutionThread;
        this.threadContextSnapshots = threadContextSnapshots;
        this.threadContextRestorers = threadContextRestorers;
        this.saveTracingContext();
    }

    private void saveTracingContext() {
        ServiceLocator serviceLocator = Globals.getDefaultBaseServiceLocator();
        if (serviceLocator != null) {
            Tracer tracer;
            Span currentSpan;
            RequestTracingService requestTracing = (RequestTracingService)serviceLocator.getService(RequestTracingService.class, new Annotation[0]);
            OpenTracingService openTracing = (OpenTracingService)serviceLocator.getService(OpenTracingService.class, new Annotation[0]);
            if (requestTracing != null && requestTracing.isRequestTracingEnabled() && requestTracing.isTraceInProgress() && openTracing != null && (currentSpan = (tracer = openTracing.getTracer(openTracing.getApplicationName((InvocationManager)serviceLocator.getService(InvocationManager.class, new Annotation[0])))).activeSpan()) != null) {
                this.parentTraceContext = currentSpan.context();
            }
        }
    }

    public ComponentInvocation getInvocation() {
        return this.invocation;
    }

    public ClassLoader getContextClassLoader() {
        return this.contextClassLoader;
    }

    public SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public boolean isUseTransactionOfExecutionThread() {
        return this.useTransactionOfExecutionThread;
    }

    SpanContext getParentTraceContext() {
        return this.parentTraceContext;
    }

    public List<ThreadContextSnapshot> getThreadContextSnapshots() {
        return this.threadContextSnapshots;
    }

    public List<ThreadContextRestorer> getThreadContextRestorers() {
        return this.threadContextRestorers;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeBoolean(this.useTransactionOfExecutionThread);
        String componentId = null;
        String appName = null;
        String moduleName = null;
        if (this.invocation != null) {
            componentId = this.invocation.getComponentId();
            appName = this.invocation.getAppName();
            moduleName = this.invocation.getModuleName();
        }
        out.writeObject(componentId);
        out.writeObject(appName);
        out.writeObject(moduleName);
        String principalName = null;
        boolean defaultSecurityContext = false;
        Subject subject = null;
        if (this.securityContext != null) {
            if (this.securityContext.getCallerPrincipal() != null) {
                principalName = this.securityContext.getCallerPrincipal().getName();
                subject = this.securityContext.getSubject();
                subject.getPrincipals().clear();
            }
            if (this.securityContext == SecurityContext.getDefaultSecurityContext()) {
                defaultSecurityContext = true;
            }
        }
        out.writeObject(principalName);
        out.writeBoolean(defaultSecurityContext);
        out.writeObject(subject);
        out.writeObject(this.threadContextSnapshots);
        out.writeObject(this.threadContextRestorers);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        ApplicationInfo applicationInfo;
        this.useTransactionOfExecutionThread = in.readBoolean();
        String componentId = (String)in.readObject();
        String appName = (String)in.readObject();
        String moduleName = (String)in.readObject();
        this.invocation = this.createComponentInvocation(componentId, appName, moduleName);
        String principalName = (String)in.readObject();
        boolean defaultSecurityContext = in.readBoolean();
        Subject subject = (Subject)in.readObject();
        if (principalName != null) {
            this.securityContext = defaultSecurityContext ? SecurityContext.getDefaultSecurityContext() : new SecurityContext(principalName, subject, null);
        }
        ApplicationRegistry applicationRegistry = ConcurrentRuntime.getRuntime().getApplicationRegistry();
        if (appName != null && (applicationInfo = applicationRegistry.get(appName)) != null) {
            this.contextClassLoader = applicationInfo.getAppClassLoader();
        }
        this.threadContextSnapshots = (List)in.readObject();
        this.threadContextRestorers = (List)in.readObject();
    }

    private ComponentInvocation createComponentInvocation(String componentId, String appName, String moduleName) {
        if (componentId == null && appName == null && moduleName == null) {
            return null;
        }
        ComponentInvocation newInv = new ComponentInvocation(componentId, ComponentInvocation.ComponentInvocationType.SERVLET_INVOCATION, null, appName, moduleName, appName);
        return newInv;
    }
}

