/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.concurrent.runtime.deployer;

import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.glassfish.concurrent.runtime.ConcurrentRuntime;
import org.glassfish.concurrent.runtime.deployer.BaseConfig;
import org.glassfish.concurrent.runtime.deployer.ContextServiceConfig;
import org.glassfish.concurrent.runtime.deployer.ManagedExecutorServiceConfig;
import org.glassfish.concurrent.runtime.deployer.ManagedScheduledExecutorServiceConfig;
import org.glassfish.concurrent.runtime.deployer.ManagedThreadFactoryConfig;
import org.glassfish.enterprise.concurrent.ContextServiceImpl;
import org.glassfish.enterprise.concurrent.ManagedExecutorServiceAdapter;
import org.glassfish.enterprise.concurrent.ManagedExecutorServiceImpl;
import org.glassfish.enterprise.concurrent.ManagedScheduledExecutorServiceAdapter;
import org.glassfish.enterprise.concurrent.ManagedScheduledExecutorServiceImpl;
import org.glassfish.enterprise.concurrent.ManagedThreadFactoryImpl;
import org.glassfish.resourcebase.resources.api.ResourceInfo;

public class ConcurrentObjectFactory
implements ObjectFactory {
    private static final Logger LOGGER = Logger.getLogger("jakarta.enterprise.concurrent", "org.glassfish.concurrent.LogMessages");

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        Reference ref = (Reference)obj;
        LOGGER.log(Level.FINE, "ConcurrentNamingObjectFactory: {0} Name:{1}", new Object[]{ref, name});
        BaseConfig config = (BaseConfig)ref.get(0).getContent();
        ResourceInfo resourceInfo = (ResourceInfo)ref.get(1).getContent();
        ContextServiceImpl instance = null;
        switch (config.getType()) {
            case CONTEXT_SERVICE: {
                instance = this.getContextService((ContextServiceConfig)config, resourceInfo);
                break;
            }
            case MANAGED_EXECUTOR_SERVICE: {
                instance = this.getManagedExecutorService((ManagedExecutorServiceConfig)config, resourceInfo);
                break;
            }
            case MANAGED_SCHEDULED_EXECUTOR_SERVICE: {
                instance = this.getManagedScheduledExecutorService((ManagedScheduledExecutorServiceConfig)config, resourceInfo);
                break;
            }
            case MANAGED_THREAD_FACTORY: {
                instance = this.getManagedThreadFactory((ManagedThreadFactoryConfig)config, resourceInfo);
                break;
            }
        }
        return instance;
    }

    private ContextServiceImpl getContextService(ContextServiceConfig config, ResourceInfo resourceInfo) {
        ContextServiceImpl contextService = this.getRuntime().getContextService(resourceInfo, config);
        return contextService;
    }

    private ManagedThreadFactoryImpl getManagedThreadFactory(ManagedThreadFactoryConfig config, ResourceInfo resourceInfo) {
        ManagedThreadFactoryImpl managedThreadFactory = this.getRuntime().getManagedThreadFactory(resourceInfo, config);
        return managedThreadFactory;
    }

    private ManagedExecutorServiceAdapter getManagedExecutorService(ManagedExecutorServiceConfig config, ResourceInfo resourceInfo) {
        ManagedExecutorServiceImpl mes = this.getRuntime().getManagedExecutorService(resourceInfo, config);
        return mes.getAdapter();
    }

    private ManagedScheduledExecutorServiceAdapter getManagedScheduledExecutorService(ManagedScheduledExecutorServiceConfig config, ResourceInfo resourceInfo) {
        ManagedScheduledExecutorServiceImpl mes = this.getRuntime().getManagedScheduledExecutorService(resourceInfo, config);
        return mes.getAdapter();
    }

    private ConcurrentRuntime getRuntime() {
        return ConcurrentRuntime.getRuntime();
    }
}

