/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.common;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.DeploymentContextImpl;
import org.glassfish.logging.annotation.LogMessageInfo;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

public class AnnotationScanner
extends ClassVisitor {
    public static final Logger deplLogger = DeploymentContextImpl.deplLogger;
    @LogMessageInfo(message="Exception while scanning {0}", level="WARNING")
    private static final String SCANNING_EXCEPTION = "NCLS-DEPLOYMENT-00001";
    @LogMessageInfo(message="Error scan jar entry {0} {1}", level="WARNING")
    private static final String JAR_ENTRY_SCAN_ERROR = "NCLS-DEPLOYMENT-00002";
    @LogMessageInfo(message="Failed to scan archive for annotations", level="WARNING")
    private static final String FAILED_ANNOTATION_SCAN = "NCLS-DEPLOYMENT-00003";

    public AnnotationScanner() {
        super(589824);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
    }

    public void visitSource(String s, String s1) {
    }

    public void visitOuterClass(String s, String s1, String s2) {
    }

    public AnnotationVisitor visitAnnotation(String s, boolean b) {
        return null;
    }

    public void visitAttribute(Attribute attribute) {
    }

    public void visitInnerClass(String s, String s1, String s2, int i) {
    }

    public FieldVisitor visitField(int i, String s, String s1, String s2, Object o) {
        return null;
    }

    public MethodVisitor visitMethod(int i, String s, String s1, String s2, String[] strings) {
        return null;
    }

    public void visitEnd() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scanArchive(ReadableArchive archive) {
        try {
            int crFlags = 7;
            Enumeration entries = archive.entries();
            while (entries.hasMoreElements()) {
                String entryName = (String)entries.nextElement();
                if (entryName.endsWith(".class")) {
                    InputStream is = archive.getEntry(entryName);
                    try {
                        ClassReader cr = new ClassReader(is);
                        cr.accept((ClassVisitor)this, crFlags);
                        continue;
                    }
                    catch (Exception e) {
                        LogRecord lr = new LogRecord(Level.WARNING, SCANNING_EXCEPTION);
                        Object[] args = new Object[]{entryName};
                        lr.setParameters(args);
                        lr.setThrown(e);
                        deplLogger.log(lr);
                        continue;
                    }
                    finally {
                        is.close();
                        continue;
                    }
                }
                if (!entryName.endsWith(".jar")) continue;
                try {
                    File archiveRoot = new File(archive.getURI());
                    File file = new File(archiveRoot, entryName);
                    try (JarFile jarFile = new JarFile(file);){
                        Enumeration<JarEntry> jarEntries = jarFile.entries();
                        while (jarEntries.hasMoreElements()) {
                            JarEntry entry = jarEntries.nextElement();
                            String jarEntryName = entry.getName();
                            if (!jarEntryName.endsWith(".class")) continue;
                            try (InputStream is = jarFile.getInputStream(entry);){
                                ClassReader cr = new ClassReader(is);
                                cr.accept((ClassVisitor)this, crFlags);
                            }
                        }
                    }
                }
                catch (IOException ioe) {
                    Object[] args = new Object[]{entryName, ioe.getMessage()};
                    deplLogger.log(Level.WARNING, JAR_ENTRY_SCAN_ERROR, args);
                }
            }
        }
        catch (Exception e) {
            deplLogger.log(Level.WARNING, FAILED_ANNOTATION_SCAN, e);
        }
    }
}

