/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.versioning;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.glassfish.deployment.versioning.VersioningException;
import org.glassfish.deployment.versioning.VersioningSyntaxException;
import org.glassfish.deployment.versioning.VersioningWildcardException;

public class VersioningUtils {
    public static final LocalStringManagerImpl LOCALSTRINGS = new LocalStringManagerImpl(VersioningUtils.class);
    public static final String EXPRESSION_SEPARATOR = ":";
    public static final String EXPRESSION_WILDCARD = "*";
    public static final String REPOSITORY_DASH = "~";

    public static final String getUntaggedName(String appName) throws VersioningSyntaxException {
        int colonIndex;
        if (appName != null && !appName.isEmpty() && (colonIndex = appName.indexOf(EXPRESSION_SEPARATOR)) >= 0) {
            if (colonIndex == 0) {
                throw new VersioningSyntaxException(LOCALSTRINGS.getLocalString("versioning.deployment.invalid.appname1", "excepted application name before colon: {0}", new Object[]{appName}));
            }
            if (colonIndex == appName.length() - 1) {
                throw new VersioningSyntaxException(LOCALSTRINGS.getLocalString("versioning.deployment.invalid.appname2", "excepted version identifier after colon: {0}", new Object[]{appName}));
            }
            return appName.substring(0, colonIndex);
        }
        return appName;
    }

    public static final String getExpression(String appName) throws VersioningSyntaxException {
        int colonIndex;
        if (appName != null && !appName.isEmpty() && (colonIndex = appName.indexOf(EXPRESSION_SEPARATOR)) >= 0) {
            if (colonIndex == 0) {
                throw new VersioningSyntaxException(LOCALSTRINGS.getLocalString("versioning.deployment.invalid.appname1", "excepted application name before colon: {0}", new Object[]{appName}));
            }
            if (colonIndex == appName.length() - 1) {
                throw new VersioningSyntaxException(LOCALSTRINGS.getLocalString("versioning.deployment.invalid.appname2", "excepted version identifier after colon: {0}", new Object[]{appName}));
            }
            return appName.substring(colonIndex + 1, appName.length());
        }
        return null;
    }

    public static final void checkIdentifier(String appName) throws VersioningException {
        String identifier = VersioningUtils.getExpression(appName);
        if (identifier != null && identifier.contains(EXPRESSION_WILDCARD)) {
            throw new VersioningWildcardException(LOCALSTRINGS.getLocalString("versioning.deployment.wildcard.not.allowed", "Wildcard character(s) are not allowed in a version identifier."));
        }
    }

    public static final List<String> getVersions(String untaggedName, List<Application> allApplications) {
        ArrayList<String> allVersions = new ArrayList<String>();
        for (Application app : allApplications) {
            if (!app.getName().startsWith(untaggedName + EXPRESSION_SEPARATOR) && !app.getName().equals(untaggedName)) continue;
            allVersions.add(app.getName());
        }
        return allVersions;
    }

    public static final List<String> matchExpression(List<String> listVersion, String appName) throws VersioningException {
        if (listVersion.size() == 0) {
            return Collections.emptyList();
        }
        String expressionVersion = VersioningUtils.getExpression(appName);
        if (expressionVersion == null) {
            if (listVersion.contains(appName)) {
                return listVersion.subList(listVersion.indexOf(appName), listVersion.indexOf(appName) + 1);
            }
            throw new VersioningException(LOCALSTRINGS.getLocalString("versioning.deployment.version.notreg", "version {0} not registered", new Object[]{appName}));
        }
        if (expressionVersion.indexOf(EXPRESSION_WILDCARD) == -1) {
            if (listVersion.contains(appName)) {
                return listVersion.subList(listVersion.indexOf(appName), listVersion.indexOf(appName) + 1);
            }
            throw new VersioningException(LOCALSTRINGS.getLocalString("versioning.deployment.version.notreg", "Version {0} not registered", new Object[]{appName}));
        }
        StringTokenizer st = new StringTokenizer(expressionVersion, EXPRESSION_WILDCARD);
        String lastToken = null;
        ArrayList<String> matchedVersions = new ArrayList<String>(listVersion);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            for (String app : listVersion) {
                String identifier = VersioningUtils.getExpression(app);
                int lastTokenIndex = -1;
                if (lastToken != null) {
                    lastTokenIndex = identifier.indexOf(lastToken);
                }
                if (identifier != null) {
                    if (expressionVersion.startsWith(token) && !identifier.startsWith(token)) {
                        matchedVersions.remove(app);
                        continue;
                    }
                    if (expressionVersion.endsWith(token) && !identifier.endsWith(token)) {
                        matchedVersions.remove(app);
                        continue;
                    }
                    if (identifier.contains(token.subSequence(0, token.length() - 1)) && identifier.indexOf(token) > lastTokenIndex) continue;
                    matchedVersions.remove(app);
                    continue;
                }
                matchedVersions.remove(app);
            }
            lastToken = token;
        }
        return matchedVersions;
    }

    public static final String getRepositoryName(String appName) {
        return appName.replace(EXPRESSION_SEPARATOR, REPOSITORY_DASH);
    }

    public static final Boolean isUntagged(String appName) throws VersioningSyntaxException {
        Boolean isUntagged = false;
        String untaggedName = VersioningUtils.getUntaggedName(appName);
        if (untaggedName != null && untaggedName.equals(appName)) {
            isUntagged = true;
        }
        return isUntagged;
    }

    public static final Boolean isVersionExpression(String appName) throws VersioningSyntaxException {
        Boolean isVersionExpression = false;
        if (appName != null) {
            isVersionExpression = VersioningUtils.isUntagged(appName) == false;
        }
        return isVersionExpression;
    }

    public static final Boolean isVersionExpressionWithWildCard(String appName) throws VersioningSyntaxException {
        return VersioningUtils.isVersionExpression(appName) != false && appName.contains(EXPRESSION_WILDCARD);
    }

    public static final Boolean isVersionIdentifier(String appName) throws VersioningSyntaxException {
        return VersioningUtils.isVersionExpression(appName) != false && !appName.contains(EXPRESSION_WILDCARD);
    }
}

