/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.enterprise.iiop.impl;

import com.sun.corba.ee.impl.misc.ORBUtility;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.transport.Acceptor;
import com.sun.corba.ee.spi.transport.ORBSocketFactory;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.security.integration.AppClientSSL;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.glassfish.api.admin.ProcessEnvironment;
import org.glassfish.enterprise.iiop.api.IIOPSSLUtil;
import org.glassfish.enterprise.iiop.util.IIOPUtils;
import org.glassfish.enterprise.iiop.util.NotServerException;
import org.glassfish.grizzly.config.dom.Ssl;
import org.glassfish.internal.api.Globals;
import org.glassfish.orb.admin.config.IiopListener;
import org.glassfish.orb.admin.config.IiopService;
import org.glassfish.security.common.CipherInfo;

public class IIOPSSLSocketFactory
implements ORBSocketFactory {
    private static final Logger _logger = LogDomains.getLogger(IIOPSSLSocketFactory.class, (String)"javax.enterprise.resource.corba");
    private static final String SSL_MUTUALAUTH = "SSL_MUTUALAUTH";
    private static final String PERSISTENT_SSL = "PERSISTENT_SSL";
    private static final int BACKLOG = 50;
    private static final String SO_KEEPALIVE = "fish.payara.SO_KEEPALIVE";
    private static final String SO_KEEPALIVE_DEPRECATED = "fish.payara.SOKeepAlive";
    private Map<Integer, SSLInfo> portToSSLInfo = new ConcurrentHashMap<Integer, SSLInfo>();
    private SSLInfo clientSslInfo = null;
    private ORB orb;

    public IIOPSSLSocketFactory() {
        try {
            boolean notServerOrACC;
            ProcessEnvironment penv = null;
            ProcessEnvironment.ProcessType processType = null;
            boolean bl = notServerOrACC = Globals.getDefaultHabitat() == null;
            if (!notServerOrACC) {
                penv = (ProcessEnvironment)Globals.get(ProcessEnvironment.class);
                processType = penv.getProcessType();
            }
            if (processType != null && processType.isServer()) {
                Ssl outboundSsl;
                Config conf = (Config)Globals.getDefaultHabitat().getService(Config.class, "default-instance-name", new Annotation[0]);
                IiopService iiopBean = (IiopService)conf.getExtensionByType(IiopService.class);
                List iiopListeners = iiopBean.getIiopListener();
                for (IiopListener listener : iiopListeners) {
                    SSLInfo sslInfo;
                    Ssl ssl = listener.getSsl();
                    boolean securityEnabled = Boolean.valueOf(listener.getSecurityEnabled());
                    if (!securityEnabled) continue;
                    if (ssl != null) {
                        boolean tlsEnabled12 = Boolean.valueOf(ssl.getTls12Enabled());
                        boolean tlsEnabled13 = Boolean.valueOf(ssl.getTls13Enabled());
                        sslInfo = this.init(ssl.getCertNickname(), ssl.getSsl3TlsCiphers(), tlsEnabled12, tlsEnabled13);
                    } else {
                        sslInfo = this.getDefaultSslInfo();
                    }
                    this.portToSSLInfo.put(new Integer(listener.getPort()), sslInfo);
                }
                if (iiopBean.getSslClientConfig() != null && iiopBean.getSslClientConfig().getSsl() != null && (outboundSsl = iiopBean.getSslClientConfig().getSsl()) != null) {
                    boolean tlsEnabled12 = Boolean.valueOf(outboundSsl.getTls12Enabled());
                    boolean tlsEnabled13 = Boolean.valueOf(outboundSsl.getTls13Enabled());
                    this.clientSslInfo = this.init(outboundSsl.getCertNickname(), outboundSsl.getSsl3TlsCiphers(), tlsEnabled12, tlsEnabled13);
                }
                if (this.clientSslInfo == null) {
                    this.clientSslInfo = this.getDefaultSslInfo();
                }
            } else {
                IIOPSSLUtil sslUtil;
                AppClientSSL clientSsl;
                this.clientSslInfo = processType == ProcessEnvironment.ProcessType.ACC ? ((clientSsl = (AppClientSSL)(sslUtil = (IIOPSSLUtil)Globals.getDefaultHabitat().getService(IIOPSSLUtil.class, new Annotation[0])).getAppClientSSL()) != null ? this.init(clientSsl.getCertNickname(), clientSsl.getSsl3TlsCiphers(), clientSsl.getTls12Enabled(), clientSsl.getTls13Enabled()) : this.getDefaultSslInfo()) : this.getDefaultSslInfo();
            }
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "iiop.init_exception", e);
            throw new IllegalStateException(e);
        }
    }

    private SSLInfo getDefaultSslInfo() throws Exception {
        return this.init(null, null, true, true);
    }

    private SSLInfo init(String alias, String ssl3TlsCiphers, boolean tlsEnabled12, boolean tlsEnabled13) throws Exception {
        String protocol = tlsEnabled13 ? "TLSv1.3" : (tlsEnabled12 ? "TLSv1.2" : "SSL");
        String[] ssl3TlsCipherArr = null;
        if (tlsEnabled12 || tlsEnabled13) {
            ssl3TlsCipherArr = this.getEnabledCipherSuites(ssl3TlsCiphers, tlsEnabled12, tlsEnabled13);
        }
        SSLContext ctx = SSLContext.getInstance(protocol);
        if (Globals.getDefaultHabitat() != null) {
            IIOPSSLUtil sslUtil = (IIOPSSLUtil)Globals.getDefaultHabitat().getService(IIOPSSLUtil.class, new Annotation[0]);
            KeyManager[] mgrs = sslUtil.getKeyManagers(alias);
            ctx.init(mgrs, sslUtil.getTrustManagers(), sslUtil.getInitializedSecureRandom());
        }
        SSLInfo newInfo = new SSLInfo(ctx, ssl3TlsCipherArr);
        if (tlsEnabled12) {
            newInfo.addProtocol("TLSv1.2");
        }
        if (tlsEnabled13) {
            newInfo.addProtocol("TLSv1.3");
        }
        return newInfo;
    }

    public void setORB(ORB orb) {
        this.orb = orb;
    }

    public ServerSocket createServerSocket(String type, InetSocketAddress inetSocketAddress) throws IOException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Creating server socket for type =" + type + " inetSocketAddress =" + inetSocketAddress);
        }
        if (type.equals(SSL_MUTUALAUTH) || type.equals("SSL") || type.equals(PERSISTENT_SSL)) {
            return this.createSSLServerSocket(type, inetSocketAddress);
        }
        ServerSocket serverSocket = null;
        if (this.orb.getORBData().acceptorSocketType().equals("SocketChannel")) {
            ServerSocketChannel serverSocketChannel = ServerSocketChannel.open();
            serverSocket = serverSocketChannel.socket();
        } else {
            serverSocket = new ServerSocket();
        }
        serverSocket.bind(inetSocketAddress);
        return serverSocket;
    }

    public Socket createSocket(String type, InetSocketAddress inetSocketAddress) throws IOException {
        try {
            String host = inetSocketAddress.getHostName();
            int port = inetSocketAddress.getPort();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "createSocket(" + type + ", " + host + ", " + port + ")");
            }
            if (type.equals("SSL") || type.equals(SSL_MUTUALAUTH)) {
                return this.createSSLSocket(host, port);
            }
            Socket socket = null;
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Creating CLEAR_TEXT socket for:" + port);
            }
            if (this.orb.getORBData().connectionSocketType().equals("SocketChannel")) {
                SocketChannel socketChannel = ORBUtility.openSocketChannel((SocketAddress)inetSocketAddress);
                socket = socketChannel.socket();
            } else {
                socket = new Socket(inetSocketAddress.getHostName(), inetSocketAddress.getPort());
            }
            this.enableSOKeepAliveAsRequired(socket);
            socket.setTcpNoDelay(true);
            return socket;
        }
        catch (Exception ex) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Exception creating socket", ex);
            }
            throw new RuntimeException(ex);
        }
    }

    public void setAcceptedSocketOptions(Acceptor acceptor, ServerSocket serverSocket, Socket socket) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "setAcceptedSocketOptions: " + acceptor + " " + serverSocket + " " + socket);
        }
        try {
            socket.setTcpNoDelay(true);
            this.enableSOKeepAliveAsRequired(socket);
        }
        catch (SocketException ex) {
            throw new RuntimeException(ex);
        }
    }

    private ServerSocket createSSLServerSocket(String type, InetSocketAddress inetSocketAddress) throws IOException {
        if (inetSocketAddress == null) {
            throw new IOException(this.getFormatMessage("iiop.invalid_sslserverport", new Object[]{null}));
        }
        int port = inetSocketAddress.getPort();
        Integer iport = port;
        SSLInfo sslInfo = this.portToSSLInfo.get(iport);
        if (sslInfo == null) {
            throw new IOException(this.getFormatMessage("iiop.invalid_sslserverport", new Object[]{iport}));
        }
        SSLServerSocketFactory ssf = sslInfo.getContext().getServerSocketFactory();
        String[] ciphers = null;
        String[] cs = null;
        if (_logger.isLoggable(Level.FINE)) {
            cs = ssf.getSupportedCipherSuites();
            for (int i = 0; i < cs.length; ++i) {
                _logger.log(Level.FINE, "Cipher Suite: " + cs[i]);
            }
        }
        ServerSocket ss = null;
        try {
            ss = ssf.createServerSocket(port, 50, inetSocketAddress.getAddress());
            if (ciphers != null) {
                ((SSLServerSocket)ss).setEnabledCipherSuites(ciphers);
            }
            if (sslInfo.allowedProtocols.size() > 0) {
                ArrayList<String> socketSupported = new ArrayList<String>(Arrays.asList(((SSLServerSocket)ss).getSupportedProtocols()));
                ArrayList<String> allowedProtocols = new ArrayList<String>();
                for (String protocolName : sslInfo.allowedProtocols) {
                    if (!socketSupported.contains(protocolName)) continue;
                    allowedProtocols.add(protocolName);
                }
                if (allowedProtocols.size() > 0) {
                    ((SSLServerSocket)ss).setEnabledProtocols(allowedProtocols.toArray(new String[allowedProtocols.size()]));
                }
            }
        }
        catch (IOException e) {
            _logger.log(Level.SEVERE, "iiop.createsocket_exception", new Object[]{type, String.valueOf(port)});
            _logger.log(Level.SEVERE, "", e);
            throw e;
        }
        try {
            if (type.equals(SSL_MUTUALAUTH)) {
                _logger.log(Level.FINE, "Setting Mutual auth");
                ((SSLServerSocket)ss).setNeedClientAuth(true);
            }
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "iiop.cipher_exception", e);
            throw new IOException(e.getMessage());
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Created server socket:" + ss);
        }
        return ss;
    }

    private Socket createSSLSocket(String host, int port) throws IOException {
        SSLSocket socket = null;
        SSLSocketFactory factory = null;
        try {
            factory = this.clientSslInfo.getContext().getSocketFactory();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Creating SSL Socket for host:" + host + " port:" + port);
            }
            String[] clientCiphers = null;
            socket = (SSLSocket)factory.createSocket(host, port);
            if (clientCiphers != null) {
                socket.setEnabledCipherSuites(clientCiphers);
            }
            this.enableSOKeepAliveAsRequired(socket);
        }
        catch (Exception e) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "iiop.createsocket_exception", new Object[]{host, String.valueOf(port)});
                _logger.log(Level.FINE, "", e);
            }
            IOException e2 = new IOException("Error opening SSL socket to host=" + host + " port=" + port);
            e2.initCause(e);
            throw e2;
        }
        return socket;
    }

    private String[] getEnabledCipherSuites(String cipherSuiteStr, boolean tlsEnabled12, boolean tlsEnabled13) {
        String[] cipherArr = null;
        if (cipherSuiteStr != null && cipherSuiteStr.length() > 0) {
            ArrayList<String> cipherList = new ArrayList<String>();
            StringTokenizer tokens = new StringTokenizer(cipherSuiteStr, ",");
            while (tokens.hasMoreTokens()) {
                CipherInfo cipherInfo;
                String cipher;
                String cipherAction = tokens.nextToken();
                if (cipherAction.startsWith("+")) {
                    cipher = cipherAction.substring(1);
                    cipherInfo = CipherInfo.getCipherInfo((String)cipher);
                    if (cipherInfo != null && this.isValidProtocolCipher(cipherInfo, tlsEnabled12, tlsEnabled13)) {
                        cipherList.add(cipherInfo.getCipherName());
                        continue;
                    }
                    throw new IllegalStateException(this.getFormatMessage("iiop.unknown_cipher", new Object[]{cipher}));
                }
                if (cipherAction.startsWith("-")) {
                    cipher = cipherAction.substring(1);
                    cipherInfo = CipherInfo.getCipherInfo((String)cipher);
                    if (cipherInfo != null && this.isValidProtocolCipher(cipherInfo, tlsEnabled12, tlsEnabled13)) continue;
                    throw new IllegalStateException(this.getFormatMessage("iiop.unknown_cipher", new Object[]{cipher}));
                }
                if (cipherAction.trim().length() <= 0) continue;
                throw new IllegalStateException(this.getFormatMessage("iiop.invalid_cipheraction", new Object[]{cipherAction}));
            }
            cipherArr = cipherList.toArray(new String[cipherList.size()]);
        }
        return cipherArr;
    }

    private boolean isValidProtocolCipher(CipherInfo cipherInfo, boolean tlsEnabled12, boolean tlsEnabled13) {
        return tlsEnabled12 && cipherInfo.isTLS() || tlsEnabled13 && cipherInfo.isTLS();
    }

    private void enableSOKeepAliveAsRequired(Socket socket) throws SocketException {
        boolean shouldSet;
        block10: {
            shouldSet = false;
            try {
                IiopService iiopService = IIOPUtils.getInstance().getIiopService();
                for (IiopListener iiopListener : IIOPUtils.getInstance().getIiopService().getIiopListener()) {
                    if (Integer.valueOf(iiopListener.getPort()).intValue() != socket.getLocalPort()) continue;
                    if (System.getProperty(SO_KEEPALIVE) == null && Boolean.getBoolean(SO_KEEPALIVE_DEPRECATED) || Boolean.getBoolean(SO_KEEPALIVE)) {
                        if (this.soKeepAlivePropertyPresentOnIiopListener(iiopListener)) {
                            if (this.soKeepAlivePropertyEnabledOnIiopListener(iiopListener)) {
                                shouldSet = true;
                            }
                        } else {
                            shouldSet = true;
                        }
                    } else if (this.soKeepAlivePropertyPresentOnIiopListener(iiopListener) && this.soKeepAlivePropertyEnabledOnIiopListener(iiopListener)) {
                        shouldSet = true;
                    }
                    break;
                }
            }
            catch (NotServerException notServerException) {
                if (!Boolean.getBoolean(SO_KEEPALIVE) || socket.getKeepAlive()) break block10;
                shouldSet = true;
            }
        }
        if (shouldSet) {
            _logger.log(Level.FINER, "Enabling SO_KEEPALIVE");
            socket.setKeepAlive(true);
        }
    }

    private boolean soKeepAlivePropertyPresentOnIiopListener(IiopListener iiopListener) {
        boolean soKeepAlivePropertyPresentOnListener = false;
        if (iiopListener.getPropertyValue(SO_KEEPALIVE) != null || iiopListener.getPropertyValue(SO_KEEPALIVE_DEPRECATED) != null) {
            soKeepAlivePropertyPresentOnListener = true;
        }
        return soKeepAlivePropertyPresentOnListener;
    }

    private boolean soKeepAlivePropertyEnabledOnIiopListener(IiopListener iiopListener) {
        boolean soKeepAliveEnabledOnListener = false;
        if (iiopListener.getPropertyValue(SO_KEEPALIVE) == null && Boolean.valueOf(iiopListener.getPropertyValue(SO_KEEPALIVE_DEPRECATED)).booleanValue() || Boolean.valueOf(iiopListener.getPropertyValue(SO_KEEPALIVE)).booleanValue()) {
            soKeepAliveEnabledOnListener = true;
        }
        return soKeepAliveEnabledOnListener;
    }

    private String getFormatMessage(String key, Object[] params) {
        return MessageFormat.format(_logger.getResourceBundle().getString(key), params);
    }

    class SSLInfo {
        private final SSLContext ctx;
        private String[] ssl3TlsCiphers = null;
        private ArrayList<String> allowedProtocols;

        SSLInfo(SSLContext ctx, String[] ssl3TlsCiphers) {
            this.ctx = ctx;
            this.ssl3TlsCiphers = ssl3TlsCiphers;
            this.allowedProtocols = new ArrayList();
        }

        SSLContext getContext() {
            return this.ctx;
        }

        void addProtocol(String protocol) {
            this.allowedProtocols.add(protocol);
        }

        String[] getSsl3TlsCiphers() {
            return this.ssl3TlsCiphers;
        }
    }
}

