/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.micro.cdi.extension.cluster;

import com.sun.enterprise.container.common.impl.util.ClusteredSingletonLookupImplBase;
import com.sun.enterprise.container.common.spi.ClusteredSingletonLookup;
import fish.payara.cluster.Clustered;
import fish.payara.micro.cdi.extension.cluster.ClusterScopeContext;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import java.lang.annotation.Annotation;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

public class ClusteredSingletonLookupImpl
extends ClusteredSingletonLookupImplBase {
    private final BeanManager beanManager;
    private final AtomicReference<String> sessionKey = new AtomicReference();

    public ClusteredSingletonLookupImpl(BeanManager beanManager, String componentId) {
        super(componentId, ClusteredSingletonLookup.SingletonType.CDI);
        this.beanManager = beanManager;
    }

    public String getClusteredSessionKey() {
        return this.sessionKey.get();
    }

    void setClusteredSessionKeyIfNotSet(Class<?> beanClass, Clustered clusteredAnnotation) {
        this.sessionKey.updateAndGet(v -> v != null ? v : this.makeSessionKey(beanClass, clusteredAnnotation));
    }

    private String makeSessionKey(Class<?> beanClass, Clustered clusteredAnnotation) {
        Set managedBeans = this.beanManager.getBeans(beanClass, new Annotation[0]);
        if (managedBeans.size() > 1) {
            throw new IllegalArgumentException("Multiple beans found for " + beanClass);
        }
        if (managedBeans.size() == 1) {
            Bean bean = (Bean)managedBeans.iterator().next();
            return ClusterScopeContext.getBeanName(bean, ClusterScopeContext.getAnnotation(this.beanManager, bean));
        }
        return ClusterScopeContext.firstNonNull(clusteredAnnotation.keyName(), beanClass.getName());
    }
}

